/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.commands;

import org.mvplugins.multiverse.core.command.LegacyAliasCommand;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.command.flag.CommandFlag;
import org.mvplugins.multiverse.core.command.flag.CommandFlagsManager;
import org.mvplugins.multiverse.core.command.flag.ParsedCommandFlags;
import org.mvplugins.multiverse.core.command.flags.RemovePlayerFlags;
import org.mvplugins.multiverse.core.commands.CoreCommand;
import org.mvplugins.multiverse.core.locale.MVCorei18n;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.core.utils.result.AsyncAttemptsAggregate;
import org.mvplugins.multiverse.core.world.LoadedMultiverseWorld;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.core.world.helpers.PlayerWorldTeleporter;
import org.mvplugins.multiverse.core.world.options.UnloadWorldOptions;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandAlias;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Optional;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
class UnloadCommand
extends CoreCommand {
    private final WorldManager worldManager;
    private final PlayerWorldTeleporter playerWorldTeleporter;
    private final Flags flags;

    @Inject
    UnloadCommand(@NotNull WorldManager worldManager, @NotNull PlayerWorldTeleporter playerWorldTeleporter, @NotNull Flags flags) {
        this.worldManager = worldManager;
        this.playerWorldTeleporter = playerWorldTeleporter;
        this.flags = flags;
    }

    @Subcommand(value="unload")
    @CommandPermission(value="multiverse.core.unload")
    @CommandCompletion(value="@mvworlds @flags:groupName=mvunload")
    @Syntax(value="<world>")
    @Description(value="{@@mv-core.unload.description}")
    void onUnloadCommand(MVCommandIssuer issuer, @Syntax(value="<world>") @Description(value="{@@mv-core.unload.world.description}") LoadedMultiverseWorld world, @Optional @Syntax(value="[--remove-players] [--no-save]") @Description(value="{@@mv-core.gamerules.description.page}") String[] flagArray) {
        ParsedCommandFlags parsedFlags = this.flags.parse(flagArray);
        issuer.sendInfo((MessageKeyProvider)MVCorei18n.UNLOAD_UNLOADING, MessageReplacement.Replace.WORLD.with(world.getAliasOrName()));
        AsyncAttemptsAggregate future = parsedFlags.hasFlag(this.flags.removePlayers) ? this.playerWorldTeleporter.removeFromWorld(world) : AsyncAttemptsAggregate.emptySuccess();
        future.onSuccess(() -> this.doWorldUnloading(issuer, world, parsedFlags)).onFailure(() -> issuer.sendError("Failed to teleport one or more players out of the world!", new MessageReplacement[0]));
    }

    private void doWorldUnloading(MVCommandIssuer issuer, LoadedMultiverseWorld world, ParsedCommandFlags parsedFlags) {
        UnloadWorldOptions unloadWorldOptions = UnloadWorldOptions.world(world).unloadBukkitWorld(!parsedFlags.hasFlag(this.flags.noUnloadBukkitWorld)).saveBukkitWorld(!parsedFlags.hasFlag(this.flags.noSave));
        this.worldManager.unloadWorld(unloadWorldOptions).onSuccess(loadedWorld -> {
            CoreLogging.fine("World unload success: " + String.valueOf(loadedWorld), new Object[0]);
            issuer.sendInfo((MessageKeyProvider)MVCorei18n.UNLOAD_SUCCESS, MessageReplacement.Replace.WORLD.with(loadedWorld.getName()));
        }).onFailure(failure -> {
            CoreLogging.fine("World unload failure: " + String.valueOf(failure), new Object[0]);
            issuer.sendError(failure.getFailureMessage());
        });
    }

    @Service
    private static final class Flags
    extends RemovePlayerFlags {
        private static final String NAME = "mvunload";
        private final CommandFlag noUnloadBukkitWorld = this.flag(((CommandFlag.Builder)CommandFlag.builder("--no-unload-bukkit-world").addAlias("-b")).build());
        private final CommandFlag noSave = this.flag(((CommandFlag.Builder)CommandFlag.builder("--no-save").addAlias("-n")).build());

        @Inject
        private Flags(@NotNull CommandFlagsManager flagsManager) {
            super(NAME, flagsManager);
        }
    }

    @Service
    private static final class LegacyAlias
    extends UnloadCommand
    implements LegacyAliasCommand {
        @Inject
        LegacyAlias(@NotNull WorldManager worldManager, @NotNull PlayerWorldTeleporter playerWorldTeleporter, @NotNull Flags flags) {
            super(worldManager, playerWorldTeleporter, flags);
        }

        @Override
        @CommandAlias(value="mvunload")
        void onUnloadCommand(MVCommandIssuer issuer, LoadedMultiverseWorld world, String[] flags) {
            super.onUnloadCommand(issuer, world, flags);
        }
    }
}

