/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.config.node;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mvplugins.multiverse.core.config.node.Node;
import org.mvplugins.multiverse.core.config.node.ValueNode;
import org.mvplugins.multiverse.external.commentedconfiguration.setting.CommentedNode;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.external.vavr.control.Option;

public class NodeGroup
implements Collection<Node> {
    private final Collection<Node> nodes;
    private final List<String> nodeNames;
    private final Map<String, Node> nodesMap;

    public NodeGroup() {
        this.nodes = new ArrayList<Node>();
        this.nodeNames = new ArrayList<String>();
        this.nodesMap = new HashMap<String, Node>();
    }

    public NodeGroup(@NotNull Collection<Node> nodes) {
        this.nodes = nodes;
        this.nodesMap = new HashMap<String, Node>(nodes.size());
        this.nodeNames = new ArrayList<String>(nodes.size());
        nodes.forEach(this::addNodeIndex);
    }

    private void addNodeIndex(@NotNull Node node) {
        if (node instanceof ValueNode) {
            ValueNode valueNode = (ValueNode)node;
            valueNode.getName().peek(name -> {
                this.nodeNames.add((String)name);
                this.nodesMap.put((String)name, node);
                Arrays.stream(valueNode.getAliases()).forEach(alias -> this.nodesMap.put((String)alias, node));
            });
        }
    }

    private void removeNodeIndex(@NotNull Node node) {
        if (node instanceof ValueNode) {
            ValueNode valueNode = (ValueNode)node;
            valueNode.getName().peek(name -> {
                this.nodeNames.remove(name);
                this.nodesMap.remove(name);
                Arrays.stream(valueNode.getAliases()).forEach(alias -> this.nodesMap.remove(alias, node));
            });
        }
    }

    @NotNull
    public Collection<String> getNames() {
        return this.nodeNames;
    }

    @NotNull
    public Option<Node> findNode(@Nullable String name) {
        return Option.of(this.nodesMap.get(name));
    }

    @NotNull
    public <T extends Node> Option<T> findNode(@Nullable String name, @NotNull Class<T> type) {
        return Option.of(this.nodesMap.get(name)).map(node -> type.isAssignableFrom(node.getClass()) ? node : null);
    }

    @Override
    public int size() {
        return this.nodes.size();
    }

    @Override
    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.nodes.contains(o);
    }

    @Override
    @NotNull
    public Iterator<Node> iterator() {
        return this.nodes.iterator();
    }

    @Override
    public Object @NotNull [] toArray() {
        return this.nodes.toArray();
    }

    @Override
    public <T> T @NotNull [] toArray(T @NotNull [] ts) {
        return this.nodes.toArray(ts);
    }

    @Override
    public boolean add(Node node) {
        if (this.nodes.add(node)) {
            this.addNodeIndex(node);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (this.nodes.remove(o) && o instanceof CommentedNode) {
            this.removeNodeIndex((Node)o);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> collection) {
        return this.nodes.containsAll(collection);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends Node> collection) {
        return this.nodes.addAll(collection);
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> collection) {
        return this.nodes.removeAll(collection);
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> collection) {
        return this.nodes.retainAll(collection);
    }

    @Override
    public void clear() {
        this.nodes.clear();
    }
}

