/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.config.node.functions;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.mvplugins.multiverse.core.config.node.functions.NodeStringParser;
import org.mvplugins.multiverse.core.exceptions.MultiverseException;
import org.mvplugins.multiverse.external.acf.commands.ACFUtil;
import org.mvplugins.multiverse.external.vavr.control.Option;
import org.mvplugins.multiverse.external.vavr.control.Try;

public final class DefaultStringParserProvider {
    private static final Map<Class<?>, NodeStringParser<?>> PARSERS = new HashMap();
    private static final NodeStringParser<Enum> ENUM_STRING_PARSER = (input, type) -> Try.of(() -> Enum.valueOf(type, input.toUpperCase(Locale.ENGLISH)));
    private static final NodeStringParser<String> STRING_STRING_PARSER = (input, type) -> Try.of(() -> input);
    private static final NodeStringParser<Boolean> BOOLEAN_STRING_PARSER = (input, type) -> Try.of(() -> switch (String.valueOf(input).toLowerCase(Locale.ENGLISH)) {
        case "t", "true", "on", "y", "yes", "1", "allow" -> true;
        case "f", "false", "off", "n", "no", "0", "deny" -> false;
        default -> throw new MultiverseException("Unable to convert '" + input + "' to boolean. Please use 'true' or 'false'");
    });
    private static final NodeStringParser<Integer> INTEGER_STRING_PARSER = (input, type) -> Try.of(() -> ACFUtil.parseInt(input)).flatMap(number -> Option.of(number).toTry(() -> new MultiverseException("Unable to convert '" + input + "' to number. (integer)")));
    private static final NodeStringParser<Double> DOUBLE_STRING_PARSER = (input, type) -> Try.of(() -> ACFUtil.parseDouble(input)).flatMap(number -> Option.of(number).toTry(() -> new MultiverseException("Unable to convert '" + input + "' to number. (double)")));
    private static final NodeStringParser<Float> FLOAT_STRING_PARSER = (input, type) -> Try.of(() -> ACFUtil.parseFloat(input)).flatMap(number -> Option.of(number).toTry(() -> new MultiverseException("Unable to convert '" + input + "' to number. (float)")));
    private static final NodeStringParser<Long> LONG_STRING_PARSER = (input, type) -> Try.of(() -> ACFUtil.parseLong(input)).flatMap(number -> Option.of(number).toTry(() -> new MultiverseException("Unable to convert '" + input + "' to number. (long)")));

    public static void addDefaultStringParser(Class<?> clazz, NodeStringParser<?> parser) {
        PARSERS.put(clazz, parser);
    }

    public static <T> NodeStringParser<T> getDefaultStringParser(Class<T> clazz) {
        if (clazz.isEnum()) {
            return ENUM_STRING_PARSER;
        }
        return PARSERS.get(clazz);
    }

    private DefaultStringParserProvider() {
    }

    static {
        DefaultStringParserProvider.addDefaultStringParser(String.class, STRING_STRING_PARSER);
        DefaultStringParserProvider.addDefaultStringParser(Boolean.class, BOOLEAN_STRING_PARSER);
        DefaultStringParserProvider.addDefaultStringParser(Integer.class, INTEGER_STRING_PARSER);
        DefaultStringParserProvider.addDefaultStringParser(Double.class, DOUBLE_STRING_PARSER);
        DefaultStringParserProvider.addDefaultStringParser(Float.class, FLOAT_STRING_PARSER);
        DefaultStringParserProvider.addDefaultStringParser(Long.class, LONG_STRING_PARSER);
    }
}

