/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.destination;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.mvplugins.multiverse.core.destination.Destination;
import org.mvplugins.multiverse.core.destination.DestinationInstance;
import org.mvplugins.multiverse.core.destination.DestinationSuggestionPacket;
import org.mvplugins.multiverse.core.locale.MVCorei18n;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.permissions.CorePermissions;
import org.mvplugins.multiverse.core.utils.result.Attempt;
import org.mvplugins.multiverse.core.utils.result.FailureReason;
import org.mvplugins.multiverse.external.acf.locales.MessageKey;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.ApiStatus;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
public final class DestinationsProvider {
    private static final String SEPARATOR = ":";
    private final Map<String, Destination<?, ?, ?>> destinationMap;
    private final CorePermissions corePermissions;

    @Inject
    DestinationsProvider(@NotNull CorePermissions corePermissions) {
        this.corePermissions = corePermissions;
        this.destinationMap = new HashMap();
    }

    public void registerDestination(@NotNull Destination<?, ?, ?> destination) {
        this.destinationMap.put(destination.getIdentifier(), destination);
        this.corePermissions.addDestinationPermissions(destination);
    }

    @NotNull
    public Attempt<DestinationInstance<?, ?>, FailureReason> parseDestination(@NotNull String destinationString) {
        return this.parseDestination((CommandSender)Bukkit.getConsoleSender(), destinationString);
    }

    @ApiStatus.AvailableSince(value="5.1")
    @NotNull
    public Attempt<DestinationInstance<?, ?>, FailureReason> parseDestination(@NotNull CommandSender sender, @NotNull String destinationString) {
        String destinationParams;
        Destination<?, ?, ?> destination;
        String[] items = destinationString.split(SEPARATOR, 2);
        String idString = items[0];
        if (items.length < 2) {
            destination = this.getDestinationById("w");
            destinationParams = items[0];
        } else {
            destination = this.getDestinationById(idString);
            destinationParams = items[1];
        }
        if (destination == null) {
            return Attempt.failure(ParseFailureReason.INVALID_DESTINATION_ID, MessageReplacement.replace("{id}").with(idString), MessageReplacement.replace("{ids}").with(String.join((CharSequence)", ", this.destinationMap.keySet())));
        }
        return destination.getDestinationInstance(sender, destinationParams);
    }

    @Nullable
    public Destination<?, ?, ?> getDestinationById(@Nullable String identifier) {
        return this.destinationMap.get(identifier);
    }

    @NotNull
    public Collection<Destination<?, ?, ?>> getDestinations() {
        return this.destinationMap.values();
    }

    @NotNull
    public Collection<DestinationSuggestionPacket> suggestDestinations(@NotNull CommandSender sender, @Nullable String destinationParams) {
        return this.getDestinations().stream().flatMap(destination -> destination.suggestDestinations(sender, destinationParams).stream()).toList();
    }

    @ApiStatus.AvailableSince(value="5.1")
    @NotNull
    public Collection<String> suggestDestinationStrings(@NotNull CommandSender sender, @Nullable String destinationParams) {
        return this.suggestDestinations(sender, destinationParams).stream().map(DestinationSuggestionPacket::parsableString).toList();
    }

    public static enum ParseFailureReason implements FailureReason
    {
        INVALID_DESTINATION_ID(MVCorei18n.DESTINATION_PARSE_FAILUREREASON_INVALIDDESTINATIONID);

        private final MessageKeyProvider messageKey;

        private ParseFailureReason(MessageKeyProvider message) {
            this.messageKey = message;
        }

        @Override
        public MessageKey getMessageKey() {
            return this.messageKey.getMessageKey();
        }
    }
}

