/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.display.handlers;

import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.ConsoleCommandSender;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.display.handlers.BaseSendHandler;
import org.mvplugins.multiverse.core.locale.MVCorei18n;
import org.mvplugins.multiverse.core.locale.message.Message;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;

public class PagedSendHandler
extends BaseSendHandler<PagedSendHandler> {
    private boolean paginate = true;
    private boolean paginateInConsole = false;
    private boolean padEnd = true;
    private int linesPerPage = 8;
    private int targetPage = 1;

    public static PagedSendHandler create() {
        return new PagedSendHandler();
    }

    PagedSendHandler() {
    }

    @Override
    public void sendContent(@NotNull MVCommandIssuer issuer, @NotNull List<String> content) {
        if (!this.paginate || issuer.getIssuer() instanceof ConsoleCommandSender && !this.paginateInConsole) {
            this.sendNormal(issuer, content);
            return;
        }
        this.sendPaged(issuer, content);
    }

    private void sendNormal(@NotNull MVCommandIssuer issuer, @NotNull List<String> content) {
        if (this.filter.needToFilter()) {
            issuer.sendMessage(MVCorei18n.CONTENTDISPLAY_FILTER, MessageReplacement.replace("{filter}").with(this.filter));
        }
        content.forEach(issuer::sendMessage);
    }

    private void sendPaged(@NotNull MVCommandIssuer issuer, @NotNull List<String> content) {
        int totalPages = (content.size() + this.linesPerPage - 1) / this.linesPerPage;
        if (this.targetPage < 1 || this.targetPage > totalPages) {
            issuer.sendMessage(String.format("%sInvalid page number. Please enter a page number between 1 and %s", ChatColor.RED, totalPages));
            return;
        }
        if (this.filter.needToFilter()) {
            issuer.sendMessage("{page} {filter}", MessageReplacement.replace("{page}").with(Message.of((MessageKeyProvider)MVCorei18n.CONTENTDISPLAY_PAGE, MessageReplacement.replace("{current}").with(this.targetPage), MessageReplacement.replace("{total}").with(totalPages))), MessageReplacement.replace("{filter}").with(Message.of((MessageKeyProvider)MVCorei18n.CONTENTDISPLAY_FILTER, MessageReplacement.replace("{filter}").with(this.filter))));
        } else {
            issuer.sendMessage(MVCorei18n.CONTENTDISPLAY_PAGE, MessageReplacement.replace("{current}").with(this.targetPage), MessageReplacement.replace("{total}").with(totalPages));
        }
        int startIndex = (this.targetPage - 1) * this.linesPerPage;
        int pageEndIndex = startIndex + this.linesPerPage;
        int endIndex = Math.min(pageEndIndex, content.size());
        List<String> pageContent = content.subList(startIndex, endIndex);
        if (this.padEnd) {
            for (int i = 0; i < pageEndIndex - endIndex; ++i) {
                pageContent.add("");
            }
        }
        pageContent.forEach(issuer::sendMessage);
    }

    public PagedSendHandler doPagination(boolean paginate) {
        this.paginate = paginate;
        return this;
    }

    public PagedSendHandler doPaginationInConsole(boolean paginateInConsole) {
        this.paginateInConsole = paginateInConsole;
        return this;
    }

    public PagedSendHandler doEndPadding(boolean padEnd) {
        this.padEnd = padEnd;
        return this;
    }

    public PagedSendHandler withLinesPerPage(int linesPerPage) {
        this.linesPerPage = linesPerPage;
        return this;
    }

    public PagedSendHandler withTargetPage(int targetPage) {
        this.targetPage = targetPage;
        return this;
    }

    public boolean isPaginate() {
        return this.paginate;
    }

    public boolean isPaginateInConsole() {
        return this.paginateInConsole;
    }

    public boolean isPadEnd() {
        return this.padEnd;
    }

    public int getLinesPerPage() {
        return this.linesPerPage;
    }

    public int getTargetPage() {
        return this.targetPage;
    }
}

