/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.listeners;

import org.bukkit.event.EventPriority;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.mvplugins.multiverse.core.dynamiclistener.annotations.DefaultEventPriority;
import org.mvplugins.multiverse.core.dynamiclistener.annotations.EventMethod;
import org.mvplugins.multiverse.core.listeners.CoreListener;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.core.world.options.LoadWorldOptions;
import org.mvplugins.multiverse.core.world.options.UnloadWorldOptions;
import org.mvplugins.multiverse.core.world.reasons.LoadFailureReason;
import org.mvplugins.multiverse.core.world.reasons.UnloadFailureReason;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
final class MVWorldListener
implements CoreListener {
    private final WorldManager worldManager;

    @Inject
    MVWorldListener(WorldManager worldManager) {
        this.worldManager = worldManager;
    }

    @EventMethod
    @DefaultEventPriority(value=EventPriority.MONITOR)
    void worldUnload(WorldUnloadEvent event) {
        if (event.isCancelled()) {
            return;
        }
        this.worldManager.getLoadedWorld(event.getWorld().getName()).peek(world -> this.worldManager.unloadWorld(UnloadWorldOptions.world(world).unloadBukkitWorld(false)).onFailure(failure -> {
            if (failure.getFailureReason() != UnloadFailureReason.WORLD_ALREADY_UNLOADING) {
                CoreLogging.severe("Failed to unload world: " + String.valueOf(failure), new Object[0]);
            }
        }));
    }

    @EventMethod
    @DefaultEventPriority(value=EventPriority.MONITOR)
    void worldLoad(WorldLoadEvent event) {
        this.worldManager.getUnloadedWorld(event.getWorld().getName()).peek(world -> {
            CoreLogging.fine("Loading world: " + world.getName(), new Object[0]);
            this.worldManager.loadWorld(LoadWorldOptions.world(world)).onFailure(failure -> {
                if (failure.getFailureReason() != LoadFailureReason.WORLD_ALREADY_LOADING) {
                    CoreLogging.severe("Failed to load world: " + String.valueOf(failure), new Object[0]);
                }
            });
        });
    }
}

