/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.permissions;

import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.external.jetbrains.annotations.ApiStatus;

public final class PermissionUtils {
    private static boolean debugPermissions = false;

    private PermissionUtils() {
    }

    public static boolean isDebugPermissions() {
        return debugPermissions;
    }

    public static void setDebugPermissions(boolean debugPermissions) {
        PermissionUtils.debugPermissions = debugPermissions;
    }

    @ApiStatus.AvailableSince(value="5.4")
    public static void registerPermissionWithWildcards(Permission permission) {
        Bukkit.getServer().getPluginManager().addPermission(permission);
        String[] split = permission.getName().split("\\.");
        StringBuilder prefix = new StringBuilder();
        Arrays.stream(Arrays.copyOfRange(split, 0, split.length - 1)).forEach(s -> {
            prefix.append((String)s).append(".");
            Permission perm = PermissionUtils.getOrAddPermission(String.valueOf(prefix) + "*");
            permission.addParent(perm, true);
        });
    }

    private static Permission getOrAddPermission(String permission) {
        Permission perm = Bukkit.getServer().getPluginManager().getPermission(permission);
        if (perm == null) {
            perm = new Permission(permission, PermissionDefault.FALSE);
            Bukkit.getServer().getPluginManager().addPermission(perm);
        }
        return perm;
    }

    public static String concatPermission(String permission, String ... child) {
        return permission + "." + String.join((CharSequence)".", child);
    }

    public static boolean hasPermission(CommandSender sender, String permission) {
        if (sender.hasPermission(permission)) {
            if (debugPermissions && !(sender instanceof ConsoleCommandSender)) {
                CoreLogging.finer("Checking sender [%s] has permission [%s] : YES", sender.getName(), permission);
            }
            return true;
        }
        if (debugPermissions && !(sender instanceof ConsoleCommandSender)) {
            CoreLogging.finer("Checking sender [%s] has permission [%s] : NO", sender.getName(), permission);
        }
        return false;
    }
}

