/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.utils.position;

import org.bukkit.Location;
import org.mvplugins.multiverse.core.exceptions.utils.position.PositionParseException;
import org.mvplugins.multiverse.core.locale.MVCorei18n;
import org.mvplugins.multiverse.core.locale.message.Message;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.utils.REPatterns;
import org.mvplugins.multiverse.core.utils.position.PositionNumber;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="5.3")
public class FaceDirection {
    private final PositionNumber pitch;
    private final PositionNumber yaw;

    @ApiStatus.AvailableSince(value="5.3")
    public static FaceDirection ofAbsolute(double pitch, double yaw) {
        return new FaceDirection(PositionNumber.ofAbsolute(pitch), PositionNumber.ofAbsolute(yaw));
    }

    @ApiStatus.AvailableSince(value="5.3")
    public static FaceDirection ofLocation(Location location) {
        return new FaceDirection(PositionNumber.ofAbsolute(location.getPitch()), PositionNumber.ofAbsolute(location.getYaw()));
    }

    @ApiStatus.AvailableSince(value="5.3")
    public static FaceDirection fromString(String directionStr) throws PositionParseException {
        String[] parts = REPatterns.COLON.split(directionStr, 2);
        if (parts.length != 2) {
            throw new PositionParseException(Message.of((MessageKeyProvider)MVCorei18n.EXCEPTION_POSITIONPARSE_INVALIDDIRECTION, MessageReplacement.replace("{format}").with(directionStr)));
        }
        PositionNumber pitch = PositionNumber.fromString(parts[0]);
        PositionNumber yaw = PositionNumber.fromString(parts[1]);
        return new FaceDirection(pitch, yaw);
    }

    @ApiStatus.AvailableSince(value="5.3")
    public FaceDirection(PositionNumber pitch, PositionNumber yaw) {
        this.pitch = pitch;
        this.yaw = yaw;
    }

    @ApiStatus.AvailableSince(value="5.3")
    public PositionNumber getPitch() {
        return this.pitch;
    }

    @ApiStatus.AvailableSince(value="5.3")
    public PositionNumber getYaw() {
        return this.yaw;
    }

    @ApiStatus.AvailableSince(value="5.3")
    public void augmentBukkitLocation(Location base) {
        base.setPitch((float)this.pitch.getValue(base.getPitch()));
        base.setYaw((float)this.yaw.getValue(base.getYaw()));
    }

    public String toString() {
        return String.valueOf(this.pitch) + ":" + String.valueOf(this.yaw);
    }
}

