/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.utils.position;

import org.mvplugins.multiverse.core.exceptions.utils.position.PositionParseException;
import org.mvplugins.multiverse.core.locale.MVCorei18n;
import org.mvplugins.multiverse.core.locale.message.Message;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jetbrains.annotations.ApiStatus;
import org.mvplugins.multiverse.external.vavr.control.Try;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@ApiStatus.AvailableSince(value="5.3")
public interface PositionNumber {
    @ApiStatus.AvailableSince(value="5.3")
    public static PositionNumber ofAbsolute(double value) {
        return new Absolute(value);
    }

    @ApiStatus.AvailableSince(value="5.3")
    public static PositionNumber ofRelative(double value) {
        return new Relative(value);
    }

    @ApiStatus.AvailableSince(value="5.3")
    public static PositionNumber fromString(String string) throws PositionParseException {
        if (string.startsWith("~")) {
            if (string.length() == 1) {
                return new Relative(0.0);
            }
            return new Relative(PositionNumber.tryParseDouble(string.substring(1)));
        }
        return new Absolute(PositionNumber.tryParseDouble(string));
    }

    private static double tryParseDouble(String str) throws PositionParseException {
        return Try.of(() -> Double.parseDouble(str)).getOrElseThrow(throwable -> new PositionParseException(Message.of((MessageKeyProvider)MVCorei18n.EXCEPTION_POSITIONPARSE_INVALIDNUMBER, MessageReplacement.replace("{number}").with(str))));
    }

    @ApiStatus.AvailableSince(value="5.3")
    public double getValue(double var1);

    @ApiStatus.AvailableSince(value="5.3")
    public boolean isRelative();

    @ApiStatus.AvailableSince(value="5.3")
    public boolean isAbsolute();

    @ApiStatus.AvailableSince(value="5.3")
    public double getRawValue();

    public static final class Absolute
    implements PositionNumber {
        private final double value;

        Absolute(double value) {
            this.value = value;
        }

        @Override
        public double getValue(double base) {
            return this.value;
        }

        @Override
        public boolean isRelative() {
            return false;
        }

        @Override
        public boolean isAbsolute() {
            return true;
        }

        @Override
        public double getRawValue() {
            return this.value;
        }

        public String toString() {
            return Double.toString(this.value);
        }
    }

    public static final class Relative
    implements PositionNumber {
        private final double value;

        Relative(double value) {
            this.value = value;
        }

        @Override
        public double getValue(double base) {
            return base + this.value;
        }

        @Override
        public boolean isRelative() {
            return true;
        }

        @Override
        public boolean isAbsolute() {
            return false;
        }

        @Override
        public double getRawValue() {
            return this.value;
        }

        public String toString() {
            return "~" + this.value;
        }
    }
}

