/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.world.helpers;

import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.mvplugins.multiverse.core.teleportation.AsyncSafetyTeleporter;
import org.mvplugins.multiverse.core.teleportation.TeleportFailureReason;
import org.mvplugins.multiverse.core.utils.result.AsyncAttemptsAggregate;
import org.mvplugins.multiverse.core.world.LoadedMultiverseWorld;
import org.mvplugins.multiverse.core.world.MultiverseWorld;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
public final class PlayerWorldTeleporter {
    private final WorldManager worldManager;
    private final AsyncSafetyTeleporter safetyTeleporter;

    @Inject
    PlayerWorldTeleporter(@NotNull WorldManager worldManager, @NotNull AsyncSafetyTeleporter safetyTeleporter) {
        this.worldManager = worldManager;
        this.safetyTeleporter = safetyTeleporter;
    }

    public AsyncAttemptsAggregate<Void, TeleportFailureReason> removeFromWorld(@NotNull LoadedMultiverseWorld world) {
        World toWorld = this.worldManager.getDefaultWorld().flatMap(LoadedMultiverseWorld::getBukkitWorld).getOrElse((World)Bukkit.getWorlds().get(0));
        return this.transferFromWorldTo(world, toWorld);
    }

    public AsyncAttemptsAggregate<Void, TeleportFailureReason> transferFromWorldTo(@NotNull LoadedMultiverseWorld from, @NotNull MultiverseWorld to) {
        return this.transferAllFromWorldToLocation(from, to.getSpawnLocation());
    }

    public AsyncAttemptsAggregate<Void, TeleportFailureReason> transferFromWorldTo(@NotNull LoadedMultiverseWorld from, @NotNull World to) {
        return this.transferAllFromWorldToLocation(from, to.getSpawnLocation());
    }

    public AsyncAttemptsAggregate<Void, TeleportFailureReason> transferAllFromWorldToLocation(@NotNull LoadedMultiverseWorld world, @NotNull Location location) {
        return world.getPlayers().map(players -> this.safetyTeleporter.to(location).teleport(players)).getOrElse(AsyncAttemptsAggregate::emptySuccess);
    }

    public AsyncAttemptsAggregate<Void, TeleportFailureReason> teleportPlayersToWorld(@NotNull List<Player> players, @NotNull MultiverseWorld world) {
        Location spawnLocation = world.getSpawnLocation();
        return this.safetyTeleporter.to(spawnLocation).teleport(players);
    }
}

