/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.destination.core;

import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;
import org.mvplugins.multiverse.core.destination.DestinationInstance;
import org.mvplugins.multiverse.core.destination.core.AnchorDestination;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.vavr.control.Option;

public final class AnchorDestinationInstance
extends DestinationInstance<AnchorDestinationInstance, AnchorDestination> {
    private final String anchorName;
    private final Location anchorLocation;

    AnchorDestinationInstance(@NotNull AnchorDestination destination, @NotNull String anchorName, @NotNull Location anchorLocation) {
        super(destination);
        this.anchorName = anchorName;
        this.anchorLocation = anchorLocation;
    }

    @Override
    @NotNull
    public Option<Location> getLocation(@NotNull Entity teleportee) {
        return Option.of(this.anchorLocation.clone());
    }

    @Override
    @NotNull
    public Option<Vector> getVelocity(@NotNull Entity teleportee) {
        return Option.none();
    }

    @Override
    public boolean checkTeleportSafety() {
        return true;
    }

    @Override
    @NotNull
    public Option<String> getFinerPermissionSuffix() {
        return Option.of(this.anchorName);
    }

    @Override
    @NotNull
    public String serialise() {
        return this.anchorName;
    }
}

