/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.destination.core;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.mvplugins.multiverse.core.destination.Destination;
import org.mvplugins.multiverse.core.destination.DestinationSuggestionPacket;
import org.mvplugins.multiverse.core.destination.core.BedDestinationInstance;
import org.mvplugins.multiverse.core.locale.MVCorei18n;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.utils.PlayerFinder;
import org.mvplugins.multiverse.core.utils.result.Attempt;
import org.mvplugins.multiverse.core.utils.result.FailureReason;
import org.mvplugins.multiverse.external.acf.locales.MessageKey;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
public final class BedDestination
implements Destination<BedDestination, BedDestinationInstance, InstanceFailureReason> {
    static final String OWN_BED_STRING = "playerbed";

    BedDestination() {
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return "b";
    }

    @Override
    @NotNull
    public Attempt<BedDestinationInstance, InstanceFailureReason> getDestinationInstance(@NotNull CommandSender sender, @NotNull String destinationParams) {
        Player player = PlayerFinder.get(destinationParams);
        if (player == null && !OWN_BED_STRING.equals(destinationParams)) {
            return Attempt.failure(InstanceFailureReason.PLAYER_NOT_FOUND, MessageReplacement.Replace.PLAYER.with(destinationParams));
        }
        return Attempt.success(new BedDestinationInstance(this, player));
    }

    @Override
    @NotNull
    public Collection<DestinationSuggestionPacket> suggestDestinations(@NotNull CommandSender sender, @Nullable String destinationParams) {
        List<DestinationSuggestionPacket> collect = Bukkit.getOnlinePlayers().stream().map(player -> new DestinationSuggestionPacket(this, player.getName(), player.getName())).collect(Collectors.toList());
        if (sender instanceof Player) {
            collect.add(new DestinationSuggestionPacket(this, OWN_BED_STRING, OWN_BED_STRING));
        }
        return collect;
    }

    public static enum InstanceFailureReason implements FailureReason
    {
        PLAYER_NOT_FOUND(MVCorei18n.DESTINATION_BED_FAILUREREASON_PLAYERNOTFOUND);

        private final MessageKeyProvider messageKey;

        private InstanceFailureReason(MessageKeyProvider message) {
            this.messageKey = message;
        }

        @Override
        public MessageKey getMessageKey() {
            return this.messageKey.getMessageKey();
        }
    }
}

