/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.listeners;

import org.bukkit.event.weather.ThunderChangeEvent;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.mvplugins.multiverse.core.dynamiclistener.annotations.EventMethod;
import org.mvplugins.multiverse.core.listeners.CoreListener;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
final class MVWeatherListener
implements CoreListener {
    private final WorldManager worldManager;

    @Inject
    MVWeatherListener(WorldManager worldManager) {
        this.worldManager = worldManager;
    }

    @EventMethod
    void weatherChange(WeatherChangeEvent event) {
        if (event.isCancelled() || !event.toWeatherState()) {
            return;
        }
        this.worldManager.getLoadedWorld(event.getWorld()).peek(world -> {
            if (!world.isAllowWeather()) {
                CoreLogging.fine("Cancelling weather for %s as getAllowWeather is false", world.getName());
                event.setCancelled(true);
            }
        });
    }

    @EventMethod
    void thunderChange(ThunderChangeEvent event) {
        if (event.isCancelled() || !event.toThunderState()) {
            return;
        }
        this.worldManager.getLoadedWorld(event.getWorld()).peek(world -> {
            if (!world.isAllowWeather()) {
                CoreLogging.fine("Cancelling thunder for %s as getAllowWeather is false", world.getName());
                event.setCancelled(true);
            }
        });
    }
}

