/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.world.options;

import org.bukkit.World;
import org.mvplugins.multiverse.external.jetbrains.annotations.ApiStatus;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;

public final class ImportWorldOptions {
    private final String worldName;
    private String biome = "";
    private World.Environment environment = World.Environment.NORMAL;
    private String generator = null;
    private boolean useSpawnAdjust = true;
    private boolean doFolderCheck = true;

    @NotNull
    public static ImportWorldOptions worldName(@NotNull String worldName) {
        return new ImportWorldOptions(worldName);
    }

    ImportWorldOptions(String worldName) {
        this.worldName = worldName;
    }

    @NotNull
    public String worldName() {
        return this.worldName;
    }

    @NotNull
    public ImportWorldOptions biome(@NotNull String biome) {
        this.biome = biome;
        return this;
    }

    @NotNull
    public String biome() {
        return this.biome;
    }

    @NotNull
    public ImportWorldOptions environment(@NotNull World.Environment environmentInput) {
        this.environment = environmentInput;
        return this;
    }

    @NotNull
    public World.Environment environment() {
        return this.environment;
    }

    @NotNull
    public ImportWorldOptions generator(@Nullable String generatorInput) {
        this.generator = generatorInput;
        return this;
    }

    @Nullable
    public String generator() {
        return this.generator;
    }

    @NotNull
    public ImportWorldOptions useSpawnAdjust(boolean useSpawnAdjustInput) {
        this.useSpawnAdjust = useSpawnAdjustInput;
        return this;
    }

    public boolean useSpawnAdjust() {
        return this.useSpawnAdjust;
    }

    @ApiStatus.AvailableSince(value="5.2")
    @NotNull
    public ImportWorldOptions doFolderCheck(boolean doFolderCheckInput) {
        this.doFolderCheck = doFolderCheckInput;
        return this;
    }

    @ApiStatus.AvailableSince(value="5.2")
    public boolean doFolderCheck() {
        return this.doFolderCheck;
    }
}

