/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.external.jvnet.hk2.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ListIterator;
import java.util.concurrent.locks.ReentrantLock;
import org.mvplugins.multiverse.external.jvnet.hk2.internal.ServiceLocatorImpl;
import org.mvplugins.multiverse.external.jvnet.hk2.internal.SystemDescriptor;

public class IndexedListData {
    private final ReentrantLock lock = new ReentrantLock();
    private final ArrayList<SystemDescriptor<?>> unsortedList = new ArrayList();
    private volatile boolean sorted = true;

    public Collection<SystemDescriptor<?>> getSortedList() {
        if (this.sorted) {
            return this.unsortedList;
        }
        this.lock.lock();
        try {
            if (this.sorted) {
                ArrayList<SystemDescriptor<?>> arrayList = this.unsortedList;
                return arrayList;
            }
            if (this.unsortedList.size() <= 1) {
                this.sorted = true;
                ArrayList<SystemDescriptor<?>> arrayList = this.unsortedList;
                return arrayList;
            }
            Collections.sort(this.unsortedList, ServiceLocatorImpl.DESCRIPTOR_COMPARATOR);
            this.sorted = true;
            ArrayList<SystemDescriptor<?>> arrayList = this.unsortedList;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addDescriptor(SystemDescriptor<?> descriptor) {
        this.lock.lock();
        try {
            this.unsortedList.add(descriptor);
            this.sorted = this.unsortedList.size() <= 1;
            descriptor.addList(this);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDescriptor(SystemDescriptor<?> descriptor) {
        this.lock.lock();
        try {
            ListIterator<SystemDescriptor<?>> iterator = this.unsortedList.listIterator();
            while (iterator.hasNext()) {
                SystemDescriptor<?> candidate = iterator.next();
                if (ServiceLocatorImpl.DESCRIPTOR_COMPARATOR.compare(descriptor, candidate) != 0) continue;
                iterator.remove();
                break;
            }
            this.sorted = this.unsortedList.size() <= 1;
            descriptor.removeList(this);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isEmpty() {
        this.lock.lock();
        try {
            boolean bl = this.unsortedList.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void unSort() {
        this.lock.lock();
        try {
            if (this.unsortedList.size() > 1) {
                this.sorted = false;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clear() {
        this.lock.lock();
        try {
            for (SystemDescriptor<?> descriptor : this.unsortedList) {
                descriptor.removeList(this);
            }
            this.unsortedList.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    public int size() {
        this.lock.lock();
        try {
            int n = this.unsortedList.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }
}

