/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.commands;

import java.util.Map;
import org.bukkit.scheduler.BukkitRunnable;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.event.MVDumpsDebugInfoEvent;
import org.mvplugins.multiverse.core.locale.MVCorei18n;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.core.utils.webpaste.PasteFailedException;
import org.mvplugins.multiverse.core.utils.webpaste.PasteService;
import org.mvplugins.multiverse.core.utils.webpaste.PasteServiceFactory;
import org.mvplugins.multiverse.core.utils.webpaste.PasteServiceType;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;

final class DumpsLogPoster
extends BukkitRunnable {
    private final MVCommandIssuer issuer;
    private final LogsType logsType;
    private final UploadType uploadType;
    private final boolean paranoid;
    private final String logs;
    private final MVDumpsDebugInfoEvent versionEvent;

    DumpsLogPoster(@NotNull MVCommandIssuer issuer, @NotNull LogsType logsType, @NotNull UploadType uploadType, boolean paranoid, @NotNull String logs, @NotNull MVDumpsDebugInfoEvent versionEvent) {
        this.issuer = issuer;
        this.logsType = logsType;
        this.uploadType = uploadType;
        this.paranoid = paranoid;
        this.logs = logs;
        this.versionEvent = versionEvent;
    }

    public void run() {
        this.handleLogs();
        this.handleVersionEvent();
    }

    private void handleLogs() {
        CoreLogging.finer("Logs type is: " + String.valueOf((Object)this.logsType), new Object[0]);
        if (!this.paranoid) {
            switch (this.logsType.ordinal()) {
                case 1: {
                    this.sendDumpsUrl("Logs", this.postRawDataToMcLogs(this.logs));
                    break;
                }
                case 0: {
                    this.versionEvent.putDetailedDebugInfo("latest.log", this.logs);
                    break;
                }
                default: {
                    CoreLogging.finer("Not uploading logs.", new Object[0]);
                    break;
                }
            }
        } else {
            CoreLogging.finer("Paranoid mode is on, not uploading logs.", new Object[0]);
        }
    }

    private void handleVersionEvent() {
        CoreLogging.finer("Upload service is: " + String.valueOf((Object)this.uploadType), new Object[0]);
        Map<String, String> files = this.versionEvent.getDetailedDebugInfo();
        this.sendDumpsUrl(this.uploadType.serviceName, this.postFilesToService(files));
    }

    private void sendDumpsUrl(String service, String url) {
        this.issuer.sendInfo((MessageKeyProvider)MVCorei18n.DUMPS_URL_LIST, "{service}", service, "{link}", url);
    }

    private String postRawDataToMcLogs(@NotNull String rawPasteData) {
        PasteService pasteService = PasteServiceFactory.getService(PasteServiceType.MCLOGS, true);
        return this.pasteToService(() -> pasteService.postData(rawPasteData));
    }

    private String postFilesToService(@NotNull Map<String, String> pasteFiles) {
        PasteService pasteService = PasteServiceFactory.getService(this.uploadType.pasteServiceType, true);
        return this.pasteToService(() -> {
            if (pasteService.supportsMultiFile()) {
                return pasteService.postData(pasteFiles);
            }
            return pasteService.postData(this.encodeAsString(pasteFiles));
        });
    }

    private String encodeAsString(Map<String, String> files) {
        StringBuilder uploadData = new StringBuilder();
        for (Map.Entry<String, String> entry : files.entrySet()) {
            String file = entry.getKey();
            String data = entry.getValue();
            uploadData.append("# ---------- ").append(file).append(" ----------\n\n").append(data).append("\n\n");
        }
        return uploadData.toString();
    }

    private String pasteToService(LogPaster paster) {
        try {
            return paster.postLogs();
        }
        catch (PasteFailedException e) {
            e.printStackTrace();
            return "Error posting to service.";
        }
    }

    static enum LogsType {
        APPEND,
        MCLOGS;

    }

    static enum UploadType {
        PASTEGG(PasteServiceType.PASTEGG, "paste.gg"),
        PASTESDEV(PasteServiceType.PASTESDEV, "pastes.dev");

        private final PasteServiceType pasteServiceType;
        private final String serviceName;

        private UploadType(PasteServiceType pasteServiceType, String serviceName) {
            this.pasteServiceType = pasteServiceType;
            this.serviceName = serviceName;
        }
    }

    private static interface LogPaster {
        public String postLogs() throws PasteFailedException;
    }
}

