/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.commands;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.mvplugins.multiverse.core.command.LegacyAliasCommand;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.command.flag.CommandFlag;
import org.mvplugins.multiverse.core.command.flag.CommandFlagsManager;
import org.mvplugins.multiverse.core.command.flag.ParsedCommandFlags;
import org.mvplugins.multiverse.core.command.flags.PageFilterFlags;
import org.mvplugins.multiverse.core.commands.CoreCommand;
import org.mvplugins.multiverse.core.display.ContentDisplay;
import org.mvplugins.multiverse.core.display.filters.DefaultContentFilter;
import org.mvplugins.multiverse.core.display.handlers.PagedSendHandler;
import org.mvplugins.multiverse.core.display.handlers.SendHandler;
import org.mvplugins.multiverse.core.display.parsers.ListContentProvider;
import org.mvplugins.multiverse.core.locale.MVCorei18n;
import org.mvplugins.multiverse.core.locale.message.Message;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.world.MultiverseWorld;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.core.world.entrycheck.WorldEntryChecker;
import org.mvplugins.multiverse.core.world.entrycheck.WorldEntryCheckerProvider;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandAlias;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
class ListCommand
extends CoreCommand {
    private final WorldManager worldManager;
    private final WorldEntryCheckerProvider worldEntryCheckerProvider;
    private final Flags flags;

    @Inject
    ListCommand(@NotNull WorldManager worldManager, @NotNull WorldEntryCheckerProvider worldEntryCheckerProvider, @NotNull Flags flags) {
        this.worldManager = worldManager;
        this.worldEntryCheckerProvider = worldEntryCheckerProvider;
        this.flags = flags;
    }

    @Subcommand(value="list")
    @CommandPermission(value="multiverse.core.list.worlds")
    @CommandCompletion(value="@flags:groupName=mvlist")
    @Syntax(value="--filter [filter] --page [page] --raw")
    @Description(value="{{@mv-core.list.description}}")
    public void onListCommand(MVCommandIssuer issuer, @Syntax(value="[--filter <filter>] [--page <page>]") @Description(value="Filters the list of worlds by the given regex and displays the given page.") String[] flagArray) {
        ParsedCommandFlags parsedFlags = this.flags.parse(flagArray);
        ContentDisplay.create().addContent(ListContentProvider.forContent(this.getListContents(issuer, parsedFlags.hasFlag(this.flags.raw)))).withSendHandler((SendHandler)((PagedSendHandler)((PagedSendHandler)PagedSendHandler.create().noContentMessage(Message.of((MessageKeyProvider)MVCorei18n.LIST_NOCONTENT, new MessageReplacement[0]))).withHeader(Message.of((MessageKeyProvider)MVCorei18n.LIST_HEADER, new MessageReplacement[0]))).withTargetPage(parsedFlags.flagValue(this.flags.page, 1)).withFilter(parsedFlags.flagValue(this.flags.filter, DefaultContentFilter.get()))).send(issuer);
    }

    private List<String> getListContents(MVCommandIssuer issuer, boolean useRawNames) {
        ArrayList<String> worldList = new ArrayList<String>();
        WorldEntryChecker worldEntryChecker = this.worldEntryCheckerProvider.forSender(issuer.getIssuer());
        this.worldManager.getLoadedWorlds().stream().filter(world -> worldEntryChecker.canAccessWorld((MultiverseWorld)world).isSuccess()).filter(world -> this.canSeeWorld(issuer, (MultiverseWorld)world)).map(world -> this.hiddenText((MultiverseWorld)world) + this.getWorldName((MultiverseWorld)world, useRawNames) + " - " + this.parseColouredEnvironment(world.getEnvironment())).sorted().forEach(worldList::add);
        this.worldManager.getUnloadedWorlds().stream().filter(world -> worldEntryChecker.canAccessWorld((MultiverseWorld)world).isSuccess()).map(world -> String.valueOf(ChatColor.GRAY) + this.getWorldName((MultiverseWorld)world, useRawNames) + " - UNLOADED").sorted().forEach(worldList::add);
        return worldList;
    }

    private String getWorldName(MultiverseWorld world, boolean useRawNames) {
        if (useRawNames) {
            return world.getName();
        }
        return world.getAliasOrName();
    }

    private boolean canSeeWorld(MVCommandIssuer issuer, MultiverseWorld world) {
        return !world.isHidden() || issuer.hasPermission("multiverse.core.modify");
    }

    private String hiddenText(MultiverseWorld world) {
        return world.isHidden() ? String.format("%s[H] ", ChatColor.GRAY) : "";
    }

    private String parseColouredEnvironment(World.Environment env) {
        ChatColor color = switch (env) {
            case World.Environment.NETHER -> ChatColor.RED;
            case World.Environment.NORMAL -> ChatColor.GREEN;
            case World.Environment.THE_END -> ChatColor.AQUA;
            default -> ChatColor.GOLD;
        };
        return String.valueOf(color) + env.toString();
    }

    @Service
    private static final class Flags
    extends PageFilterFlags {
        private static final String NAME = "mvlist";
        private final CommandFlag raw = this.flag(((CommandFlag.Builder)CommandFlag.builder("--raw").addAlias("-r")).build());

        @Inject
        private Flags(@NotNull CommandFlagsManager flagsManager) {
            super(NAME, flagsManager);
        }
    }

    @Service
    private static final class LegacyAlias
    extends ListCommand
    implements LegacyAliasCommand {
        @Inject
        LegacyAlias(@NotNull WorldManager worldManager, @NotNull WorldEntryCheckerProvider worldEntryCheckerProvider, @NotNull Flags flags) {
            super(worldManager, worldEntryCheckerProvider, flags);
        }

        @Override
        @CommandAlias(value="mvlist|mvl")
        public void onListCommand(MVCommandIssuer issuer, String[] flags) {
            super.onListCommand(issuer, flags);
        }
    }
}

