/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.commands;

import org.bukkit.Location;
import org.mvplugins.multiverse.core.command.LegacyAliasCommand;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.command.context.PlayerLocation;
import org.mvplugins.multiverse.core.command.flag.ParsedCommandFlags;
import org.mvplugins.multiverse.core.command.flags.UnsafeFlags;
import org.mvplugins.multiverse.core.commands.CoreCommand;
import org.mvplugins.multiverse.core.locale.MVCorei18n;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.teleportation.BlockSafety;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandAlias;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Optional;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
class SetSpawnCommand
extends CoreCommand {
    private final WorldManager worldManager;
    private final BlockSafety blockSafety;
    private final UnsafeFlags flags;

    @Inject
    SetSpawnCommand(@NotNull WorldManager worldManager, @NotNull BlockSafety blockSafety, @NotNull UnsafeFlags flags) {
        this.worldManager = worldManager;
        this.blockSafety = blockSafety;
        this.flags = flags;
    }

    @CommandAlias(value="mvsetspawn")
    @Subcommand(value="setspawn")
    @CommandPermission(value="multiverse.core.spawn.set")
    @CommandCompletion(value="@flags:groupName=unsafe @flags:resolveUntil=arg1,groupName=unsafe")
    @Syntax(value="[worldname:x,y,z[,pitch,yaw]] [--unsafe]")
    @Description(value="{@@mv-core.setspawn.description}")
    void onSetSpawnCommand(MVCommandIssuer issuer, @Syntax(value="[worldname:x,y,z[,pitch,yaw]]") @Description(value="{@@mv-core.setspawn.location.description}") PlayerLocation playerLocation, @Optional @Syntax(value="[--unsafe]") @Description(value="") String[] flagArray) {
        ParsedCommandFlags parsedFlags = this.flags.parse(flagArray);
        Location location = playerLocation.value();
        if (!parsedFlags.hasFlag(this.flags.unsafe) && !this.blockSafety.canSpawnAtLocationSafely(location)) {
            issuer.sendMessage(MVCorei18n.SETSPAWN_UNSAFE, new MessageReplacement[0]);
            return;
        }
        this.worldManager.getLoadedWorld(location.getWorld()).peek(mvWorld -> mvWorld.setSpawnLocation(location).flatMap(ignore -> this.worldManager.saveWorldsConfig()).onSuccess(ignore -> issuer.sendMessage(MVCorei18n.SETSPAWN_SUCCESS, MessageReplacement.Replace.WORLD.with(mvWorld.getName()), MessageReplacement.Replace.LOCATION.with(this.prettyLocation(location)))).onFailure(e -> issuer.sendMessage(MVCorei18n.SETSPAWN_FAILED, MessageReplacement.Replace.WORLD.with(mvWorld.getName()), MessageReplacement.Replace.ERROR.with(e)))).onEmpty(() -> issuer.sendMessage(MVCorei18n.SETSPAWN_NOTMVWORLD, MessageReplacement.Replace.WORLD.with(location.getWorld().getName())));
    }

    private String prettyLocation(Location location) {
        return "%.2f, %.2f, %.2f, pitch:%.2f, yaw:%.2f".formatted(location.getX(), location.getY(), location.getZ(), Float.valueOf(location.getPitch()), Float.valueOf(location.getYaw()));
    }

    @Service
    private static final class LegacyAlias
    extends SetSpawnCommand
    implements LegacyAliasCommand {
        @Inject
        LegacyAlias(@NotNull WorldManager worldManager, @NotNull BlockSafety blockSafety, @NotNull UnsafeFlags flags) {
            super(worldManager, blockSafety, flags);
        }

        @Override
        @CommandAlias(value="mvss")
        void onSetSpawnCommand(MVCommandIssuer issuer, PlayerLocation location, String[] flagArray) {
            super.onSetSpawnCommand(issuer, location, flagArray);
        }
    }
}

