/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.config.node.functions;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.mvplugins.multiverse.core.config.node.functions.NodeSuggester;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;

public final class DefaultSuggesterProvider {
    private static final Map<Class<?>, NodeSuggester> SUGGESTERS = new HashMap();
    private static final NodeSuggester BOOLEAN_SUGGESTER = input -> List.of("true", "false");
    private static final NodeSuggester INTEGER_SUGGESTER = input -> IntStream.range(1, 10).boxed().map(String::valueOf).collect(Collectors.toList());

    public static void addDefaultSuggester(Class<?> clazz, NodeSuggester suggester) {
        SUGGESTERS.put(clazz, suggester);
    }

    @Nullable
    public static NodeSuggester getDefaultSuggester(Class<?> clazz) {
        if (clazz.isEnum()) {
            return DefaultSuggesterProvider.enumSuggester(clazz);
        }
        return SUGGESTERS.get(clazz);
    }

    private static NodeSuggester enumSuggester(Class<?> clazz) {
        return input -> Arrays.stream(clazz.getEnumConstants()).map(Object::toString).map(name -> name.toLowerCase(Locale.ENGLISH)).collect(Collectors.toList());
    }

    private DefaultSuggesterProvider() {
    }

    static {
        DefaultSuggesterProvider.addDefaultSuggester(Boolean.class, BOOLEAN_SUGGESTER);
        DefaultSuggesterProvider.addDefaultSuggester(Integer.class, INTEGER_SUGGESTER);
    }
}

