/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.destination.core;

import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.mvplugins.multiverse.core.destination.Destination;
import org.mvplugins.multiverse.core.destination.DestinationSuggestionPacket;
import org.mvplugins.multiverse.core.destination.core.PlayerDestinationInstance;
import org.mvplugins.multiverse.core.locale.MVCorei18n;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.utils.PlayerFinder;
import org.mvplugins.multiverse.core.utils.result.Attempt;
import org.mvplugins.multiverse.core.utils.result.FailureReason;
import org.mvplugins.multiverse.external.acf.locales.MessageKey;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
public final class PlayerDestination
implements Destination<PlayerDestination, PlayerDestinationInstance, InstanceFailureReason> {
    PlayerDestination() {
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return "pl";
    }

    @Override
    @NotNull
    public Attempt<PlayerDestinationInstance, InstanceFailureReason> getDestinationInstance(@NotNull CommandSender sender, @NotNull String destinationParams) {
        Player player = PlayerFinder.get(destinationParams);
        if (player == null) {
            return Attempt.failure(InstanceFailureReason.PLAYER_NOT_FOUND, MessageReplacement.Replace.PLAYER.with(destinationParams));
        }
        return Attempt.success(new PlayerDestinationInstance(this, player));
    }

    @Override
    @NotNull
    public Collection<DestinationSuggestionPacket> suggestDestinations(@NotNull CommandSender sender, @Nullable String destinationParams) {
        return Bukkit.getOnlinePlayers().stream().map(p -> new DestinationSuggestionPacket(this, p.getName(), p.getName())).toList();
    }

    public static enum InstanceFailureReason implements FailureReason
    {
        PLAYER_NOT_FOUND(MVCorei18n.DESTINATION_PLAYER_FAILUREREASON_PLAYERNOTFOUND);

        private final MessageKeyProvider messageKey;

        private InstanceFailureReason(MessageKeyProvider message) {
            this.messageKey = message;
        }

        @Override
        public MessageKey getMessageKey() {
            return this.messageKey.getMessageKey();
        }
    }
}

