/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.economy;

import java.util.HashMap;
import java.util.Iterator;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.mvplugins.multiverse.core.command.MVCommandManager;
import org.mvplugins.multiverse.core.economy.MVEconomist;
import org.mvplugins.multiverse.core.locale.MVCorei18n;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
final class ItemEconomy {
    private static final String ECONOMY_NAME = "Simple Item Economy";
    @NotNull
    private final MVCommandManager commandManager;

    @Inject
    private ItemEconomy(@NotNull MVCommandManager commandManager) {
        this.commandManager = commandManager;
    }

    String getFormattedPrice(double amount, Material currency) {
        if (MVEconomist.isItemCurrency(currency)) {
            return amount + " " + currency.toString();
        }
        return "";
    }

    String getName() {
        return ECONOMY_NAME;
    }

    boolean hasEnough(Player player, double amount, Material currency) {
        if (currency != null) {
            return player.getInventory().contains(currency, this.augmentAmount(amount));
        }
        return true;
    }

    void deposit(Player player, double amount, Material currency) {
        if (MVEconomist.isItemCurrency(currency)) {
            this.giveItem(player, this.augmentAmount(amount), currency);
        }
    }

    void withdraw(Player player, double amount, Material currency) {
        if (MVEconomist.isItemCurrency(currency)) {
            this.takeItem(player, this.augmentAmount(amount), currency);
        }
    }

    void giveItem(Player player, int amount, Material type) {
        ItemStack item = new ItemStack(type, amount);
        player.getInventory().addItem(new ItemStack[]{item});
        this.showReceipt(player, amount, type);
    }

    void takeItem(Player player, int amount, Material type) {
        int removed = 0;
        HashMap items = player.getInventory().all(type);
        Iterator iterator = items.keySet().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            if (removed >= amount) break;
            int diff = amount - removed;
            int amt = player.getInventory().getItem(i).getAmount();
            if (amt - diff > 0) {
                player.getInventory().getItem(i).setAmount(amt - diff);
                break;
            }
            removed += amt;
            player.getInventory().clear(i);
        }
        this.showReceipt(player, amount, type);
    }

    void showReceipt(Player player, int price, Material item) {
        if ((double)price > 0.0) {
            this.commandManager.getCommandIssuer(player).sendInfo((MessageKeyProvider)MVCorei18n.ECONOMY_ITEM_WITHDRAW, MessageReplacement.replace("{price}").with(this.getFormattedPrice(price, item)));
        } else if ((double)price < 0.0) {
            this.commandManager.getCommandIssuer(player).sendInfo((MessageKeyProvider)MVCorei18n.ECONOMY_ITEM_DEPOSIT, MessageReplacement.replace("{price}").with(this.getFormattedPrice(price, item)));
        }
    }

    private int augmentAmount(@NotNull Double amount) {
        return amount.intValue();
    }
}

