/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.economy;

import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.mvplugins.multiverse.core.MultiverseCore;
import org.mvplugins.multiverse.core.command.MVCommandManager;
import org.mvplugins.multiverse.core.economy.ItemEconomy;
import org.mvplugins.multiverse.core.economy.VaultHandler;
import org.mvplugins.multiverse.core.world.MultiverseWorld;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
public final class MVEconomist {
    public static final String VAULT_ECONOMY_CODE = "@vault-economy";
    public static final Material VAULT_ECONOMY_MATERIAL = Material.AIR;
    private final VaultHandler vaultHandler;
    private final ItemEconomy itemEconomy;

    @Inject
    MVEconomist(MultiverseCore plugin, ItemEconomy itemEconomy, MVCommandManager commandManager) {
        this.vaultHandler = new VaultHandler((Plugin)plugin, commandManager);
        this.itemEconomy = itemEconomy;
    }

    private boolean isUsingVault(Material currency) {
        return !MVEconomist.isItemCurrency(currency) && this.getVaultHandler().hasEconomy();
    }

    public boolean isUsingEconomyPlugin() {
        return this.getVaultHandler().hasEconomy();
    }

    public String formatPrice(double amount, @Nullable Material currency) {
        if (this.isUsingVault(currency)) {
            return this.getVaultHandler().getEconomy().format(amount);
        }
        return this.itemEconomy.getFormattedPrice(amount, currency);
    }

    public String getEconomyName() {
        if (this.getVaultHandler().hasEconomy()) {
            return this.getVaultHandler().getEconomy().getName();
        }
        return this.itemEconomy.getName();
    }

    public boolean isPlayerWealthyEnough(Player player, double amount, Material currency) {
        if (amount <= 0.0) {
            return true;
        }
        if (this.isUsingVault(currency)) {
            return this.getVaultHandler().getEconomy().has((OfflinePlayer)player, amount);
        }
        return this.itemEconomy.hasEnough(player, amount, currency);
    }

    public String getNSFMessage(Material currency, String message) {
        return "Sorry, you don't have enough " + (MVEconomist.isItemCurrency(currency) ? "items" : "funds") + ". " + message;
    }

    public void payEntryFee(Player player, MultiverseWorld world) {
        this.payEntryFee(player, world.getPrice(), world.getCurrency());
    }

    public void payEntryFee(Player player, double price, Material currency) {
        if (price == 0.0) {
            return;
        }
        if (price < 0.0) {
            this.deposit(player, -price, currency);
        } else {
            this.withdraw(player, price, currency);
        }
    }

    public void deposit(Player player, double amount, @Nullable Material currency) {
        if (this.isUsingVault(currency)) {
            this.getVaultHandler().getEconomy().depositPlayer((OfflinePlayer)player, amount);
            this.getVaultHandler().showReceipt(player, amount);
        } else {
            this.itemEconomy.deposit(player, amount, currency);
        }
    }

    public void withdraw(Player player, double amount, @Nullable Material currency) {
        if (this.isUsingVault(currency)) {
            this.getVaultHandler().getEconomy().withdrawPlayer((OfflinePlayer)player, amount);
            this.getVaultHandler().showReceipt(player, amount);
        } else {
            this.itemEconomy.withdraw(player, amount, currency);
        }
    }

    public double getBalance(Player player) throws IllegalStateException {
        return this.getBalance(player, null);
    }

    public double getBalance(Player player, World world) throws IllegalStateException {
        if (!this.isUsingEconomyPlugin()) {
            throw new IllegalStateException("getBalance is only available when using an economy plugin with Vault");
        }
        if (world != null) {
            return this.getVaultHandler().getEconomy().getBalance((OfflinePlayer)player, world.getName());
        }
        return this.getVaultHandler().getEconomy().getBalance((OfflinePlayer)player);
    }

    public void setBalance(Player player, double amount) throws IllegalStateException {
        this.setBalance(player, null, amount);
    }

    public void setBalance(Player player, World world, double amount) throws IllegalStateException {
        if (!this.isUsingEconomyPlugin()) {
            throw new IllegalStateException("getBalance is only available when using an economy plugin with Vault");
        }
        if (world != null) {
            this.getVaultHandler().getEconomy().withdrawPlayer((OfflinePlayer)player, world.getName(), this.getBalance(player, world));
            this.getVaultHandler().getEconomy().depositPlayer((OfflinePlayer)player, world.getName(), amount);
        } else {
            this.getVaultHandler().getEconomy().withdrawPlayer((OfflinePlayer)player, this.getBalance(player));
            this.getVaultHandler().getEconomy().depositPlayer((OfflinePlayer)player, amount);
        }
    }

    private VaultHandler getVaultHandler() {
        return this.vaultHandler;
    }

    public static boolean isItemCurrency(Material currency) {
        return currency != VAULT_ECONOMY_MATERIAL;
    }
}

