/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.teleportation;

import org.bukkit.Location;
import org.bukkit.plugin.PluginManager;
import org.mvplugins.multiverse.core.MultiverseCore;
import org.mvplugins.multiverse.core.destination.DestinationInstance;
import org.mvplugins.multiverse.core.teleportation.AsyncSafetyTeleporterAction;
import org.mvplugins.multiverse.core.teleportation.BlockSafety;
import org.mvplugins.multiverse.core.teleportation.TeleportQueue;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.external.vavr.control.Either;

@Service
public final class AsyncSafetyTeleporter {
    @NotNull
    private final MultiverseCore multiverseCore;
    private final BlockSafety blockSafety;
    private final TeleportQueue teleportQueue;
    private final PluginManager pluginManager;

    @Inject
    AsyncSafetyTeleporter(@NotNull MultiverseCore multiverseCore, @NotNull BlockSafety blockSafety, @NotNull TeleportQueue teleportQueue, @NotNull PluginManager pluginManager) {
        this.multiverseCore = multiverseCore;
        this.blockSafety = blockSafety;
        this.teleportQueue = teleportQueue;
        this.pluginManager = pluginManager;
    }

    public AsyncSafetyTeleporterAction to(@Nullable Location location) {
        return new AsyncSafetyTeleporterAction(this.multiverseCore, this.blockSafety, this.teleportQueue, this.pluginManager, Either.left(location));
    }

    public AsyncSafetyTeleporterAction to(@Nullable DestinationInstance<?, ?> destination) {
        return new AsyncSafetyTeleporterAction(this.multiverseCore, this.blockSafety, this.teleportQueue, this.pluginManager, Either.right(destination));
    }
}

