/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.teleportation;

import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Rail;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Vehicle;
import org.bukkit.generator.WorldInfo;
import org.mvplugins.multiverse.core.config.CoreConfig;
import org.mvplugins.multiverse.core.teleportation.LocationManipulation;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.external.vavr.control.Option;

@Service
public final class BlockSafety {
    private final CoreConfig config;
    private final LocationManipulation locationManipulation;

    @Inject
    BlockSafety(@NotNull CoreConfig config, @NotNull LocationManipulation locationManipulation) {
        this.config = config;
        this.locationManipulation = locationManipulation;
    }

    public boolean isBlockAboveAir(Location location) {
        return location.getBlock().getRelative(0, -1, 0).getType().isAir();
    }

    public boolean isEntityOnTrack(Location location) {
        return location.getBlock().getBlockData() instanceof Rail;
    }

    public Location getTopBlock(Location location) {
        Location check = location.clone();
        int maxHeight = Option.of(location.getWorld()).map(WorldInfo::getMaxHeight).getOrElse(127);
        check.setY((double)maxHeight);
        while (check.getY() > 0.0) {
            if (this.canSpawnAtLocationSafely(check)) {
                return check;
            }
            check.setY(check.getY() - 1.0);
        }
        return null;
    }

    public Location getBottomBlock(Location location) {
        Location check = location.clone();
        int minHeight = Option.of(location.getWorld()).map(WorldInfo::getMinHeight).getOrElse(0);
        check.setY((double)minHeight);
        while (check.getY() < 127.0) {
            if (this.canSpawnAtLocationSafely(check)) {
                return check;
            }
            check.setY(check.getY() + 1.0);
        }
        return null;
    }

    public boolean canSpawnCartSafely(Minecart cart) {
        if (this.isBlockAboveAir(cart.getLocation())) {
            return true;
        }
        return this.isEntityOnTrack(this.locationManipulation.getNextBlock((Vehicle)cart));
    }

    public boolean canSpawnVehicleSafely(Vehicle vehicle) {
        return this.isBlockAboveAir(vehicle.getLocation());
    }

    public boolean canSpawnAtLocationSafely(@NotNull Location location) {
        return this.canSpawnAtBlockSafely(location.getBlock());
    }

    public boolean canSpawnAtBlockSafely(@NotNull Block block) {
        CoreLogging.finest("Checking spawn safety for location: %s, %s, %s", block.getX(), block.getY(), block.getZ());
        if (this.isUnsafeSpawnBody(block)) {
            CoreLogging.finest("Unsafe location for player's body: " + String.valueOf(block), new Object[0]);
            return false;
        }
        Block airBlockForHead = block.getRelative(0, 1, 0);
        if (this.isUnsafeSpawnBody(airBlockForHead)) {
            CoreLogging.finest("Unsafe location for player's head: " + String.valueOf(airBlockForHead), new Object[0]);
            return false;
        }
        Block standingOnBlock = block.getRelative(0, -1, 0);
        if (this.isUnsafeSpawnPlatform(standingOnBlock)) {
            CoreLogging.finest("Unsafe location due to invalid platform: " + String.valueOf(standingOnBlock), new Object[0]);
            return false;
        }
        CoreLogging.finest("Location is safe.", new Object[0]);
        return true;
    }

    private boolean isUnsafeSpawnBody(@NotNull Block block) {
        Material blockMaterial = block.getType();
        return blockMaterial.isSolid() || blockMaterial == Material.FIRE;
    }

    private boolean isUnsafeSpawnPlatform(@NotNull Block block) {
        return !block.getType().isSolid() || this.isDeepWater(block);
    }

    private boolean isDeepWater(@NotNull Block block) {
        if (block.getType() != Material.WATER) {
            return false;
        }
        return block.getRelative(0, -1, 0).getType() == Material.WATER;
    }

    @Nullable
    public Location findSafeSpawnLocation(@NotNull Location location) {
        return this.findSafeSpawnLocation(location, this.config.getSafeLocationHorizontalSearchRadius(), this.config.getSafeLocationVerticalSearchRadius());
    }

    @Nullable
    public Location findSafeSpawnLocation(@NotNull Location location, int horizontalRange, int verticalRange) {
        Block safeBlock = this.findSafeSpawnBlock(location.getBlock(), horizontalRange, verticalRange);
        if (safeBlock == null) {
            return null;
        }
        return new Location(location.getWorld(), (double)safeBlock.getX() + 0.5, (double)safeBlock.getY(), (double)safeBlock.getZ() + 0.5, location.getYaw(), location.getPitch());
    }

    @Nullable
    public Block findSafeSpawnBlock(@NotNull Block block) {
        return this.findSafeSpawnBlock(block, this.config.getSafeLocationHorizontalSearchRadius(), this.config.getSafeLocationVerticalSearchRadius());
    }

    @Nullable
    public Block findSafeSpawnBlock(@NotNull Block block, int horizontalRange, int verticalRange) {
        Block searchResult = this.searchAroundXZ(block, horizontalRange);
        if (searchResult != null) {
            return searchResult;
        }
        int maxHeight = block.getWorld().getMaxHeight();
        int minHeight = block.getWorld().getMinHeight();
        for (int i = 1; i <= verticalRange; ++i) {
            if (block.getY() + i < maxHeight && (searchResult = this.searchAroundXZ(block.getRelative(0, i, 0), horizontalRange)) != null) {
                return searchResult;
            }
            if (block.getY() - i < minHeight || (searchResult = this.searchAroundXZ(block.getRelative(0, -i, 0), horizontalRange)) == null) continue;
            return searchResult;
        }
        return null;
    }

    @Nullable
    private Block searchAroundXZ(Block block, int radius) {
        if (this.canSpawnAtBlockSafely(block)) {
            return block;
        }
        for (int r = 1; r <= radius; ++r) {
            boolean radiusX = true;
            boolean incrementOffset = false;
            int offset = 0;
            int noOfIterations = r * 2 + 1;
            for (int i = 0; i < noOfIterations; ++i) {
                Block searchResult;
                Block block2 = searchResult = radiusX ? this.searchPlusMinusPermutation(block, r, offset) : this.searchPlusMinusPermutation(block, offset, r);
                if (searchResult != null) {
                    return searchResult;
                }
                if (incrementOffset) {
                    ++offset;
                }
                radiusX = !radiusX;
                incrementOffset = !incrementOffset;
            }
        }
        return null;
    }

    @Nullable
    private Block searchPlusMinusPermutation(Block block, int x, int z) {
        Block relative = block.getRelative(-x, 0, -z);
        if (this.canSpawnAtBlockSafely(relative)) {
            return relative;
        }
        if (z != 0 && this.canSpawnAtBlockSafely(relative = block.getRelative(-x, 0, z))) {
            return relative;
        }
        if (x != 0) {
            relative = block.getRelative(x, 0, -z);
            if (this.canSpawnAtBlockSafely(relative)) {
                return relative;
            }
            if (z != 0 && this.canSpawnAtBlockSafely(relative = block.getRelative(x, 0, z))) {
                return relative;
            }
        }
        return null;
    }

    @Nullable
    public Location findPortalBlockNextTo(Location location) {
        if (location.getWorld() == null) {
            return null;
        }
        Block b = location.getWorld().getBlockAt(location);
        Location foundLocation = null;
        if (b.getType() == Material.NETHER_PORTAL) {
            return location;
        }
        if (b.getRelative(BlockFace.NORTH).getType() == Material.NETHER_PORTAL) {
            foundLocation = this.getCloserBlock(location, b.getRelative(BlockFace.NORTH).getLocation(), foundLocation);
        }
        if (b.getRelative(BlockFace.SOUTH).getType() == Material.NETHER_PORTAL) {
            foundLocation = this.getCloserBlock(location, b.getRelative(BlockFace.SOUTH).getLocation(), foundLocation);
        }
        if (b.getRelative(BlockFace.EAST).getType() == Material.NETHER_PORTAL) {
            foundLocation = this.getCloserBlock(location, b.getRelative(BlockFace.EAST).getLocation(), foundLocation);
        }
        if (b.getRelative(BlockFace.WEST).getType() == Material.NETHER_PORTAL) {
            foundLocation = this.getCloserBlock(location, b.getRelative(BlockFace.WEST).getLocation(), foundLocation);
        }
        return foundLocation;
    }

    private Location getCloserBlock(Location source, Location blockA, Location blockB) {
        if (blockB == null) {
            return blockA;
        }
        blockA.add(0.5, 0.0, 0.5);
        blockB.add(0.5, 0.0, 0.5);
        double testA = source.distance(blockA);
        double testB = source.distance(blockB);
        if (testA <= testB) {
            return blockA;
        }
        return blockB;
    }
}

