/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.teleportation;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.external.vavr.control.Option;

@Service
public final class TeleportQueue {
    private final Map<String, String> teleportQueueMap = new HashMap<String, String>();

    TeleportQueue() {
    }

    public void addToQueue(CommandSender teleporter, Player teleportee) {
        this.addToQueue(teleporter.getName(), teleportee.getName());
    }

    public void addToQueue(String teleporter, String teleportee) {
        CoreLogging.finest("Adding mapping '%s' => '%s' to teleport queue", teleporter, teleportee);
        this.teleportQueueMap.put(teleportee, teleporter);
    }

    public Option<String> popFromQueue(String playerName) {
        if (this.teleportQueueMap.containsKey(playerName)) {
            String teleportee = this.teleportQueueMap.get(playerName);
            this.teleportQueueMap.remove(playerName);
            return Option.of(teleportee);
        }
        return Option.none();
    }
}

