/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.world;

import com.google.common.base.Strings;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.WorldType;
import org.bukkit.event.Event;
import org.bukkit.generator.WorldInfo;
import org.bukkit.plugin.PluginManager;
import org.mvplugins.multiverse.core.config.CoreConfig;
import org.mvplugins.multiverse.core.event.world.MVWorldClonedEvent;
import org.mvplugins.multiverse.core.event.world.MVWorldCreatedEvent;
import org.mvplugins.multiverse.core.event.world.MVWorldDeleteEvent;
import org.mvplugins.multiverse.core.event.world.MVWorldImportedEvent;
import org.mvplugins.multiverse.core.event.world.MVWorldLoadedEvent;
import org.mvplugins.multiverse.core.event.world.MVWorldRegeneratedEvent;
import org.mvplugins.multiverse.core.event.world.MVWorldRemovedEvent;
import org.mvplugins.multiverse.core.event.world.MVWorldUnloadedEvent;
import org.mvplugins.multiverse.core.exceptions.world.MultiverseWorldException;
import org.mvplugins.multiverse.core.locale.MVCorei18n;
import org.mvplugins.multiverse.core.locale.message.Message;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.permissions.CorePermissions;
import org.mvplugins.multiverse.core.teleportation.BlockSafety;
import org.mvplugins.multiverse.core.teleportation.LocationManipulation;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.core.utils.FileUtils;
import org.mvplugins.multiverse.core.utils.ReflectHelper;
import org.mvplugins.multiverse.core.utils.ServerProperties;
import org.mvplugins.multiverse.core.utils.result.Attempt;
import org.mvplugins.multiverse.core.utils.result.FailureReason;
import org.mvplugins.multiverse.core.utils.text.ChatTextFormatter;
import org.mvplugins.multiverse.core.world.LoadedMultiverseWorld;
import org.mvplugins.multiverse.core.world.MultiverseWorld;
import org.mvplugins.multiverse.core.world.WorldConfig;
import org.mvplugins.multiverse.core.world.WorldsConfigManager;
import org.mvplugins.multiverse.core.world.biomeprovider.BiomeProviderFactory;
import org.mvplugins.multiverse.core.world.entity.EntityPurger;
import org.mvplugins.multiverse.core.world.generators.GeneratorProvider;
import org.mvplugins.multiverse.core.world.helpers.DataStore;
import org.mvplugins.multiverse.core.world.helpers.DataTransfer;
import org.mvplugins.multiverse.core.world.helpers.DimensionFinder;
import org.mvplugins.multiverse.core.world.helpers.WorldNameChecker;
import org.mvplugins.multiverse.core.world.options.CloneWorldOptions;
import org.mvplugins.multiverse.core.world.options.CreateWorldOptions;
import org.mvplugins.multiverse.core.world.options.DeleteWorldOptions;
import org.mvplugins.multiverse.core.world.options.ImportWorldOptions;
import org.mvplugins.multiverse.core.world.options.KeepWorldSettingsOptions;
import org.mvplugins.multiverse.core.world.options.LoadWorldOptions;
import org.mvplugins.multiverse.core.world.options.RegenWorldOptions;
import org.mvplugins.multiverse.core.world.options.RemoveWorldOptions;
import org.mvplugins.multiverse.core.world.options.UnloadWorldOptions;
import org.mvplugins.multiverse.core.world.reasons.CloneFailureReason;
import org.mvplugins.multiverse.core.world.reasons.CreateFailureReason;
import org.mvplugins.multiverse.core.world.reasons.DeleteFailureReason;
import org.mvplugins.multiverse.core.world.reasons.ImportFailureReason;
import org.mvplugins.multiverse.core.world.reasons.LoadFailureReason;
import org.mvplugins.multiverse.core.world.reasons.RegenFailureReason;
import org.mvplugins.multiverse.core.world.reasons.RemoveFailureReason;
import org.mvplugins.multiverse.core.world.reasons.UnloadFailureReason;
import org.mvplugins.multiverse.core.world.reasons.WorldCreatorFailureReason;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.ApiStatus;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.external.paperlib.PaperLib;
import org.mvplugins.multiverse.external.vavr.control.Option;
import org.mvplugins.multiverse.external.vavr.control.Try;

@Service
public final class WorldManager {
    private static final List<String> CLONE_IGNORE_FILES = Arrays.asList("uid.dat", "session.lock");
    private static final DimensionFinder.DimensionFormat DEFAULT_NETHER_FORMAT = new DimensionFinder.DimensionFormat("%overworld%_nether");
    private static final DimensionFinder.DimensionFormat DEFAULT_END_FORMAT = new DimensionFinder.DimensionFormat("%overworld%_the_end");
    private final Map<String, MultiverseWorld> worldsMap;
    private final Map<String, LoadedMultiverseWorld> loadedWorldsMap;
    private final List<String> unloadTracker;
    private final List<String> loadTracker;
    private final WorldsConfigManager worldsConfigManager;
    private final WorldNameChecker worldNameChecker;
    private final BiomeProviderFactory biomeProviderFactory;
    private final GeneratorProvider generatorProvider;
    private final FileUtils fileUtils;
    private final BlockSafety blockSafety;
    private final LocationManipulation locationManipulation;
    private final PluginManager pluginManager;
    private final CorePermissions corePermissions;
    private final ServerProperties serverProperties;
    private final CoreConfig config;
    private final EntityPurger entityPurger;
    private final Method saveWithFlush = ReflectHelper.getMethod(World.class, "save", new Class[]{Boolean.TYPE});

    @Inject
    WorldManager(@NotNull WorldsConfigManager worldsConfigManager, @NotNull WorldNameChecker worldNameChecker, @NotNull BiomeProviderFactory biomeProviderFactory, @NotNull GeneratorProvider generatorProvider, @NotNull FileUtils fileUtils, @NotNull BlockSafety blockSafety, @NotNull LocationManipulation locationManipulation, @NotNull PluginManager pluginManager, @NotNull CorePermissions corePermissions, @NotNull ServerProperties serverProperties, @NotNull CoreConfig config, @NotNull EntityPurger entityPurger) {
        this.worldsConfigManager = worldsConfigManager;
        this.worldNameChecker = worldNameChecker;
        this.biomeProviderFactory = biomeProviderFactory;
        this.generatorProvider = generatorProvider;
        this.fileUtils = fileUtils;
        this.blockSafety = blockSafety;
        this.locationManipulation = locationManipulation;
        this.pluginManager = pluginManager;
        this.corePermissions = corePermissions;
        this.serverProperties = serverProperties;
        this.config = config;
        this.entityPurger = entityPurger;
        this.worldsMap = new HashMap<String, MultiverseWorld>();
        this.loadedWorldsMap = new HashMap<String, LoadedMultiverseWorld>();
        this.unloadTracker = new ArrayList<String>();
        this.loadTracker = new ArrayList<String>();
    }

    @ApiStatus.Internal
    public Try<Void> initAllWorlds() {
        return this.updateWorldsFromConfig().andThenTry(() -> {
            this.importExistingWorlds();
            this.autoLoadWorlds();
        }).flatMap(ignore -> this.saveWorldsConfig());
    }

    private Try<Void> updateWorldsFromConfig() {
        return this.worldsConfigManager.load().mapTry(result -> {
            this.loadNewWorldConfigs(result.newWorlds());
            this.removeWorldsNotInConfigs(result.removedWorlds());
            return null;
        });
    }

    private void loadNewWorldConfigs(Collection<WorldConfig> newWorldConfigs) {
        newWorldConfigs.forEach(worldConfig -> Option.of(this.worldsMap.get(worldConfig.getWorldName())).peek(unloadedWorld -> unloadedWorld.setWorldConfig((WorldConfig)worldConfig)).onEmpty(() -> this.newMultiverseWorld(worldConfig.getWorldName(), (WorldConfig)worldConfig)));
    }

    private void removeWorldsNotInConfigs(Collection<String> removedWorlds) {
        removedWorlds.forEach(worldName -> this.getWorld((String)worldName).fold(() -> Attempt.failure(FailureReason.GENERIC, Message.of("world already removed", new MessageReplacement[0])), world -> this.removeWorld(RemoveWorldOptions.world(world))).onFailure(failure -> CoreLogging.severe("Failed to unload world %s: %s", worldName, failure)).onSuccess(success -> CoreLogging.fine("Unloaded world %s as it was removed from config", worldName)));
    }

    private void importExistingWorlds() {
        Map bukkitWorlds = Bukkit.getWorlds().stream().collect(Collectors.toMap(WorldInfo::getName, Function.identity()));
        this.serverProperties.getLevelName().peek(overworldName -> {
            World overworld = (World)bukkitWorlds.remove(overworldName);
            World nether = (World)bukkitWorlds.remove(DEFAULT_NETHER_FORMAT.replaceOverworld((String)overworldName));
            World end = (World)bukkitWorlds.remove(DEFAULT_END_FORMAT.replaceOverworld((String)overworldName));
            if (this.config.getAutoImportDefaultWorlds()) {
                this.importExistingBukkitWorld(overworld);
                this.importExistingBukkitWorld(nether);
                this.importExistingBukkitWorld(end);
            }
        });
        if (this.config.getAutoImport3rdPartyWorlds()) {
            bukkitWorlds.values().forEach(this::importExistingBukkitWorld);
        }
    }

    private void importExistingBukkitWorld(World bukkitWorld) {
        if (bukkitWorld == null || this.isWorld(bukkitWorld.getName())) {
            return;
        }
        this.importWorld(ImportWorldOptions.worldName(bukkitWorld.getName()).environment(bukkitWorld.getEnvironment()).generator(this.generatorProvider.getDefaultGeneratorForWorld(bukkitWorld.getName()))).onFailure(failure -> CoreLogging.severe("Failed to import world %s: %s", bukkitWorld.getName(), failure)).onSuccess(success -> CoreLogging.fine("Imported existing world %s", bukkitWorld.getName()));
    }

    private void autoLoadWorlds() {
        this.getWorlds().forEach(world -> {
            if (this.isLoadedWorld((MultiverseWorld)world) || !world.isAutoLoad()) {
                return;
            }
            this.loadWorld(LoadWorldOptions.world(world)).onFailure(failure -> CoreLogging.severe("Failed to load world %s: %s", world.getName(), failure));
        });
    }

    public Attempt<LoadedMultiverseWorld, CreateFailureReason> createWorld(CreateWorldOptions options) {
        return this.validateCreateWorldOptions(options).mapAttempt(this::doCreateWorld);
    }

    private Attempt<CreateWorldOptions, CreateFailureReason> validateCreateWorldOptions(CreateWorldOptions options) {
        if (!this.worldNameChecker.isValidWorldName(options.worldName())) {
            return this.worldActionResult(CreateFailureReason.INVALID_WORLDNAME, options.worldName());
        }
        if (this.getLoadedWorld(options.worldName()).isDefined()) {
            return this.worldActionResult(CreateFailureReason.WORLD_EXIST_LOADED, options.worldName());
        }
        if (this.getWorld(options.worldName()).isDefined()) {
            return this.worldActionResult(CreateFailureReason.WORLD_EXIST_UNLOADED, options.worldName());
        }
        if (options.doFolderCheck() && this.worldNameChecker.hasWorldFolder(options.worldName())) {
            return this.worldActionResult(CreateFailureReason.WORLD_EXIST_FOLDER, options.worldName());
        }
        return this.worldActionResult(options);
    }

    private Attempt<LoadedMultiverseWorld, CreateFailureReason> doCreateWorld(CreateWorldOptions options) {
        String generatorString = this.generatorProvider.parseGeneratorString(options.worldName(), options.generator());
        WorldCreator worldCreator = WorldCreator.name((String)options.worldName()).environment(options.environment()).generateStructures(options.generateStructures()).generatorSettings(options.generatorSettings()).seed(options.seed()).type(options.worldType());
        return this.addBiomeProviderToCreator(worldCreator, options.worldName(), options.biome()).mapAttempt(creator -> this.addGeneratorToCreator((WorldCreator)creator, generatorString)).mapAttempt(this::createBukkitWorld).transform(CreateFailureReason.WORLD_CREATOR_FAILED).map(bukkitWorld -> {
            LoadedMultiverseWorld loadedWorld = this.newLoadedMultiverseWorld((World)bukkitWorld, generatorString, options.biome(), options.useSpawnAdjust());
            this.pluginManager.callEvent((Event)new MVWorldCreatedEvent(loadedWorld));
            return loadedWorld;
        });
    }

    public Attempt<LoadedMultiverseWorld, ImportFailureReason> importWorld(ImportWorldOptions options) {
        String worldName = options.worldName();
        if (this.isLoadedWorld(worldName)) {
            return this.worldActionResult(ImportFailureReason.WORLD_EXIST_LOADED, worldName);
        }
        if (this.isWorld(worldName)) {
            return this.worldActionResult(ImportFailureReason.WORLD_EXIST_UNLOADED, worldName);
        }
        World bukkitWorld = Bukkit.getWorld((String)worldName);
        if (bukkitWorld != null) {
            return this.doImportBukkitWorld(options, bukkitWorld);
        }
        return this.validateImportWorldOptions(options).mapAttempt(this::doImportWorld);
    }

    private Attempt<ImportWorldOptions, ImportFailureReason> validateImportWorldOptions(ImportWorldOptions options) {
        String worldName = options.worldName();
        if (!this.worldNameChecker.isValidWorldName(worldName)) {
            return this.worldActionResult(ImportFailureReason.INVALID_WORLDNAME, worldName);
        }
        if (options.doFolderCheck() && !this.worldNameChecker.isValidWorldFolder(worldName)) {
            return this.worldActionResult(ImportFailureReason.WORLD_FOLDER_INVALID, worldName);
        }
        return this.worldActionResult(options);
    }

    private Attempt<LoadedMultiverseWorld, ImportFailureReason> doImportWorld(ImportWorldOptions options) {
        String generatorString = this.generatorProvider.parseGeneratorString(options.worldName(), options.generator());
        WorldCreator worldCreator = WorldCreator.name((String)options.worldName()).environment(options.environment());
        return this.addBiomeProviderToCreator(worldCreator, options.worldName(), options.biome()).mapAttempt(creator -> this.addGeneratorToCreator((WorldCreator)creator, generatorString)).mapAttempt(this::createBukkitWorld).transform(ImportFailureReason.WORLD_CREATOR_FAILED).map(bukkitWorld -> {
            LoadedMultiverseWorld loadedWorld = this.newLoadedMultiverseWorld((World)bukkitWorld, generatorString, options.biome(), options.useSpawnAdjust());
            this.pluginManager.callEvent((Event)new MVWorldImportedEvent(loadedWorld));
            return loadedWorld;
        });
    }

    private Attempt<LoadedMultiverseWorld, ImportFailureReason> doImportBukkitWorld(ImportWorldOptions options, World bukkitWorld) {
        if (options.environment() != bukkitWorld.getEnvironment()) {
            return Attempt.failure(ImportFailureReason.BUKKIT_ENVIRONMENT_MISMATCH, MessageReplacement.Replace.WORLD.with(bukkitWorld.getName()), MessageReplacement.replace("{bukkitEnvironment}").with(bukkitWorld.getEnvironment().name()), MessageReplacement.replace("{mvEnvironment}").with(options.environment().name()));
        }
        LoadedMultiverseWorld loadedWorld = this.newLoadedMultiverseWorld(bukkitWorld, this.generatorProvider.parseGeneratorString(options.worldName(), options.generator()), options.biome(), options.useSpawnAdjust());
        this.pluginManager.callEvent((Event)new MVWorldImportedEvent(loadedWorld));
        return Attempt.success(loadedWorld);
    }

    private MultiverseWorld newMultiverseWorld(String worldName, WorldConfig worldConfig) {
        MultiverseWorld mvWorld = new MultiverseWorld(worldName, worldConfig, this.config);
        this.worldsMap.put(mvWorld.getName(), mvWorld);
        this.corePermissions.addWorldPermissions(mvWorld);
        return mvWorld;
    }

    private LoadedMultiverseWorld newLoadedMultiverseWorld(@NotNull World world, @Nullable String generator, @Nullable String biome, boolean adjustSpawn) {
        WorldConfig worldConfig = this.worldsConfigManager.addWorldConfig(world.getName());
        worldConfig.setAdjustSpawn(adjustSpawn);
        worldConfig.setGenerator(generator == null ? "" : generator);
        worldConfig.setBiome(biome == null ? "" : biome);
        worldConfig.setDifficulty(world.getDifficulty());
        worldConfig.setKeepSpawnInMemory(world.getKeepSpawnInMemory());
        worldConfig.setScale(this.getCoordinateScale(world));
        worldConfig.save();
        this.newMultiverseWorld(world.getName(), worldConfig);
        LoadedMultiverseWorld loadedWorld = new LoadedMultiverseWorld(world, worldConfig, this.config, this.blockSafety, this.locationManipulation, this.entityPurger);
        this.loadedWorldsMap.put(loadedWorld.getName(), loadedWorld);
        this.saveWorldsConfig();
        this.pluginManager.callEvent((Event)new MVWorldLoadedEvent(loadedWorld));
        return loadedWorld;
    }

    private double getCoordinateScale(World world) {
        if (PaperLib.isPaper()) {
            return world.getCoordinateScale();
        }
        return switch (world.getEnvironment()) {
            case World.Environment.NORMAL -> 1.0;
            case World.Environment.NETHER -> 8.0;
            default -> 1.0;
        };
    }

    @Deprecated(since="5.2", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="6.0")
    public Attempt<LoadedMultiverseWorld, LoadFailureReason> loadWorld(@NotNull String worldName) {
        return this.getWorld(worldName).map(world -> this.loadWorld(LoadWorldOptions.world(world))).getOrElse(() -> this.worldNameChecker.isValidWorldFolder(worldName) ? this.worldActionResult(LoadFailureReason.WORLD_EXIST_FOLDER, worldName) : this.worldActionResult(LoadFailureReason.WORLD_NON_EXISTENT, worldName));
    }

    @Deprecated(since="5.2", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="6.0")
    public Attempt<LoadedMultiverseWorld, LoadFailureReason> loadWorld(@NotNull MultiverseWorld world) {
        return this.loadWorld(LoadWorldOptions.world(world));
    }

    @ApiStatus.AvailableSince(value="5.2")
    public Attempt<LoadedMultiverseWorld, LoadFailureReason> loadWorld(@NotNull LoadWorldOptions options) {
        return this.validateWorldToLoad(options).mapAttempt(this::doLoadWorld);
    }

    private Attempt<LoadWorldOptions, LoadFailureReason> validateWorldToLoad(@NotNull LoadWorldOptions options) {
        MultiverseWorld mvWorld = options.world();
        if (this.loadTracker.contains(mvWorld.getName())) {
            CoreLogging.fine("World already loading: " + mvWorld.getName(), new Object[0]);
            return this.worldActionResult(LoadFailureReason.WORLD_ALREADY_LOADING, mvWorld.getName());
        }
        if (this.isLoadedWorld(mvWorld)) {
            CoreLogging.severe("World already loaded: " + mvWorld.getName(), new Object[0]);
            return this.worldActionResult(LoadFailureReason.WORLD_EXIST_LOADED, mvWorld.getName());
        }
        return this.worldActionResult(options);
    }

    private Attempt<LoadedMultiverseWorld, LoadFailureReason> doLoadWorld(@NotNull LoadWorldOptions options) {
        MultiverseWorld mvWorld = options.world();
        World bukkitWorld = Bukkit.getWorld((String)mvWorld.getName());
        if (bukkitWorld != null) {
            return this.doLoadBukkitWorld(bukkitWorld, mvWorld);
        }
        if (options.doFolderCheck() && !this.worldNameChecker.isValidWorldFolder(mvWorld.getName())) {
            return this.worldActionResult(LoadFailureReason.WORLD_FOLDER_INVALID, mvWorld.getName());
        }
        WorldCreator worldCreator = WorldCreator.name((String)mvWorld.getName()).environment(mvWorld.getEnvironment()).seed(mvWorld.getSeed());
        return this.addBiomeProviderToCreator(worldCreator, mvWorld.getName(), mvWorld.getBiome()).mapAttempt(creator -> this.addGeneratorToCreator((WorldCreator)creator, mvWorld.getGenerator())).mapAttempt(this::createBukkitWorld).transform(LoadFailureReason.WORLD_CREATOR_FAILED).mapAttempt(newBukkitWorld -> this.newLoadedMultiverseWorld(mvWorld, (World)newBukkitWorld));
    }

    @NotNull
    private Attempt<LoadedMultiverseWorld, LoadFailureReason> doLoadBukkitWorld(World bukkitWorld, MultiverseWorld mvWorld) {
        if (bukkitWorld.getEnvironment() != mvWorld.getEnvironment()) {
            return Attempt.failure(LoadFailureReason.BUKKIT_ENVIRONMENT_MISMATCH, MessageReplacement.Replace.WORLD.with(mvWorld.getName()), MessageReplacement.replace("{bukkitEnvironment}").with(bukkitWorld.getEnvironment().name()), MessageReplacement.replace("{mvEnvironment}").with(mvWorld.getEnvironment().name()));
        }
        CoreLogging.finer("World already loaded in bukkit: " + mvWorld.getName(), new Object[0]);
        return this.newLoadedMultiverseWorld(mvWorld, bukkitWorld);
    }

    private Attempt<LoadedMultiverseWorld, LoadFailureReason> newLoadedMultiverseWorld(MultiverseWorld mvWorld, World bukkitWorld) {
        WorldConfig worldConfig = this.worldsConfigManager.getWorldConfig(mvWorld.getName()).get();
        LoadedMultiverseWorld loadedWorld = new LoadedMultiverseWorld(bukkitWorld, worldConfig, this.config, this.blockSafety, this.locationManipulation, this.entityPurger);
        this.loadedWorldsMap.put(loadedWorld.getName(), loadedWorld);
        this.saveWorldsConfig();
        this.pluginManager.callEvent((Event)new MVWorldLoadedEvent(loadedWorld));
        return Attempt.success(loadedWorld);
    }

    public Attempt<MultiverseWorld, UnloadFailureReason> unloadWorld(@NotNull UnloadWorldOptions options) {
        LoadedMultiverseWorld world = options.world();
        if (this.unloadTracker.contains(world.getName())) {
            CoreLogging.fine("World already unloading: " + world.getName(), new Object[0]);
            return this.worldActionResult(UnloadFailureReason.WORLD_ALREADY_UNLOADING, world.getName());
        }
        if (!this.isLoadedWorld(world)) {
            CoreLogging.severe("World is not loaded: " + world.getName(), new Object[0]);
            return this.worldActionResult(UnloadFailureReason.WORLD_NON_EXISTENT, world.getName());
        }
        if (!options.unloadBukkitWorld()) {
            return this.removeLoadedMultiverseWorld(world);
        }
        return this.unloadBukkitWorld((World)world.getBukkitWorld().getOrNull(), options.saveBukkitWorld()).fold(exception -> this.worldActionResult((FailureReason)UnloadFailureReason.BUKKIT_UNLOAD_FAILED, world.getName(), (Throwable)exception), success -> this.removeLoadedMultiverseWorld(world));
    }

    private Attempt<MultiverseWorld, UnloadFailureReason> removeLoadedMultiverseWorld(@NotNull LoadedMultiverseWorld world) {
        MultiverseWorld mvWorld = Objects.requireNonNull(this.loadedWorldsMap.remove(world.getName()), "For some reason, the loaded world isn't in the map... BUGGG");
        CoreLogging.fine("Removed MultiverseWorld from map: " + world.getName(), new Object[0]);
        MultiverseWorld unloadedWorld = Objects.requireNonNull(this.worldsMap.get(world.getName()), "For some reason, the unloaded world isn't in the map... BUGGG");
        mvWorld.getWorldConfig().setMVWorld(unloadedWorld);
        this.pluginManager.callEvent((Event)new MVWorldUnloadedEvent(mvWorld));
        return this.worldActionResult(unloadedWorld);
    }

    @Deprecated(since="5.2", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="6.0")
    public Attempt<String, RemoveFailureReason> removeWorld(@NotNull String worldName) {
        return this.getWorld(worldName).map(world -> this.removeWorld(RemoveWorldOptions.world(world))).getOrElse(() -> this.worldActionResult(RemoveFailureReason.WORLD_NON_EXISTENT, worldName));
    }

    @Deprecated(since="5.2", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="6.0")
    public Attempt<String, RemoveFailureReason> removeWorld(@NotNull MultiverseWorld world) {
        return this.removeWorld(RemoveWorldOptions.world(world));
    }

    @Deprecated(since="5.2", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="6.0")
    public Attempt<String, RemoveFailureReason> removeWorld(@NotNull LoadedMultiverseWorld loadedWorld) {
        return this.removeWorld(RemoveWorldOptions.world(loadedWorld));
    }

    @ApiStatus.AvailableSince(value="5.2")
    public Attempt<String, RemoveFailureReason> removeWorld(@NotNull RemoveWorldOptions options) {
        MultiverseWorld world = options.world();
        return this.getLoadedWorld(world).fold(() -> this.removeWorldFromConfig(world), loadedWorld -> this.unloadBeforeRemoveWorld((LoadedMultiverseWorld)loadedWorld, options));
    }

    private Attempt<String, RemoveFailureReason> unloadBeforeRemoveWorld(@NotNull LoadedMultiverseWorld loadedWorld, @NotNull RemoveWorldOptions options) {
        UnloadWorldOptions unloadWorldOptions = UnloadWorldOptions.world(loadedWorld).saveBukkitWorld(options.saveBukkitWorld()).unloadBukkitWorld(options.unloadBukkitWorld());
        return this.unloadWorld(unloadWorldOptions).transform(RemoveFailureReason.UNLOAD_FAILED).mapAttempt(this::removeWorldFromConfig);
    }

    private Attempt<String, RemoveFailureReason> removeWorldFromConfig(@NotNull MultiverseWorld world) {
        this.worldsMap.remove(world.getName());
        world.getWorldConfig().deferenceMVWorld();
        this.worldsConfigManager.deleteWorldConfig(world.getName());
        this.saveWorldsConfig();
        this.corePermissions.removeWorldPermissions(world);
        this.pluginManager.callEvent((Event)new MVWorldRemovedEvent(world));
        return this.worldActionResult(world.getName());
    }

    public Attempt<String, DeleteFailureReason> deleteWorld(@NotNull DeleteWorldOptions options) {
        return this.getLoadedWorld(options.world()).fold(() -> this.loadThenDeleteWorld(options), world -> this.doDeleteWorld((LoadedMultiverseWorld)world, options));
    }

    private Attempt<String, DeleteFailureReason> loadThenDeleteWorld(@NotNull DeleteWorldOptions options) {
        return this.loadWorld(LoadWorldOptions.world(options.world())).fold(ignore -> this.worldActionResult(DeleteFailureReason.LOAD_FAILED, options.world().getName()), loadedWorld -> this.doDeleteWorld((LoadedMultiverseWorld)loadedWorld, options));
    }

    private Attempt<String, DeleteFailureReason> doDeleteWorld(@NotNull LoadedMultiverseWorld world, @NotNull DeleteWorldOptions options) {
        AtomicReference worldFolder = new AtomicReference();
        return this.validateWorldToDelete(world).peek(worldFolder::set).mapAttempt(() -> {
            MVWorldDeleteEvent event = new MVWorldDeleteEvent(world);
            this.pluginManager.callEvent((Event)event);
            return event.isCancelled() ? Attempt.failure(DeleteFailureReason.EVENT_CANCELLED, new MessageReplacement[0]) : Attempt.success(null);
        }).mapAttempt(() -> this.removeWorld(RemoveWorldOptions.world(world).unloadBukkitWorld(true).saveBukkitWorld(false)).transform(DeleteFailureReason.REMOVE_FAILED)).mapAttempt(() -> this.fileUtils.deleteFolder((File)worldFolder.get(), options.keepFiles()).fold(exception -> this.worldActionResult((FailureReason)DeleteFailureReason.FAILED_TO_DELETE_FOLDER, world.getName(), (Throwable)exception), success -> this.worldActionResult(world.getName())));
    }

    private Attempt<File, DeleteFailureReason> validateWorldToDelete(@NotNull LoadedMultiverseWorld world) {
        File worldFolder = (File)world.getBukkitWorld().map(World::getWorldFolder).getOrNull();
        if (worldFolder == null || !this.worldNameChecker.isValidWorldFolder(worldFolder)) {
            CoreLogging.severe("Failed to get world folder for world: " + world.getName(), new Object[0]);
            return this.worldActionResult(DeleteFailureReason.WORLD_FOLDER_NOT_FOUND, world.getName());
        }
        return this.worldActionResult(worldFolder);
    }

    public Attempt<LoadedMultiverseWorld, CloneFailureReason> cloneWorld(@NotNull CloneWorldOptions options) {
        return this.cloneWorldValidateWorld(options).mapAttempt(this::cloneWorldCopyFolder).mapAttempt(validatedOptions -> {
            ImportWorldOptions importWorldOptions = ImportWorldOptions.worldName(validatedOptions.newWorldName()).biome(validatedOptions.world().getBiome()).environment(validatedOptions.world().getEnvironment()).generator(validatedOptions.world().getGenerator());
            return this.importWorld(importWorldOptions).transform(CloneFailureReason.IMPORT_FAILED);
        }).onSuccess(newWorld -> {
            this.cloneWorldTransferData(options, (LoadedMultiverseWorld)newWorld);
            if (options.keepWorldConfig()) {
                newWorld.setSpawnLocation(options.world().getSpawnLocation());
            }
            this.saveWorldsConfig();
            this.pluginManager.callEvent((Event)new MVWorldClonedEvent((LoadedMultiverseWorld)newWorld, options.world()));
        });
    }

    private Attempt<CloneWorldOptions, CloneFailureReason> cloneWorldValidateWorld(@NotNull CloneWorldOptions options) {
        String newWorldName = options.newWorldName();
        if (!this.worldNameChecker.isValidWorldName(newWorldName)) {
            CoreLogging.severe("Invalid world name: " + newWorldName, new Object[0]);
            return this.worldActionResult(CloneFailureReason.INVALID_WORLDNAME, newWorldName);
        }
        if (this.isLoadedWorld(newWorldName)) {
            CoreLogging.severe("World already loaded when attempting to clone: " + newWorldName, new Object[0]);
            return this.worldActionResult(CloneFailureReason.WORLD_EXIST_LOADED, newWorldName);
        }
        if (this.isWorld(newWorldName)) {
            CoreLogging.severe("World already exist unloaded: " + newWorldName, new Object[0]);
            return this.worldActionResult(CloneFailureReason.WORLD_EXIST_UNLOADED, newWorldName);
        }
        if (this.worldNameChecker.hasWorldFolder(newWorldName)) {
            return this.worldActionResult(CloneFailureReason.WORLD_EXIST_FOLDER, newWorldName);
        }
        return this.worldActionResult(options);
    }

    private Attempt<CloneWorldOptions, CloneFailureReason> cloneWorldCopyFolder(@NotNull CloneWorldOptions options) {
        if (options.saveBukkitWorld()) {
            CoreLogging.finer("Saving bukkit world before cloning: " + options.world().getName(), new Object[0]);
            options.world().getBukkitWorld().peek(this::saveWorldWithFlush);
        }
        File worldFolder = (File)options.world().getBukkitWorld().map(World::getWorldFolder).get();
        File newWorldFolder = new File(Bukkit.getWorldContainer(), options.newWorldName());
        return this.fileUtils.copyFolder(worldFolder, newWorldFolder, CLONE_IGNORE_FILES).fold(exception -> this.worldActionResult((FailureReason)CloneFailureReason.COPY_FAILED, options.world().getName(), (Throwable)exception), success -> this.worldActionResult(options));
    }

    private void saveWorldWithFlush(World world) {
        if (this.saveWithFlush != null) {
            CoreLogging.fine("Using world save method with flush...", new Object[0]);
            ReflectHelper.invokeMethod(world, this.saveWithFlush, true);
        } else {
            world.save();
        }
    }

    private void cloneWorldTransferData(@NotNull CloneWorldOptions options, @NotNull LoadedMultiverseWorld newWorld) {
        DataTransfer<LoadedMultiverseWorld> dataTransfer = this.transferData(options, options.world());
        dataTransfer.pasteAllTo(newWorld);
    }

    private DataTransfer<LoadedMultiverseWorld> transferData(@NotNull KeepWorldSettingsOptions options, @NotNull LoadedMultiverseWorld world) {
        DataTransfer<LoadedMultiverseWorld> dataTransfer = new DataTransfer<LoadedMultiverseWorld>();
        if (options.keepWorldConfig()) {
            dataTransfer.addDataStore(new DataStore.WorldConfigStore(), world);
        }
        if (options.keepGameRule()) {
            dataTransfer.addDataStore(new DataStore.GameRulesStore(), world);
        }
        if (options.keepWorldBorder()) {
            dataTransfer.addDataStore(new DataStore.WorldBorderStore(), world);
        }
        return dataTransfer;
    }

    public Attempt<LoadedMultiverseWorld, RegenFailureReason> regenWorld(@NotNull RegenWorldOptions options) {
        LoadedMultiverseWorld world = options.world();
        DataTransfer<LoadedMultiverseWorld> dataTransfer = this.transferData(options, world);
        boolean shouldKeepSpawnLocation = options.keepWorldConfig() && options.seed() == world.getSeed();
        Location spawnLocation = world.getSpawnLocation();
        CreateWorldOptions createWorldOptions = CreateWorldOptions.worldName(world.getName()).environment(world.getEnvironment()).generateStructures(world.canGenerateStructures().getOrElse(true)).generator(world.getGenerator()).seed(options.seed()).useSpawnAdjust(!shouldKeepSpawnLocation && world.getAdjustSpawn()).worldType(world.getWorldType().getOrElse(WorldType.NORMAL)).doFolderCheck(options.keepFiles().isEmpty());
        return this.deleteWorld(DeleteWorldOptions.world(world).keepFiles(options.keepFiles())).transform(RegenFailureReason.DELETE_FAILED).mapAttempt(() -> this.createWorld(createWorldOptions).transform(RegenFailureReason.CREATE_FAILED)).onSuccess(newWorld -> {
            dataTransfer.pasteAllTo((LoadedMultiverseWorld)newWorld);
            if (shouldKeepSpawnLocation) {
                newWorld.setSpawnLocation(spawnLocation);
            }
            this.saveWorldsConfig();
            this.pluginManager.callEvent((Event)new MVWorldRegeneratedEvent((LoadedMultiverseWorld)newWorld));
        });
    }

    private <T, F extends FailureReason> Attempt<T, F> worldActionResult(@NotNull T value) {
        return Attempt.success(value);
    }

    private <T, F extends FailureReason> Attempt<T, F> worldActionResult(@NotNull F failureReason, @NotNull String worldName) {
        return Attempt.failure(failureReason, MessageReplacement.Replace.WORLD.with(worldName));
    }

    private <T, F extends FailureReason> Attempt<T, F> worldActionResult(@NotNull F failureReason, @NotNull String worldName, @NotNull Throwable error) {
        return Attempt.failure(failureReason, MessageReplacement.Replace.WORLD.with(worldName), MessageReplacement.Replace.ERROR.with(error));
    }

    private Attempt<WorldCreator, WorldCreatorFailureReason> addBiomeProviderToCreator(WorldCreator worldCreator, String worldName, String biomeString) {
        return Try.of(() -> worldCreator.biomeProvider(this.biomeProviderFactory.parseBiomeProvider(worldName, biomeString))).fold(throwable -> {
            throwable.printStackTrace();
            return Attempt.failure(WorldCreatorFailureReason.INVALID_BIOME_PROVIDER, MessageReplacement.replace("{biome}").with(biomeString), MessageReplacement.Replace.ERROR.with(throwable));
        }, Attempt::success);
    }

    private Attempt<WorldCreator, WorldCreatorFailureReason> addGeneratorToCreator(WorldCreator worldCreator, String generatorString) {
        if (Strings.isNullOrEmpty((String)generatorString)) {
            return Attempt.success(worldCreator);
        }
        return Try.of(() -> worldCreator.generator(generatorString)).fold(throwable -> {
            throwable.printStackTrace();
            return Attempt.failure(WorldCreatorFailureReason.INVALID_CHUNK_GENERATOR, MessageReplacement.replace("{generator}").with(generatorString), MessageReplacement.Replace.ERROR.with(throwable));
        }, Attempt::success);
    }

    private Attempt<World, WorldCreatorFailureReason> createBukkitWorld(WorldCreator worldCreator) {
        return Try.of(() -> {
            this.loadTracker.add(worldCreator.name());
            World world = worldCreator.createWorld();
            if (world == null) {
                throw new MultiverseWorldException(Message.of((MessageKeyProvider)MVCorei18n.EXCEPTION_MULTIVERSEWORLD_CREATENULL, new MessageReplacement[0]));
            }
            CoreLogging.fine("Bukkit created world: " + world.getName(), new Object[0]);
            return world;
        }).onFailure(exception -> {
            CoreLogging.severe("Failed to create bukkit world: " + worldCreator.name(), new Object[0]);
            exception.printStackTrace();
        }).andFinally(() -> this.loadTracker.remove(worldCreator.name())).fold(throwable -> Attempt.failure(WorldCreatorFailureReason.BUKKIT_CREATION_FAILED, MessageReplacement.Replace.WORLD.with(worldCreator.name()), MessageReplacement.Replace.ERROR.with(throwable)), Attempt::success);
    }

    private Try<Void> unloadBukkitWorld(World world, boolean save) {
        return Try.run(() -> {
            if (world == null) {
                return;
            }
            this.unloadTracker.add(world.getName());
            if (!Bukkit.unloadWorld((World)world, (boolean)save)) {
                this.throwUnloadException(world);
            }
            CoreLogging.fine("Bukkit unloaded world: " + world.getName(), new Object[0]);
        }).andFinally(() -> this.unloadTracker.remove(world.getName()));
    }

    private void throwUnloadException(World world) throws MultiverseWorldException {
        String defaultWorldName = this.getDefaultWorld().map(MultiverseWorld::getName).getOrElse("");
        if (Objects.equals(world.getName(), defaultWorldName)) {
            throw new MultiverseWorldException(Message.of((MessageKeyProvider)MVCorei18n.EXCEPTION_MULTIVERSEWORLD_UNLOADDEFAULTWORLD, MessageReplacement.Replace.WORLD.with(world.getName())));
        }
        if (!world.getPlayers().isEmpty()) {
            throw new MultiverseWorldException(Message.of((MessageKeyProvider)MVCorei18n.EXCEPTION_MULTIVERSEWORLD_UNLOADPLAYERSINWORLD, MessageReplacement.replace("{count}").with(world.getPlayers().size())));
        }
        throw new MultiverseWorldException(Message.of((MessageKeyProvider)MVCorei18n.EXCEPTION_MULTIVERSEWORLD_UNLOADERROR, new MessageReplacement[0]));
    }

    public List<String> getPotentialWorlds() {
        File[] files = Bukkit.getWorldContainer().listFiles();
        if (files == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(files).filter(file -> !this.isWorld(file.getName())).filter(this.worldNameChecker::isValidWorldFolder).map(File::getName).toList();
    }

    public Option<MultiverseWorld> getWorld(@Nullable World world) {
        return Option.of(world).map(WorldInfo::getName).flatMap(this::getWorld);
    }

    public Option<MultiverseWorld> getWorld(@Nullable String worldName) {
        return this.getLoadedWorld(worldName).fold(() -> this.getUnloadedWorld(worldName), Option::of);
    }

    public Option<MultiverseWorld> getWorldByNameOrAlias(@Nullable String worldNameOrAlias) {
        return this.getLoadedWorldByNameOrAlias(worldNameOrAlias).fold(() -> this.getUnloadedWorldByNameOrAlias(worldNameOrAlias), Option::of);
    }

    public Collection<MultiverseWorld> getWorlds() {
        return this.worldsMap.values().stream().map(world -> this.getLoadedWorld((MultiverseWorld)world).fold(() -> world, loadedWorld -> loadedWorld)).toList();
    }

    public boolean isWorld(@Nullable String worldName) {
        return this.worldsMap.containsKey(worldName);
    }

    public Option<MultiverseWorld> getUnloadedWorld(@Nullable String worldName) {
        return this.isLoadedWorld(worldName) ? Option.none() : Option.of(this.worldsMap.get(worldName));
    }

    public Option<MultiverseWorld> getUnloadedWorldByNameOrAlias(@Nullable String worldNameOrAlias) {
        return this.getUnloadedWorld(worldNameOrAlias).orElse(() -> this.getUnloadedWorldByAlias(worldNameOrAlias));
    }

    private Option<MultiverseWorld> getUnloadedWorldByAlias(@Nullable String alias) {
        if (alias == null || alias.isEmpty()) {
            return Option.none();
        }
        String colourlessAlias = ChatTextFormatter.removeColor(alias);
        return Option.ofOptional(this.worldsMap.values().stream().filter(world -> !world.isLoaded()).filter(world -> world.getColourlessAlias().equalsIgnoreCase(colourlessAlias)).findFirst());
    }

    public Collection<MultiverseWorld> getUnloadedWorlds() {
        return this.worldsMap.values().stream().filter(world -> !world.isLoaded()).toList();
    }

    public boolean isUnloadedWorld(@Nullable String worldName) {
        return !this.isLoadedWorld(worldName) && this.isWorld(worldName);
    }

    public Option<LoadedMultiverseWorld> getLoadedWorld(@Nullable World world) {
        return world == null ? Option.none() : Option.of(this.loadedWorldsMap.get(world.getName()));
    }

    public Option<LoadedMultiverseWorld> getLoadedWorld(@Nullable MultiverseWorld world) {
        return world == null ? Option.none() : Option.of(this.loadedWorldsMap.get(world.getName()));
    }

    public Option<LoadedMultiverseWorld> getLoadedWorld(@Nullable String worldName) {
        return Option.of(this.loadedWorldsMap.get(worldName));
    }

    public Option<LoadedMultiverseWorld> getLoadedWorldByNameOrAlias(@Nullable String worldNameOrAlias) {
        return this.getLoadedWorld(worldNameOrAlias).orElse(() -> this.getLoadedWorldByAlias(worldNameOrAlias));
    }

    private Option<LoadedMultiverseWorld> getLoadedWorldByAlias(@Nullable String alias) {
        if (alias == null || alias.isEmpty()) {
            return Option.none();
        }
        return Option.ofOptional(this.loadedWorldsMap.values().stream().filter(world -> world.getColourlessAlias().equalsIgnoreCase(ChatTextFormatter.removeColor(alias))).findFirst());
    }

    public Collection<LoadedMultiverseWorld> getLoadedWorlds() {
        return this.loadedWorldsMap.values().stream().toList();
    }

    public boolean isLoadedWorld(@Nullable World world) {
        return world != null && this.isLoadedWorld(world.getName());
    }

    public boolean isLoadedWorld(@Nullable MultiverseWorld world) {
        return world != null && this.isLoadedWorld(world.getName());
    }

    public boolean isLoadedWorld(@Nullable String worldName) {
        return this.loadedWorldsMap.containsKey(worldName);
    }

    public Option<LoadedMultiverseWorld> getDefaultWorld() {
        return this.serverProperties.getLevelName().flatMap(this::getLoadedWorld).orElse(this.getLoadedWorld((World)Bukkit.getWorlds().get(0)));
    }

    public Try<Void> saveWorldsConfig() {
        return this.worldsConfigManager.save().onFailure(failure -> {
            CoreLogging.severe("Failed to save worlds config: %s", failure);
            failure.printStackTrace();
        });
    }
}

