/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.mvplugins.multiverse.core.MultiverseCore;
import org.mvplugins.multiverse.core.anchor.AnchorManager;
import org.mvplugins.multiverse.core.config.CoreConfig;
import org.mvplugins.multiverse.core.destination.DestinationsProvider;
import org.mvplugins.multiverse.core.economy.MVEconomist;
import org.mvplugins.multiverse.core.inject.PluginServiceLocator;
import org.mvplugins.multiverse.core.teleportation.AsyncSafetyTeleporter;
import org.mvplugins.multiverse.core.teleportation.BlockSafety;
import org.mvplugins.multiverse.core.teleportation.LocationManipulation;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.core.world.biomeprovider.BiomeProviderFactory;
import org.mvplugins.multiverse.core.world.generators.GeneratorProvider;
import org.mvplugins.multiverse.external.jetbrains.annotations.ApiStatus;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;

public class MultiverseCoreApi {
    private static MultiverseCoreApi instance;
    private static final List<Consumer<MultiverseCoreApi>> whenLoadedCallbacks;
    private final PluginServiceLocator serviceLocator;

    static void init(@NotNull MultiverseCore multiverseCore) {
        if (instance != null) {
            throw new IllegalStateException("MultiverseCoreApi has already been initialized!");
        }
        instance = new MultiverseCoreApi(multiverseCore.getServiceLocator());
        Bukkit.getServicesManager().register(MultiverseCoreApi.class, (Object)instance, (Plugin)multiverseCore, ServicePriority.Normal);
        whenLoadedCallbacks.forEach(c -> c.accept(instance));
        whenLoadedCallbacks.clear();
    }

    static void shutdown() {
        Bukkit.getServicesManager().unregister((Object)instance);
        instance = null;
    }

    @ApiStatus.AvailableSince(value="5.1")
    public static void whenLoaded(@NotNull Consumer<MultiverseCoreApi> consumer) {
        if (instance != null) {
            consumer.accept(instance);
        } else {
            whenLoadedCallbacks.add(consumer);
        }
    }

    @ApiStatus.AvailableSince(value="5.1")
    public static boolean isLoaded() {
        return instance != null;
    }

    @NotNull
    public static MultiverseCoreApi get() {
        if (instance == null) {
            throw new IllegalStateException("MultiverseCoreApi has not been initialized!");
        }
        return instance;
    }

    private MultiverseCoreApi(@NotNull PluginServiceLocator serviceProvider) {
        this.serviceLocator = serviceProvider;
    }

    @NotNull
    public AnchorManager getAnchorManager() {
        return Objects.requireNonNull(this.serviceLocator.getActiveService(AnchorManager.class, new Annotation[0]));
    }

    @NotNull
    public BiomeProviderFactory getBiomeProviderFactory() {
        return Objects.requireNonNull(this.serviceLocator.getActiveService(BiomeProviderFactory.class, new Annotation[0]));
    }

    @NotNull
    public BlockSafety getBlockSafety() {
        return Objects.requireNonNull(this.serviceLocator.getActiveService(BlockSafety.class, new Annotation[0]));
    }

    @NotNull
    public CoreConfig getCoreConfig() {
        return Objects.requireNonNull(this.serviceLocator.getActiveService(CoreConfig.class, new Annotation[0]));
    }

    @NotNull
    public DestinationsProvider getDestinationsProvider() {
        return Objects.requireNonNull(this.serviceLocator.getActiveService(DestinationsProvider.class, new Annotation[0]));
    }

    @NotNull
    public GeneratorProvider getGeneratorProvider() {
        return Objects.requireNonNull(this.serviceLocator.getActiveService(GeneratorProvider.class, new Annotation[0]));
    }

    @NotNull
    public LocationManipulation getLocationManipulation() {
        return Objects.requireNonNull(this.serviceLocator.getActiveService(LocationManipulation.class, new Annotation[0]));
    }

    @NotNull
    public MVEconomist getMVEconomist() {
        return Objects.requireNonNull(this.serviceLocator.getActiveService(MVEconomist.class, new Annotation[0]));
    }

    @NotNull
    public AsyncSafetyTeleporter getSafetyTeleporter() {
        return Objects.requireNonNull(this.serviceLocator.getActiveService(AsyncSafetyTeleporter.class, new Annotation[0]));
    }

    @NotNull
    public WorldManager getWorldManager() {
        return Objects.requireNonNull(this.serviceLocator.getActiveService(WorldManager.class, new Annotation[0]));
    }

    @NotNull
    public PluginServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }

    static {
        whenLoadedCallbacks = new ArrayList<Consumer<MultiverseCoreApi>>();
    }
}

