/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.config.node;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import org.mvplugins.multiverse.core.config.node.CommentedNode;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;

public class ConfigHeaderNode
implements CommentedNode {
    @NotNull
    private final String path;
    @NotNull
    private final String[] comments;

    @NotNull
    public static Builder<? extends Builder<?>> builder(String path) {
        return new Builder(path);
    }

    protected ConfigHeaderNode(@NotNull String path, @NotNull String[] comments) {
        this.path = path;
        this.comments = comments;
    }

    @Override
    @NotNull
    public String getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public String[] getComments() {
        return this.comments;
    }

    public String toString() {
        return "Node{path='" + this.path + "'}";
    }

    public static class Builder<B extends Builder<B>> {
        @NotNull
        protected final String path;
        @NotNull
        protected final List<String> comments;

        public Builder(@NotNull String path) {
            this.path = path;
            this.comments = new ArrayList<String>();
        }

        @NotNull
        public B comment(@NotNull String comment) {
            if (!Strings.isNullOrEmpty((String)comment) && !((String)comment).startsWith("#")) {
                comment = "# " + (String)comment;
            }
            this.comments.add((String)comment);
            return this.self();
        }

        @NotNull
        public ConfigHeaderNode build() {
            return new ConfigHeaderNode(this.path, this.comments.toArray(new String[0]));
        }

        @NotNull
        protected B self() {
            return (B)this;
        }
    }
}

