/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.config.node;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.mvplugins.multiverse.core.config.node.ConfigNode;
import org.mvplugins.multiverse.core.config.node.ListValueNode;
import org.mvplugins.multiverse.core.config.node.functions.DefaultStringParserProvider;
import org.mvplugins.multiverse.core.config.node.functions.DefaultSuggesterProvider;
import org.mvplugins.multiverse.core.config.node.functions.NodeStringParser;
import org.mvplugins.multiverse.core.config.node.functions.NodeSuggester;
import org.mvplugins.multiverse.core.config.node.functions.SenderNodeStringParser;
import org.mvplugins.multiverse.core.config.node.functions.SenderNodeSuggester;
import org.mvplugins.multiverse.core.config.node.serializer.DefaultSerializerProvider;
import org.mvplugins.multiverse.core.config.node.serializer.NodeSerializer;
import org.mvplugins.multiverse.core.utils.REPatterns;
import org.mvplugins.multiverse.core.utils.StringFormatter;
import org.mvplugins.multiverse.external.jetbrains.annotations.ApiStatus;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.external.vavr.Value;
import org.mvplugins.multiverse.external.vavr.control.Try;

public class ListConfigNode<I>
extends ConfigNode<List<I>>
implements ListValueNode<I> {
    protected final Class<I> itemType;
    protected final NodeSuggester itemSuggester;
    protected final NodeStringParser<I> itemStringParser;
    protected final NodeSerializer<I> itemSerializer;
    protected final Function<I, Try<Void>> itemValidator;
    protected final BiConsumer<I, I> onSetItemValue;

    @NotNull
    public static <I, B extends Builder<I, B>> Builder<I, B> listBuilder(@NotNull String path, @NotNull Class<I> type) {
        return new Builder(path, type);
    }

    protected ListConfigNode(@NotNull String path, @NotNull String[] comments, @Nullable String name, @NotNull Class<List<I>> type, @NotNull String[] aliases, @Nullable Supplier<List<I>> defaultValueSupplier, @Nullable NodeSuggester suggester, @Nullable NodeStringParser<List<I>> stringParser, @Nullable NodeSerializer<List<I>> serializer, @Nullable Function<List<I>, Try<Void>> validator, @Nullable BiConsumer<List<I>, List<I>> onSetValue, @NotNull Class<I> itemType, @Nullable NodeSuggester itemSuggester, @Nullable NodeStringParser<I> itemStringParser, @Nullable NodeSerializer<I> itemSerializer, @Nullable Function<I, Try<Void>> itemValidator, @Nullable BiConsumer<I, I> onSetItemValue) {
        super(path, comments, name, type, aliases, defaultValueSupplier, suggester, stringParser, serializer, validator, onSetValue);
        this.itemType = itemType;
        this.itemSuggester = itemSuggester != null ? itemSuggester : DefaultSuggesterProvider.getDefaultSuggester(itemType);
        this.itemStringParser = itemStringParser != null ? itemStringParser : DefaultStringParserProvider.getDefaultStringParser(itemType);
        this.itemSerializer = itemSerializer != null ? itemSerializer : DefaultSerializerProvider.getDefaultSerializer(itemType);
        this.itemValidator = itemValidator;
        this.onSetItemValue = onSetItemValue;
        this.setDefaults();
    }

    private void setDefaults() {
        if (this.itemSuggester != null && this.suggester == null) {
            this.setDefaultSuggester();
        }
        if (this.itemStringParser != null && this.stringParser == null) {
            this.setDefaultStringParser();
        }
        if (this.itemValidator != null && this.validator == null) {
            this.setDefaultValidator();
        }
        if (this.itemSerializer != null && this.serializer == null) {
            this.setDefaultSerialiser();
        }
        if (this.onSetItemValue != null && this.onSetValue == null) {
            this.setDefaultOnSetValue();
        }
        if (this.defaultValue == null) {
            this.defaultValue = ArrayList::new;
        }
    }

    private void setDefaultSuggester() {
        NodeSuggester nodeSuggester = this.itemSuggester;
        if (nodeSuggester instanceof SenderNodeSuggester) {
            SenderNodeSuggester senderItemSuggester = (SenderNodeSuggester)nodeSuggester;
            this.suggester = (sender, input) -> StringFormatter.addonToCommaSeperated(input, senderItemSuggester.suggest(sender, input));
        } else {
            this.suggester = input -> StringFormatter.addonToCommaSeperated(input, this.itemSuggester.suggest(input));
        }
    }

    private void setDefaultStringParser() {
        this.stringParser = (input, type) -> {
            if (input == null) {
                return Try.failure(new IllegalArgumentException("Input cannot be null"));
            }
            return Try.sequence(Arrays.stream(REPatterns.COMMA.split(input)).map(inputItem -> this.itemStringParser.parse((String)inputItem, this.itemType)).toList()).map(Value::toJavaList);
        };
    }

    private void setDefaultValidator() {
        this.validator = value -> {
            if (value != null) {
                return Try.sequence(value.stream().map(this.itemValidator).toList()).map(v -> null);
            }
            return Try.success(null);
        };
    }

    private void setDefaultSerialiser() {
        this.serializer = new NodeSerializer<List<I>>(){

            @Override
            public List<I> deserialize(Object object, Class<List<I>> type) {
                if (object instanceof List) {
                    List list = (List)object;
                    return list.stream().map(item -> ListConfigNode.this.itemSerializer != null ? ListConfigNode.this.itemSerializer.deserialize(item, ListConfigNode.this.itemType) : item).collect(Collectors.toList());
                }
                return new ArrayList();
            }

            @Override
            public Object serialize(List<I> object, Class<List<I>> type) {
                if (object == null) {
                    return new ArrayList();
                }
                return object.stream().map(item -> ListConfigNode.this.itemSerializer != null ? ListConfigNode.this.itemSerializer.serialize(item, ListConfigNode.this.itemType) : item).collect(Collectors.toList());
            }
        };
    }

    private void setDefaultOnSetValue() {
        this.onSetValue = (oldValue, newValue) -> {
            if (oldValue != null) {
                oldValue.stream().filter(value -> !newValue.contains(value)).forEach(item -> this.onSetItemValue.accept(item, null));
            }
            newValue.forEach(item -> this.onSetItemValue.accept(null, item));
        };
    }

    @Override
    @NotNull
    public Class<I> getItemType() {
        return this.itemType;
    }

    @Override
    @NotNull
    public Collection<String> suggestItem(@Nullable String input) {
        if (this.itemSuggester != null) {
            return this.itemSuggester.suggest(input);
        }
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public Collection<String> suggestItem(@NotNull CommandSender sender, @Nullable String input) {
        NodeSuggester nodeSuggester;
        if (this.itemSuggester != null && (nodeSuggester = this.itemSuggester) instanceof SenderNodeSuggester) {
            SenderNodeSuggester senderSuggester = (SenderNodeSuggester)nodeSuggester;
            return senderSuggester.suggest(sender, input);
        }
        return this.suggestItem(input);
    }

    @Override
    @NotNull
    public Try<I> parseItemFromString(@Nullable String input) {
        if (this.itemStringParser != null) {
            return this.itemStringParser.parse(input, this.itemType);
        }
        return Try.failure(new UnsupportedOperationException("No item string parser for type " + String.valueOf(this.itemType)));
    }

    @Override
    @NotNull
    public Try<I> parseItemFromString(@NotNull CommandSender sender, @Nullable String input) {
        NodeStringParser<I> nodeStringParser;
        if (this.itemStringParser != null && (nodeStringParser = this.itemStringParser) instanceof SenderNodeStringParser) {
            SenderNodeStringParser senderStringParser = (SenderNodeStringParser)nodeStringParser;
            return senderStringParser.parse(sender, input, this.itemType);
        }
        return this.parseItemFromString(input);
    }

    @Override
    @Nullable
    public NodeSerializer<I> getItemSerializer() {
        return this.itemSerializer;
    }

    @Override
    public Try<Void> validateItem(@Nullable I value) {
        if (this.itemValidator != null) {
            return this.itemValidator.apply(value);
        }
        return Try.success(null);
    }

    @Override
    public void onSetItemValue(@Nullable I oldValue, @Nullable I newValue) {
        if (this.onSetItemValue != null) {
            this.onSetItemValue.accept(oldValue, newValue);
        }
    }

    public static class Builder<I, B extends Builder<I, B>>
    extends ConfigNode.Builder<List<I>, B> {
        @NotNull
        protected final Class<I> itemType;
        @Nullable
        protected NodeSuggester itemSuggester;
        @Nullable
        protected NodeStringParser<I> itemStringParser;
        @Nullable
        protected NodeSerializer<I> itemSerializer;
        @Nullable
        protected Function<I, Try<Void>> itemValidator;
        @Nullable
        protected BiConsumer<I, I> onSetItemValue;

        protected Builder(@NotNull String path, @NotNull Class<I> itemType) {
            super(path, List.class);
            this.itemType = itemType;
            this.defaultValue = () -> new ArrayList();
        }

        @NotNull
        public B itemSuggester(@NotNull NodeSuggester itemSuggester) {
            this.itemSuggester = itemSuggester;
            return (B)((Builder)this.self());
        }

        @ApiStatus.AvailableSince(value="5.1")
        @NotNull
        public B itemSuggester(@NotNull SenderNodeSuggester itemSuggester) {
            this.itemSuggester = itemSuggester;
            return (B)((Builder)this.self());
        }

        @NotNull
        public B itemStringParser(@NotNull NodeStringParser<I> itemStringParser) {
            this.itemStringParser = itemStringParser;
            return (B)((Builder)this.self());
        }

        @ApiStatus.AvailableSince(value="5.1")
        @NotNull
        public B itemStringParser(@NotNull SenderNodeStringParser<I> itemStringParser) {
            this.itemStringParser = itemStringParser;
            return (B)((Builder)this.self());
        }

        @NotNull
        public B itemSerializer(@NotNull NodeSerializer<I> serializer) {
            this.itemSerializer = serializer;
            return (B)((Builder)this.self());
        }

        @NotNull
        public B itemValidator(@NotNull Function<I, Try<Void>> itemValidator) {
            this.itemValidator = itemValidator;
            return (B)((Builder)this.self());
        }

        @NotNull
        public B onSetItemValue(@Nullable BiConsumer<I, I> onSetItemValue) {
            this.onSetItemValue = onSetItemValue;
            return (B)((Builder)this.self());
        }

        @Override
        @NotNull
        public ListConfigNode<I> build() {
            return new ListConfigNode<I>(this.path, this.comments.toArray(new String[0]), this.name, this.type, this.aliases, this.defaultValue, this.suggester, this.stringParser, this.serializer, this.validator, this.onSetValue, this.itemType, this.itemSuggester, this.itemStringParser, this.itemSerializer, this.itemValidator, this.onSetItemValue);
        }
    }
}

