/*
 * Decompiled with CFR 0.152.
 */
package com.poggers.config.holoutils;

import com.poggers.utils.NotifyPlayer;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;

@Config(name="holo-utils")
public class ModConfig
implements ConfigData {
    @ConfigEntry.Category(value="visualSettings")
    @ConfigEntry.Gui.TransitiveObject
    public VisualSettings visualSettings = new VisualSettings();

    public void cycleFogOptions() {
        switch (this.visualSettings.getAllFogState().ordinal()) {
            case 0: {
                NotifyPlayer.displayMessage("Disabling Fog Everywhere", true);
                this.visualSettings.setAllFogState(FogRemoval.EVERYWHERE);
                break;
            }
            case 1: {
                NotifyPlayer.displayMessage("Disabling Fog in Nether Only", true);
                this.visualSettings.setAllFogState(FogRemoval.NETHER_ONLY);
                break;
            }
            case 2: {
                NotifyPlayer.displayMessage("Enabling Fog", true);
                this.visualSettings.setAllFogState(FogRemoval.DISABLED);
            }
        }
        AutoConfig.getConfigHolder(ModConfig.class).save();
    }

    public static class VisualSettings {
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.DROPDOWN)
        private FogRemoval removeFogEverywhere = FogRemoval.DISABLED;
        private boolean fullbrightEnabled = false;

        public FogRemoval getAllFogState() {
            return this.removeFogEverywhere;
        }

        public void setAllFogState(FogRemoval state) {
            this.removeFogEverywhere = state;
        }

        public boolean getFullbrightState() {
            return this.fullbrightEnabled;
        }

        public void setFullbrightState(boolean state) {
            this.fullbrightEnabled = state;
            AutoConfig.getConfigHolder(ModConfig.class).save();
        }
    }

    public static enum FogRemoval {
        DISABLED,
        EVERYWHERE,
        NETHER_ONLY;

    }
}

