/*
 * Decompiled with CFR 0.152.
 */
package ench.autodropx.forge.feature.drop;

import ench.autodropx.forge.AutoDropXForge;
import ench.autodropx.forge.feature.drop.DropManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u0011\u0012\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u00042\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0002J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0002J \u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n\u00a8\u0006\u0014"}, d2={"Lench/autodropx/forge/feature/drop/DropAlgorithm;", "", "()V", "generateNextStates", "", "Lkotlin/Pair;", "Lench/autodropx/forge/feature/drop/DropAlgorithm$State;", "Lench/autodropx/forge/feature/drop/DropAlgorithm$Operation;", "state", "total", "", "drop", "minKeep", "isValidState", "", "solve", "Lench/autodropx/forge/feature/drop/DropAlgorithm$Solution;", "Operation", "Solution", "State", "autodropx"})
public final class DropAlgorithm {
    @NotNull
    public static final DropAlgorithm INSTANCE = new DropAlgorithm();

    private DropAlgorithm() {
    }

    @Nullable
    public final Solution solve(int total, int drop, int minKeep) {
        if (drop >= total || drop <= 0) {
            return null;
        }
        List queue = new ArrayList();
        Set visited = new LinkedHashSet();
        State initialState = new State(total, 0, 0);
        queue.add(new Pair((Object)initialState, (Object)CollectionsKt.emptyList()));
        visited.add(initialState);
        while (!((Collection)queue).isEmpty()) {
            Pair pair = (Pair)CollectionsKt.removeFirst((List)queue);
            State currentState = (State)pair.component1();
            List operations = (List)pair.component2();
            if (currentState.getDropped() == drop && currentState.getHandItems() == 0 && currentState.getSlotItems() == total - drop) {
                return new Solution(operations, operations.size());
            }
            List<Pair<State, Operation>> nextStates = this.generateNextStates(currentState, total, drop, minKeep);
            for (Pair<State, Operation> pair2 : nextStates) {
                State nextState = (State)pair2.component1();
                Operation operation = (Operation)pair2.component2();
                if (visited.contains(nextState) || !this.isValidState(nextState, total, drop, minKeep)) continue;
                visited.add(nextState);
                queue.add(new Pair((Object)nextState, (Object)CollectionsKt.plus((Collection)operations, (Object)operation)));
            }
        }
        return null;
    }

    private final List<Pair<State, Operation>> generateNextStates(State state, int total, int drop, int minKeep) {
        List nextStates = new ArrayList();
        if (state.getHandItems() == 0 && state.getSlotItems() > minKeep) {
            int takeItems = (state.getSlotItems() - minKeep + 1) / 2;
            State newState = new State(state.getSlotItems() - takeItems, takeItems, state.getDropped());
            nextStates.add(new Pair((Object)newState, (Object)new Operation(DropManager.Action.TAKE_HALF, "\u7a7a\u624b\u53f3\u952eSLOT", "\u4eceSLOT\u53d6\u51fa" + takeItems + "\u4e2a\u7269\u54c1\u5230\u624b\u4e0a")));
        }
        if (state.getHandItems() > 0) {
            State newState = new State(state.getSlotItems() + 1, state.getHandItems() - 1, state.getDropped());
            nextStates.add(new Pair((Object)newState, (Object)new Operation(DropManager.Action.PLACE_INTO_SLOT, "\u624b\u6301\u53f3\u952eSLOT", "\u5c06\u624b\u4e0a\u4e00\u4e2a\u7269\u54c1\u653e\u5165SLOT")));
        }
        if (state.getHandItems() > 0) {
            State newState = new State(state.getSlotItems(), 0, state.getDropped() + state.getHandItems());
            nextStates.add(new Pair((Object)newState, (Object)new Operation(DropManager.Action.DROP_HAND, "\u624b\u6301\u5de6\u952e\u5916\u9762", "\u6254\u51fa\u624b\u4e0a\u6240\u6709" + state.getHandItems() + "\u4e2a\u7269\u54c1")));
        }
        if (state.getHandItems() == 0 && state.getSlotItems() > minKeep) {
            State newState = new State(state.getSlotItems() - 1, 0, state.getDropped() + 1);
            nextStates.add(new Pair((Object)newState, (Object)new Operation(DropManager.Action.DROP_SLOT, "\u7a7a\u624b\u6309Q", "\u4eceSLOT\u6254\u51fa1\u4e2a\u7269\u54c1")));
        }
        return nextStates;
    }

    private final boolean isValidState(State state, int total, int drop, int minKeep) {
        return state.getSlotItems() >= minKeep && state.getHandItems() >= 0 && state.getDropped() <= drop;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lench/autodropx/forge/feature/drop/DropAlgorithm$Operation;", "", "action", "Lench/autodropx/forge/feature/drop/DropManager$Action;", "name", "", "description", "(Lench/autodropx/forge/feature/drop/DropManager$Action;Ljava/lang/String;Ljava/lang/String;)V", "getAction", "()Lench/autodropx/forge/feature/drop/DropManager$Action;", "getDescription", "()Ljava/lang/String;", "getName", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "autodropx"})
    public static final class Operation {
        @NotNull
        private final DropManager.Action action;
        @NotNull
        private final String name;
        @NotNull
        private final String description;

        public Operation(@NotNull DropManager.Action action, @NotNull String name, @NotNull String description) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            this.action = action;
            this.name = name;
            this.description = description;
        }

        @NotNull
        public final DropManager.Action getAction() {
            return this.action;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        @NotNull
        public final DropManager.Action component1() {
            return this.action;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final String component3() {
            return this.description;
        }

        @NotNull
        public final Operation copy(@NotNull DropManager.Action action, @NotNull String name, @NotNull String description) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            return new Operation(action, name, description);
        }

        public static /* synthetic */ Operation copy$default(Operation operation, DropManager.Action action, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                action = operation.action;
            }
            if ((n & 2) != 0) {
                string = operation.name;
            }
            if ((n & 4) != 0) {
                string2 = operation.description;
            }
            return operation.copy(action, string, string2);
        }

        @NotNull
        public String toString() {
            return "Operation(action=" + this.action + ", name=" + this.name + ", description=" + this.description + ")";
        }

        public int hashCode() {
            int result = this.action.hashCode();
            result = result * 31 + this.name.hashCode();
            result = result * 31 + this.description.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Operation)) {
                return false;
            }
            Operation operation = (Operation)other;
            if (this.action != operation.action) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)operation.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.description, (Object)operation.description);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00d6\u0001J\u0006\u0010\u0013\u001a\u00020\u0014J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lench/autodropx/forge/feature/drop/DropAlgorithm$Solution;", "", "operations", "", "Lench/autodropx/forge/feature/drop/DropAlgorithm$Operation;", "steps", "", "(Ljava/util/List;I)V", "getOperations", "()Ljava/util/List;", "getSteps", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "printSolution", "", "toString", "", "autodropx"})
    @SourceDebugExtension(value={"SMAP\nDropAlgorithm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DropAlgorithm.kt\nench/autodropx/forge/feature/drop/DropAlgorithm$Solution\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,163:1\n1872#2,3:164\n*S KotlinDebug\n*F\n+ 1 DropAlgorithm.kt\nench/autodropx/forge/feature/drop/DropAlgorithm$Solution\n*L\n27#1:164,3\n*E\n"})
    public static final class Solution {
        @NotNull
        private final List<Operation> operations;
        private final int steps;

        public Solution(@NotNull List<Operation> operations, int steps) {
            Intrinsics.checkNotNullParameter(operations, (String)"operations");
            this.operations = operations;
            this.steps = steps;
        }

        @NotNull
        public final List<Operation> getOperations() {
            return this.operations;
        }

        public final int getSteps() {
            return this.steps;
        }

        /*
         * WARNING - void declaration
         */
        public final void printSolution() {
            AutoDropXForge.INSTANCE.getLogger().debug("\u6700\u5c0f\u64cd\u4f5c\u6b21\u6570: {}", (Object)this.steps);
            AutoDropXForge.INSTANCE.getLogger().debug("\u64cd\u4f5c\u5e8f\u5217:");
            Iterable $this$forEachIndexed$iv = this.operations;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void op;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Operation operation = (Operation)item$iv;
                int index = n;
                boolean bl = false;
                Object[] objectArray = new Object[]{index + 1, op.getName(), op.getDescription()};
                AutoDropXForge.INSTANCE.getLogger().debug("{}. {}: {}", objectArray);
            }
        }

        @NotNull
        public final List<Operation> component1() {
            return this.operations;
        }

        public final int component2() {
            return this.steps;
        }

        @NotNull
        public final Solution copy(@NotNull List<Operation> operations, int steps) {
            Intrinsics.checkNotNullParameter(operations, (String)"operations");
            return new Solution(operations, steps);
        }

        public static /* synthetic */ Solution copy$default(Solution solution, List list, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                list = solution.operations;
            }
            if ((n2 & 2) != 0) {
                n = solution.steps;
            }
            return solution.copy(list, n);
        }

        @NotNull
        public String toString() {
            return "Solution(operations=" + this.operations + ", steps=" + this.steps + ")";
        }

        public int hashCode() {
            int result = ((Object)this.operations).hashCode();
            result = result * 31 + Integer.hashCode(this.steps);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Solution)) {
                return false;
            }
            Solution solution = (Solution)other;
            if (!Intrinsics.areEqual(this.operations, solution.operations)) {
                return false;
            }
            return this.steps == solution.steps;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lench/autodropx/forge/feature/drop/DropAlgorithm$State;", "", "slotItems", "", "handItems", "dropped", "(III)V", "getDropped", "()I", "getHandItems", "getSlotItems", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "autodropx"})
    public static final class State {
        private final int slotItems;
        private final int handItems;
        private final int dropped;

        public State(int slotItems, int handItems, int dropped) {
            this.slotItems = slotItems;
            this.handItems = handItems;
            this.dropped = dropped;
        }

        public final int getSlotItems() {
            return this.slotItems;
        }

        public final int getHandItems() {
            return this.handItems;
        }

        public final int getDropped() {
            return this.dropped;
        }

        @NotNull
        public String toString() {
            return "SLOT: " + this.slotItems + ", HAND: " + this.handItems + ", DROPPED: " + this.dropped;
        }

        public final int component1() {
            return this.slotItems;
        }

        public final int component2() {
            return this.handItems;
        }

        public final int component3() {
            return this.dropped;
        }

        @NotNull
        public final State copy(int slotItems, int handItems, int dropped) {
            return new State(slotItems, handItems, dropped);
        }

        public static /* synthetic */ State copy$default(State state, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = state.slotItems;
            }
            if ((n4 & 2) != 0) {
                n2 = state.handItems;
            }
            if ((n4 & 4) != 0) {
                n3 = state.dropped;
            }
            return state.copy(n, n2, n3);
        }

        public int hashCode() {
            int result = Integer.hashCode(this.slotItems);
            result = result * 31 + Integer.hashCode(this.handItems);
            result = result * 31 + Integer.hashCode(this.dropped);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof State)) {
                return false;
            }
            State state = (State)other;
            if (this.slotItems != state.slotItems) {
                return false;
            }
            if (this.handItems != state.handItems) {
                return false;
            }
            return this.dropped == state.dropped;
        }
    }
}

