/*
 * Decompiled with CFR 0.152.
 */
package ench.autodropx.forge.feature.config;

import ench.autodropx.forge.AutoDropXForge;
import ench.autodropx.forge.feature.config.ConfigContainerMenu;
import ench.autodropx.forge.feature.config.ConfigManager;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.loading.FMLPaths;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0015\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0015H\u0002J\b\u0010\u0017\u001a\u00020\u0015H\u0002J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\u001c\u001a\u00020\u0019H\u0002J\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\u001eJ\u0006\u0010\u001f\u001a\u00020\u0004J\u0006\u0010 \u001a\u00020\u0004J\u0006\u0010!\u001a\u00020\u0019J\u0010\u0010\"\u001a\u0004\u0018\u00010\n2\u0006\u0010#\u001a\u00020$J\b\u0010%\u001a\u00020\u0015H\u0002J\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\n0\u001eJ\b\u0010'\u001a\u00020\u0019H\u0002J\u0018\u0010(\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\n2\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u0010*\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\n2\u0006\u0010#\u001a\u00020$H\u0002J\b\u0010+\u001a\u00020\u0015H\u0002J\u000f\u0010,\u001a\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0002\u0010-J\u0014\u0010.\u001a\u00020\u00192\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\n0\u001eJ\u0006\u00100\u001a\u00020\u0019J\u0006\u00101\u001a\u00020\u001bJ\u0016\u00102\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020$2\u0006\u00103\u001a\u00020\u0004J\u0006\u00104\u001a\u00020\u000eJ\u000e\u00105\u001a\u00020\u000e2\u0006\u00106\u001a\u00020\u0004J\u0006\u00107\u001a\u00020\u000eJ\b\u00108\u001a\u00020\u0019H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lench/autodropx/forge/feature/config/ConfigManager;", "", "()V", "TOTAL_PAGES", "", "activeProfileFileName", "", "baseDirName", "configuredItems", "", "Lench/autodropx/forge/feature/config/ConfigContainerMenu$ConfigItem;", "currentPage", "legacyConfigFileName", "modEnabled", "", "getModEnabled", "()Z", "setModEnabled", "(Z)V", "profilesDirName", "activeProfilePath", "Ljava/nio/file/Path;", "baseDir", "configPath", "deserializeFromNBT", "", "nbt", "Lnet/minecraft/nbt/CompoundTag;", "ensureDirs", "getConfiguredItems", "", "getCurrentPage", "getTotalPages", "initialize", "isItemConfigured", "item", "Lnet/minecraft/world/item/ItemStack;", "legacyConfigPath", "loadConfig", "loadCurrentPageFromDisk", "matchesItem", "configItem", "matchesItemByTag", "profilesDir", "readActivePageIfAny", "()Ljava/lang/Integer;", "saveConfig", "items", "saveToFile", "serializeToNBT", "shouldKeepItem", "currentCount", "switchToNextProfile", "switchToPage", "page", "switchToPrevProfile", "writeActivePage", "autodropx"})
@SourceDebugExtension(value={"SMAP\nConfigManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigManager.kt\nench/autodropx/forge/feature/config/ConfigManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,240:1\n1#2:241\n774#3:242\n865#3,2:243\n1557#3:245\n1628#3,3:246\n774#3:249\n865#3,2:250\n1872#3,3:252\n*S KotlinDebug\n*F\n+ 1 ConfigManager.kt\nench/autodropx/forge/feature/config/ConfigManager\n*L\n89#1:242\n89#1:243,2\n89#1:245\n89#1:246,3\n103#1:249\n103#1:250,2\n127#1:252,3\n*E\n"})
public final class ConfigManager {
    @NotNull
    public static final ConfigManager INSTANCE = new ConfigManager();
    private static boolean modEnabled;
    @NotNull
    private static List<ConfigContainerMenu.ConfigItem> configuredItems;
    @NotNull
    private static final String legacyConfigFileName = "autodropx.snbt";
    @NotNull
    private static final String baseDirName = "autodropx";
    @NotNull
    private static final String profilesDirName = "profiles";
    @NotNull
    private static final String activeProfileFileName = "active_profile.txt";
    private static final int TOTAL_PAGES = 9;
    private static int currentPage;

    private ConfigManager() {
    }

    public final boolean getModEnabled() {
        return modEnabled;
    }

    public final void setModEnabled(boolean bl) {
        modEnabled = bl;
    }

    private final Path baseDir() {
        Path path = FMLPaths.CONFIGDIR.get().resolve(baseDirName);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"CONFIGDIR.get().resolve(baseDirName)");
        return path;
    }

    private final Path profilesDir() {
        Path path = this.baseDir().resolve(profilesDirName);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"baseDir().resolve(profilesDirName)");
        return path;
    }

    private final Path activeProfilePath() {
        Path path = this.baseDir().resolve(activeProfileFileName);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"baseDir().resolve(activeProfileFileName)");
        return path;
    }

    private final Path legacyConfigPath() {
        Path path = FMLPaths.CONFIGDIR.get().resolve(legacyConfigFileName);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"CONFIGDIR.get().resolve(legacyConfigFileName)");
        return path;
    }

    private final Path configPath() {
        Path path = this.profilesDir().resolve("page" + currentPage + ".snbt");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"profilesDir().resolve(\"page$currentPage.snbt\")");
        return path;
    }

    private final void ensureDirs() {
        Path pdir;
        Path dir = this.baseDir();
        if (!Files.exists(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!Files.exists(pdir = this.profilesDir(), new LinkOption[0])) {
            try {
                Files.createDirectories(pdir, new FileAttribute[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public final int getCurrentPage() {
        return currentPage;
    }

    public final int getTotalPages() {
        return 9;
    }

    private final Integer readActivePageIfAny() {
        Integer n;
        try {
            Integer n2;
            Path path = this.activeProfilePath();
            if (Files.exists(path, new LinkOption[0])) {
                String string = Files.readString(path, StandardCharsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(path, StandardCharsets.UTF_8)");
                Integer n3 = StringsKt.toIntOrNull((String)((Object)StringsKt.trim((CharSequence)string)).toString());
                if (n3 != null) {
                    Integer n4 = n3;
                    int it = ((Number)n4).intValue();
                    boolean bl = false;
                    n2 = (1 <= it ? it < 10 : false) ? n4 : null;
                } else {
                    n2 = null;
                }
            } else {
                n2 = null;
            }
            n = n2;
        }
        catch (Exception exception) {
            n = null;
        }
        return n;
    }

    private final void writeActivePage() {
        this.ensureDirs();
        try {
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE};
            Files.writeString(this.activeProfilePath(), (CharSequence)String.valueOf(currentPage), StandardCharsets.UTF_8, openOptionArray);
        }
        catch (Exception e) {
            AutoDropXForge.INSTANCE.getLogger().info("Failed to write active page: " + e.getMessage());
        }
    }

    public final boolean switchToPage(int page) {
        int newPage = RangesKt.coerceIn((int)page, (int)1, (int)9);
        if (newPage == currentPage) {
            return true;
        }
        currentPage = newPage;
        this.writeActivePage();
        this.loadCurrentPageFromDisk();
        return true;
    }

    public final boolean switchToNextProfile() {
        return this.switchToPage(currentPage % 9 + 1);
    }

    public final boolean switchToPrevProfile() {
        return this.switchToPage((currentPage - 2 + 9) % 9 + 1);
    }

    /*
     * WARNING - void declaration
     */
    public final void saveConfig(@NotNull List<ConfigContainerMenu.ConfigItem> items) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ConfigContainerMenu.ConfigItem it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter(items, (String)"items");
        configuredItems.clear();
        Iterable iterable = items;
        List<ConfigContainerMenu.ConfigItem> list = configuredItems;
        boolean $i$f$filter = false;
        void var4_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ConfigContainerMenu.ConfigItem)element$iv$iv;
            boolean bl = false;
            if (!(!it.getItem().m_41619_())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ConfigContainerMenu.ConfigItem)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ConfigContainerMenu.ConfigItem(it));
        }
        list.addAll((List)destination$iv$iv);
        try {
            this.saveToFile();
            AutoDropXForge.INSTANCE.getLogger().info("Config saved for page #" + currentPage + " with " + configuredItems.size() + " items.");
        }
        catch (Exception e) {
            AutoDropXForge.INSTANCE.getLogger().info("Failed to save config to file: " + e.getMessage());
        }
    }

    @NotNull
    public final List<ConfigContainerMenu.ConfigItem> loadConfig() {
        return CollectionsKt.toList((Iterable)configuredItems);
    }

    @NotNull
    public final List<ConfigContainerMenu.ConfigItem> getConfiguredItems() {
        return CollectionsKt.toList((Iterable)configuredItems);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ConfigContainerMenu.ConfigItem isItemConfigured(@NotNull ItemStack item) {
        Object v0;
        block2: {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Iterable $this$filter$iv = configuredItems;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ConfigContainerMenu.ConfigItem it = (ConfigContainerMenu.ConfigItem)element$iv$iv;
                boolean bl = false;
                if (!it.getEnabled()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable iterable2 = (List)destination$iv$iv;
            for (Object e : iterable2) {
                ConfigContainerMenu.ConfigItem configItem = (ConfigContainerMenu.ConfigItem)e;
                boolean bl = false;
                if (!INSTANCE.matchesItem(configItem, item)) continue;
                v0 = e;
                break block2;
            }
            v0 = null;
        }
        return v0;
    }

    public final boolean shouldKeepItem(@NotNull ItemStack item, int currentCount) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        ConfigContainerMenu.ConfigItem configItem = this.isItemConfigured(item);
        if (configItem == null) {
            return false;
        }
        ConfigContainerMenu.ConfigItem configItem2 = configItem;
        return currentCount <= configItem2.getLeastAmount();
    }

    private final boolean matchesItem(ConfigContainerMenu.ConfigItem configItem, ItemStack item) {
        return switch (WhenMappings.$EnumSwitchMapping$0[configItem.getMatchMode().ordinal()]) {
            case 1 -> Intrinsics.areEqual((Object)configItem.getItem().m_41720_(), (Object)item.m_41720_());
            case 2 -> ItemStack.m_150942_((ItemStack)configItem.getItem(), (ItemStack)item);
            case 3 -> this.matchesItemByTag(configItem, item);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final boolean matchesItemByTag(ConfigContainerMenu.ConfigItem configItem, ItemStack item) {
        String string = configItem.getCurrentTag();
        if (string == null) {
            return false;
        }
        String targetTag = string;
        List<String> itemTags2 = item.m_41720_().m_204114_().m_203616_().map(arg_0 -> ConfigManager.matchesItemByTag$lambda$5(matchesItemByTag.itemTags.1.INSTANCE, arg_0)).toList();
        return itemTags2.contains(targetTag);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CompoundTag serializeToNBT() {
        CompoundTag nbt = new CompoundTag();
        CompoundTag itemsNBT = new CompoundTag();
        Iterable $this$forEachIndexed$iv = configuredItems;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void configItem;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ConfigContainerMenu.ConfigItem configItem2 = (ConfigContainerMenu.ConfigItem)item$iv;
            int index = n;
            boolean bl = false;
            CompoundTag itemNBT = new CompoundTag();
            itemNBT.m_128365_("item", (Tag)configItem.getItem().m_41739_(new CompoundTag()));
            itemNBT.m_128359_("matchMode", configItem.getMatchMode().name());
            itemNBT.m_128405_("leastAmount", configItem.getLeastAmount());
            itemNBT.m_128379_("enabled", configItem.getEnabled());
            if (configItem.getSelectedTag() != null) {
                String tag;
                boolean bl2 = false;
                itemNBT.m_128359_("selectedTag", tag);
            }
            itemsNBT.m_128365_(String.valueOf(index), (Tag)itemNBT);
        }
        nbt.m_128365_("items", (Tag)itemsNBT);
        nbt.m_128405_("count", configuredItems.size());
        nbt.m_128379_("modEnabled", modEnabled);
        return nbt;
    }

    public final void deserializeFromNBT(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        configuredItems.clear();
        boolean bl = modEnabled = nbt.m_128441_("modEnabled") ? nbt.m_128471_("modEnabled") : false;
        if (!nbt.m_128441_("items")) {
            return;
        }
        CompoundTag itemsNBT = nbt.m_128469_("items");
        int count = nbt.m_128451_("count");
        for (int i = 0; i < count; ++i) {
            CompoundTag itemNBT = itemsNBT.m_128469_(String.valueOf(i));
            if (itemNBT.m_128456_()) continue;
            try {
                ConfigContainerMenu.ConfigItem.MatchMode matchMode;
                ItemStack itemStack = ItemStack.m_41712_((CompoundTag)itemNBT.m_128469_("item"));
                try {
                    String string = itemNBT.m_128461_("matchMode");
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"itemNBT.getString(\"matchMode\")");
                    matchMode = ConfigContainerMenu.ConfigItem.MatchMode.valueOf(string);
                }
                catch (Exception e) {
                    matchMode = ConfigContainerMenu.ConfigItem.MatchMode.ID;
                }
                ConfigContainerMenu.ConfigItem.MatchMode matchMode2 = matchMode;
                int leastAmount = itemNBT.m_128451_("leastAmount");
                String selectedTag = itemNBT.m_128441_("selectedTag") ? itemNBT.m_128461_("selectedTag") : null;
                boolean enabled = itemNBT.m_128441_("enabled") ? itemNBT.m_128471_("enabled") : true;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"itemStack");
                ConfigContainerMenu.ConfigItem configItem = new ConfigContainerMenu.ConfigItem(itemStack, matchMode2, leastAmount, selectedTag, enabled);
                configuredItems.add(configItem);
                continue;
            }
            catch (Exception e) {
                AutoDropXForge.INSTANCE.getLogger().info("Failed to load config item at index " + i + ": " + e.getMessage());
            }
        }
        AutoDropXForge.INSTANCE.getLogger().info("Loaded " + configuredItems.size() + " config items from NBT.");
    }

    public final void saveToFile() throws Exception {
        this.ensureDirs();
        String string = this.serializeToNBT().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"serializeToNBT().toString()");
        String snbt = string;
        Path path = this.configPath();
        Path tmp = path.resolveSibling(path.getFileName() + ".tmp");
        Object[] objectArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE};
        Files.writeString(tmp, (CharSequence)snbt, StandardCharsets.UTF_8, (OpenOption[])objectArray);
        objectArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE};
        Files.move(tmp, path, (CopyOption[])objectArray);
    }

    private final void loadCurrentPageFromDisk() {
        try {
            this.ensureDirs();
            Path path = this.configPath();
            if (!Files.exists(path, new LinkOption[0])) {
                Path legacy = this.legacyConfigPath();
                if (currentPage == 1 && Files.exists(legacy, new LinkOption[0])) {
                    try {
                        String snbtLegacy = Files.readString(legacy, StandardCharsets.UTF_8);
                        CompoundTag tagLegacy = TagParser.m_129359_((String)snbtLegacy);
                        if (tagLegacy != null) {
                            this.deserializeFromNBT(tagLegacy);
                            this.saveToFile();
                            AutoDropXForge.INSTANCE.getLogger().info("Migrated legacy config to page #" + currentPage + ".");
                            return;
                        }
                    }
                    catch (Exception snbtLegacy) {
                        // empty catch block
                    }
                }
            }
            if (!Files.exists(path, new LinkOption[0])) {
                AutoDropXForge.INSTANCE.getLogger().info("Config file not found for page #" + currentPage + ", using defaults.");
                configuredItems.clear();
                modEnabled = false;
                return;
            }
            String snbt = Files.readString(path, StandardCharsets.UTF_8);
            CompoundTag tag = TagParser.m_129359_((String)snbt);
            if (tag != null) {
                this.deserializeFromNBT(tag);
                AutoDropXForge.INSTANCE.getLogger().info("Config loaded from file: autodropx/profiles/" + path.getFileName());
            } else {
                AutoDropXForge.INSTANCE.getLogger().info("Config file root is not a CompoundTag, ignoring.");
            }
        }
        catch (Exception e) {
            AutoDropXForge.INSTANCE.getLogger().info("Failed to load config from file: " + e.getMessage());
        }
    }

    public final void initialize() {
        try {
            Integer n;
            this.ensureDirs();
            Integer n2 = n = this.readActivePageIfAny();
            if (n2 != null) {
                int it = ((Number)n2).intValue();
                boolean bl = false;
                currentPage = it;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.loadCurrentPageFromDisk();
    }

    private static final String matchesItemByTag$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    static {
        configuredItems = new ArrayList();
        currentPage = 1;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConfigContainerMenu.ConfigItem.MatchMode.values().length];
            try {
                nArray[ConfigContainerMenu.ConfigItem.MatchMode.ID.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigContainerMenu.ConfigItem.MatchMode.ID_NBT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigContainerMenu.ConfigItem.MatchMode.ITEM_TAG.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

