/*
 * Decompiled with CFR 0.152.
 */
package ench.autodropx.forge.feature.drop;

import ench.autodropx.forge.AutoDropXForge;
import ench.autodropx.forge.Config;
import ench.autodropx.forge.feature.config.ConfigContainerMenu;
import ench.autodropx.forge.feature.config.ConfigContainerScreen;
import ench.autodropx.forge.feature.config.ConfigManager;
import ench.autodropx.forge.feature.drop.DiffScanner;
import ench.autodropx.forge.feature.drop.DropAlgorithm;
import ench.autodropx.forge.feature.drop.DropManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003,-.B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fH\u0002J\u001e\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u0018H\u0002J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J&\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u0018H\u0002J\b\u0010!\u001a\u00020\u001fH\u0002J \u0010\"\u001a\u00020\u001f2\u0018\u0010#\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00130$0\u0018J\u0006\u0010%\u001a\u00020\u001fJ\u0006\u0010&\u001a\u00020\u001fJ\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020\t0\u00182\u0006\u0010(\u001a\u00020\u0005J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\t0\u00182\u0006\u0010(\u001a\u00020\u0005H\u0002J\u0006\u0010*\u001a\u00020\u001fJ\u0006\u0010+\u001a\u00020\u001fR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006/"}, d2={"Lench/autodropx/forge/feature/drop/DropManager;", "", "()V", "itemStackToDrop", "Lkotlin/collections/ArrayDeque;", "Lench/autodropx/forge/feature/drop/DropManager$ItemStackToDrop;", "getItemStackToDrop", "()Lkotlin/collections/ArrayDeque;", "stepsToDo", "Lench/autodropx/forge/feature/drop/DropManager$Step;", "getStepsToDo", "ticksToDrop", "", "getTicksToDrop", "()I", "setTicksToDrop", "(I)V", "calculateDropCount", "newStack", "Lnet/minecraft/world/item/ItemStack;", "slotIndex", "getTotalItemCount", "targetStack", "inventoryItems", "", "isSameConfiguredItem", "", "compareStack", "configItem", "Lench/autodropx/forge/feature/config/ConfigContainerMenu$ConfigItem;", "markExcessItemsForDrop", "", "excessCount", "periodicInventoryCheck", "processNewItems", "items", "Lkotlin/Pair;", "restoreState", "scan", "scanAndGetSteps", "target", "simpleScanAndGetSteps", "step", "tick", "Action", "ItemStackToDrop", "Step", "autodropx"})
@SourceDebugExtension(value={"SMAP\nDropManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DropManager.kt\nench/autodropx/forge/feature/drop/DropManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,427:1\n1863#2:428\n1864#2:436\n1019#2,2:437\n1863#2,2:440\n1863#2:442\n1863#2,2:443\n1864#2:445\n1863#2:446\n295#2,2:447\n1864#2:449\n1863#2,2:450\n381#3,7:429\n1#4:439\n*S KotlinDebug\n*F\n+ 1 DropManager.kt\nench/autodropx/forge/feature/drop/DropManager\n*L\n55#1:428\n55#1:436\n65#1:437,2\n207#1:440,2\n300#1:442\n303#1:443,2\n300#1:445\n320#1:446\n326#1:447,2\n320#1:449\n419#1:450,2\n57#1:429,7\n*E\n"})
public final class DropManager {
    @NotNull
    public static final DropManager INSTANCE = new DropManager();
    @NotNull
    private static final ArrayDeque<ItemStackToDrop> itemStackToDrop = new ArrayDeque();
    @NotNull
    private static final ArrayDeque<Step> stepsToDo = new ArrayDeque();
    private static int ticksToDrop;

    private DropManager() {
    }

    @NotNull
    public final ArrayDeque<ItemStackToDrop> getItemStackToDrop() {
        return itemStackToDrop;
    }

    @NotNull
    public final ArrayDeque<Step> getStepsToDo() {
        return stepsToDo;
    }

    public final int getTicksToDrop() {
        return ticksToDrop;
    }

    public final void setTicksToDrop(int n) {
        ticksToDrop = n;
    }

    public final void processNewItems(@NotNull List<Pair<Integer, ItemStack>> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        LocalPlayer localPlayer = AutoDropXForge.INSTANCE.getMC().f_91074_;
        if (localPlayer == null) {
            return;
        }
        LocalPlayer player = localPlayer;
        Inventory inventory = player.m_150109_();
        if (items.isEmpty()) {
            return;
        }
        Map grouped = new LinkedHashMap();
        Iterable $this$forEach$iv = items;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            ConfigContainerMenu.ConfigItem cfg;
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            int inventoryIndex = ((Number)pair.component1()).intValue();
            ItemStack diffStack = (ItemStack)pair.component2();
            if (Config.INSTANCE.getItemConfig(diffStack) == null) continue;
            Map $this$getOrPut$iv = grouped;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(cfg);
            if (value$iv == null) {
                boolean bl2 = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(cfg, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((List)object).add(TuplesKt.to((Object)inventoryIndex, (Object)diffStack));
        }
        block1: for (Map.Entry entry : grouped.entrySet()) {
            int mustKeep;
            ConfigContainerMenu.ConfigItem cfg = (ConfigContainerMenu.ConfigItem)entry.getKey();
            List diffs = (List)entry.getValue();
            if (diffs.isEmpty()) continue;
            List $this$sortByDescending$iv = diffs;
            boolean $i$f$sortByDescending = false;
            if ($this$sortByDescending$iv.size() > 1) {
                CollectionsKt.sortWith((List)$this$sortByDescending$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Pair it = (Pair)b;
                        boolean bl = false;
                        Comparable comparable = (Integer)it.getFirst();
                        it = (Pair)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getFirst()));
                    }
                });
            }
            ItemStack itemStack = (ItemStack)((Pair)diffs.get(0)).getSecond();
            NonNullList nonNullList = inventory.f_35974_;
            Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"inventory.items");
            int currentTotal = this.getTotalItemCount(itemStack, (List)nonNullList);
            int remainingShouldDrop = RangesKt.coerceAtLeast((int)(currentTotal - (mustKeep = cfg.getLeastAmount())), (int)0);
            if (remainingShouldDrop <= 0) continue;
            for (Pair pair : diffs) {
                int allowedByKeep;
                int maxDropFromSlot;
                int maxAllowed;
                int dropFromThis;
                ItemStack currentSlotStack;
                int inventoryIndex = ((Number)pair.component1()).intValue();
                ItemStack diffStack = (ItemStack)pair.component2();
                if (remainingShouldDrop <= 0) continue block1;
                NonNullList nonNullList2 = inventory.f_35974_;
                Intrinsics.checkNotNullExpressionValue((Object)nonNullList2, (String)"inventory.items");
                if ((ItemStack)CollectionsKt.getOrNull((List)((List)nonNullList2), (int)inventoryIndex) == null || !this.isSameConfiguredItem(diffStack, currentSlotStack, cfg) || (dropFromThis = Math.min(maxAllowed = Math.min(remainingShouldDrop, Math.min(maxDropFromSlot = currentSlotStack.m_41613_(), diffStack.m_41613_())), allowedByKeep = RangesKt.coerceAtLeast((int)(currentTotal - mustKeep), (int)0))) <= 0) continue;
                ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)currentSlotStack.m_41720_());
                CompoundTag compoundTag = currentSlotStack.m_41783_();
                Object[] objectArray = new ItemStackToDrop(itemId, null, dropFromThis, compoundTag != null ? compoundTag.hashCode() : 0, inventoryIndex);
                ArrayDeque<ItemStackToDrop> arrayDeque = itemStackToDrop;
                Object[] p0 = objectArray;
                boolean bl = false;
                arrayDeque.add((Object)p0);
                objectArray = new Object[]{dropFromThis, currentSlotStack.m_41778_(), inventoryIndex, remainingShouldDrop -= dropFromThis, currentTotal -= dropFromThis};
                AutoDropXForge.INSTANCE.getLogger().debug("Marked to drop {} of {} at slot {} (remaining={}, total={})", objectArray);
            }
        }
    }

    private final int calculateDropCount(ItemStack newStack, int slotIndex) {
        LocalPlayer localPlayer = AutoDropXForge.INSTANCE.getMC().f_91074_;
        if (localPlayer == null) {
            return 0;
        }
        LocalPlayer player = localPlayer;
        Inventory inventory = player.m_150109_();
        ConfigContainerMenu.ConfigItem configItem = Config.INSTANCE.getItemConfig(newStack);
        if (configItem == null) {
            return 0;
        }
        ConfigContainerMenu.ConfigItem configItem2 = configItem;
        int minKeepAmount = configItem2.getLeastAmount();
        NonNullList nonNullList = inventory.f_35974_;
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"inventory.items");
        int totalCount = this.getTotalItemCount(newStack, (List)nonNullList);
        if (totalCount <= minKeepAmount) {
            return 0;
        }
        int shouldDrop = totalCount - minKeepAmount;
        Object object = inventory.f_35974_.get(slotIndex);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inventory.items[slotIndex]");
        ItemStack currentSlotStack = (ItemStack)object;
        int maxDropFromSlot = this.isSameConfiguredItem(newStack, currentSlotStack, configItem2) ? currentSlotStack.m_41613_() : 0;
        return Math.min(shouldDrop, Math.min(maxDropFromSlot, newStack.m_41613_()));
    }

    /*
     * WARNING - void declaration
     */
    private final int getTotalItemCount(ItemStack targetStack, List<ItemStack> inventoryItems) {
        ConfigContainerMenu.ConfigItem configItem = Config.INSTANCE.getItemConfig(targetStack);
        if (configItem == null) {
            return 0;
        }
        ConfigContainerMenu.ConfigItem configItem2 = configItem;
        Iterable iterable = inventoryItems;
        int n = 0;
        for (Object t : iterable) {
            void stack;
            ItemStack itemStack = (ItemStack)t;
            int n2 = n;
            boolean bl = false;
            int n3 = INSTANCE.isSameConfiguredItem(targetStack, (ItemStack)stack, configItem2) ? stack.m_41613_() : 0;
            n = n2 + n3;
        }
        return n;
    }

    private final boolean isSameConfiguredItem(ItemStack targetStack, ItemStack compareStack, ConfigContainerMenu.ConfigItem configItem) {
        boolean bl;
        if (compareStack.m_41619_()) {
            return false;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[configItem.getMatchMode().ordinal()]) {
            case 1: {
                bl = Intrinsics.areEqual((Object)targetStack.m_41720_(), (Object)compareStack.m_41720_());
                break;
            }
            case 2: {
                bl = ItemStack.m_150942_((ItemStack)targetStack, (ItemStack)compareStack);
                break;
            }
            case 3: {
                String string = configItem.getCurrentTag();
                if (string == null) {
                    return false;
                }
                String targetTag = string;
                List<String> compareTags2 = compareStack.m_41720_().m_204114_().m_203616_().map(arg_0 -> DropManager.isSameConfiguredItem$lambda$4(isSameConfiguredItem.compareTags.1.INSTANCE, arg_0)).toList();
                bl = compareTags2.contains(targetTag);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    public final void restoreState() {
        LocalPlayer localPlayer = AutoDropXForge.INSTANCE.getMC().f_91074_;
        NonNullList nonNullList = localPlayer != null && (localPlayer = localPlayer.m_150109_()) != null ? localPlayer.f_35974_ : null;
        if (nonNullList == null) {
            return;
        }
        NonNullList items = nonNullList;
        List<Pair<Integer, ItemStack>> newItems = DiffScanner.INSTANCE.getNewItems((NonNullList<ItemStack>)items);
        Iterable $this$forEach$iv = newItems;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            Object[] objectArray = new Object[]{it.getFirst(), ((ItemStack)it.getSecond()).m_41778_(), ((ItemStack)it.getSecond()).m_41613_()};
            AutoDropXForge.INSTANCE.getLogger().debug("New diff {} {} x{}", objectArray);
        }
        this.processNewItems(newItems);
    }

    public final void tick() {
        if (ticksToDrop > 0) {
            int n = ticksToDrop;
            if ((ticksToDrop = n + -1) == 0) {
                this.restoreState();
            }
            return;
        }
        if (!Config.INSTANCE.getEnabled()) {
            return;
        }
        this.scan();
        this.step();
    }

    private final void periodicInventoryCheck() {
        LocalPlayer localPlayer = AutoDropXForge.INSTANCE.getMC().f_91074_;
        if (localPlayer == null) {
            return;
        }
        LocalPlayer player = localPlayer;
        Inventory inventory = player.m_150109_();
        if (player.f_19797_ % 20 != 0) {
            return;
        }
        List<ConfigContainerMenu.ConfigItem> configuredItems = ConfigManager.INSTANCE.getConfiguredItems();
        for (ConfigContainerMenu.ConfigItem configItem : configuredItems) {
            if (configItem.getItem().m_41619_()) continue;
            ItemStack itemStack = configItem.getItem();
            NonNullList nonNullList = inventory.f_35974_;
            Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"inventory.items");
            int totalCount = this.getTotalItemCount(itemStack, (List)nonNullList);
            if (totalCount <= configItem.getLeastAmount()) continue;
            int excessCount = totalCount - configItem.getLeastAmount();
            NonNullList nonNullList2 = inventory.f_35974_;
            Intrinsics.checkNotNullExpressionValue((Object)nonNullList2, (String)"inventory.items");
            this.markExcessItemsForDrop(configItem, excessCount, (List)nonNullList2);
        }
    }

    private final void markExcessItemsForDrop(ConfigContainerMenu.ConfigItem configItem, int excessCount, List<ItemStack> inventoryItems) {
        int remainingToDrop = excessCount;
        int n = inventoryItems.size() + -1;
        if (0 <= n) {
            do {
                int dropFromThisSlot;
                int i = n--;
                if (remainingToDrop <= 0) break;
                ItemStack stack = inventoryItems.get(i);
                if (!this.isSameConfiguredItem(configItem.getItem(), stack, configItem) || (dropFromThisSlot = Math.min(remainingToDrop, stack.m_41613_())) <= 0) continue;
                ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
                CompoundTag compoundTag = stack.m_41783_();
                ItemStackToDrop itemStackToDrop = new ItemStackToDrop(itemId, null, dropFromThisSlot, compoundTag != null ? compoundTag.hashCode() : 0, i);
                ArrayDeque<ItemStackToDrop> arrayDeque = DropManager.itemStackToDrop;
                ItemStackToDrop p0 = itemStackToDrop;
                boolean bl = false;
                arrayDeque.add((Object)p0);
                remainingToDrop -= dropFromThisSlot;
                AutoDropXForge.INSTANCE.getLogger().debug("Marked {} items at slot {} for dropping (excess)", (Object)dropFromThisSlot, (Object)i);
            } while (0 <= n);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void scan() {
        if (itemStackToDrop.isEmpty()) {
            return;
        }
        Iterable $this$forEach$iv = (Iterable)itemStackToDrop;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$forEach$iv2;
            ItemStackToDrop toDrop = (ItemStackToDrop)element$iv;
            boolean bl = false;
            List<Step> steps = INSTANCE.simpleScanAndGetSteps(toDrop);
            if (steps.isEmpty()) continue;
            Iterable iterable = steps;
            ArrayDeque<Step> arrayDeque = stepsToDo;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Step p0 = (Step)element$iv2;
                boolean bl2 = false;
                arrayDeque.add((Object)p0);
            }
        }
        itemStackToDrop.clear();
    }

    public final void step() {
        if (stepsToDo.isEmpty()) {
            return;
        }
        if (AutoDropXForge.INSTANCE.getMC().f_91080_ instanceof ConfigContainerScreen) {
            return;
        }
        if (AutoDropXForge.INSTANCE.getMC().f_91080_ instanceof AbstractContainerScreen) {
            ItemStack carried;
            LocalPlayer localPlayer = AutoDropXForge.INSTANCE.getMC().f_91074_;
            ItemStack itemStack = localPlayer != null && (localPlayer = localPlayer.f_36096_) != null ? localPlayer.m_142621_() : (carried = null);
            if (carried != null && !carried.m_41619_()) {
                return;
            }
        }
        Iterable $this$forEach$iv = (Iterable)stepsToDo;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int n;
            Step step = (Step)element$iv;
            boolean bl = false;
            int containerId = 0;
            if (AutoDropXForge.INSTANCE.getMC().f_91080_ instanceof AbstractContainerScreen) {
                Object v5;
                AbstractContainerScreen screen;
                block20: {
                    Screen screen2 = AutoDropXForge.INSTANCE.getMC().f_91080_;
                    Intrinsics.checkNotNull((Object)screen2, (String)"null cannot be cast to non-null type net.minecraft.client.gui.screens.inventory.AbstractContainerScreen<*>");
                    screen = (AbstractContainerScreen)screen2;
                    NonNullList nonNullList = screen.m_6262_().f_38839_;
                    Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"screen.menu.slots");
                    Iterable $this$firstOrNull$iv = CollectionsKt.withIndex((Iterable)((Iterable)nonNullList));
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv2 : $this$firstOrNull$iv) {
                        IndexedValue it = (IndexedValue)element$iv2;
                        boolean bl2 = false;
                        LocalPlayer localPlayer = AutoDropXForge.INSTANCE.getMC().f_91074_;
                        if (!(Intrinsics.areEqual((Object)((Slot)it.getValue()).f_40218_, (Object)(localPlayer != null ? localPlayer.m_150109_() : null)) && ((Slot)it.getValue()).getSlotIndex() == step.getInventoryIndex())) continue;
                        v5 = element$iv2;
                        break block20;
                    }
                    v5 = null;
                }
                IndexedValue slot = v5;
                if (slot != null) {
                    containerId = screen.m_6262_().f_38840_;
                }
                IndexedValue indexedValue = slot;
                n = indexedValue != null ? indexedValue.getIndex() : (step.getInventoryIndex() < 9 ? step.getInventoryIndex() + 36 : step.getInventoryIndex());
            } else {
                n = step.getInventoryIndex() < 9 ? step.getInventoryIndex() + 36 : step.getInventoryIndex();
            }
            int slotId = n;
            switch (WhenMappings.$EnumSwitchMapping$1[step.getAction().ordinal()]) {
                case 1: {
                    MultiPlayerGameMode multiPlayerGameMode = AutoDropXForge.INSTANCE.getMC().f_91072_;
                    if (multiPlayerGameMode != null) {
                        LocalPlayer localPlayer = AutoDropXForge.INSTANCE.getMC().f_91074_;
                        Intrinsics.checkNotNull((Object)localPlayer);
                        multiPlayerGameMode.m_171799_(containerId, slotId, 1, ClickType.THROW, (Player)localPlayer);
                    }
                    break;
                }
                case 2: {
                    MultiPlayerGameMode multiPlayerGameMode = AutoDropXForge.INSTANCE.getMC().f_91072_;
                    if (multiPlayerGameMode != null) {
                        LocalPlayer localPlayer = AutoDropXForge.INSTANCE.getMC().f_91074_;
                        Intrinsics.checkNotNull((Object)localPlayer);
                        multiPlayerGameMode.m_171799_(containerId, slotId, 0, ClickType.THROW, (Player)localPlayer);
                    }
                    break;
                }
                case 3: {
                    MultiPlayerGameMode multiPlayerGameMode = AutoDropXForge.INSTANCE.getMC().f_91072_;
                    if (multiPlayerGameMode != null) {
                        LocalPlayer localPlayer = AutoDropXForge.INSTANCE.getMC().f_91074_;
                        Intrinsics.checkNotNull((Object)localPlayer);
                        multiPlayerGameMode.m_171799_(containerId, -999, 0, ClickType.PICKUP, (Player)localPlayer);
                    }
                    break;
                }
                case 4: {
                    MultiPlayerGameMode multiPlayerGameMode = AutoDropXForge.INSTANCE.getMC().f_91072_;
                    if (multiPlayerGameMode != null) {
                        LocalPlayer localPlayer = AutoDropXForge.INSTANCE.getMC().f_91074_;
                        Intrinsics.checkNotNull((Object)localPlayer);
                        multiPlayerGameMode.m_171799_(containerId, slotId, 1, ClickType.PICKUP, (Player)localPlayer);
                    }
                    break;
                }
                case 5: {
                    MultiPlayerGameMode multiPlayerGameMode = AutoDropXForge.INSTANCE.getMC().f_91072_;
                    if (multiPlayerGameMode == null) break;
                    LocalPlayer localPlayer = AutoDropXForge.INSTANCE.getMC().f_91074_;
                    Intrinsics.checkNotNull((Object)localPlayer);
                    multiPlayerGameMode.m_171799_(containerId, slotId, 0, ClickType.PICKUP, (Player)localPlayer);
                    break;
                }
            }
            Object[] objectArray = new Object[]{step.getAction().name(), containerId, slotId};
            AutoDropXForge.INSTANCE.getLogger().debug("Drop Action:{} container:{} slot:{}", objectArray);
        }
        stepsToDo.clear();
    }

    private final List<Step> simpleScanAndGetSteps(ItemStackToDrop target) {
        List result = new ArrayList();
        LocalPlayer localPlayer = AutoDropXForge.INSTANCE.getMC().f_91074_;
        Object object = localPlayer != null ? localPlayer.m_150109_() : null;
        if (object == null) {
            return result;
        }
        Inventory playerInventory = object;
        NonNullList nonNullList = playerInventory.f_35974_;
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"playerInventory.items");
        ItemStack itemStack = (ItemStack)CollectionsKt.getOrNull((List)((List)nonNullList), (int)target.getInventoryIndex());
        if (itemStack == null) {
            return result;
        }
        ItemStack currentStack = itemStack;
        ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)currentStack.m_41720_());
        if (!Intrinsics.areEqual((Object)itemId, (Object)target.getResourceLocation())) {
            Object[] objectArray = new Object[]{target.getInventoryIndex(), target.getResourceLocation(), itemId};
            AutoDropXForge.INSTANCE.getLogger().debug("Item mismatch at slot {}: expected {}, found {}", objectArray);
            return result;
        }
        if (target.getCount() >= currentStack.m_41613_()) {
            result.add(new Step(target.getInventoryIndex(), Action.DROP_STACK));
        } else {
            int n = target.getCount();
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl = false;
                result.add(new Step(target.getInventoryIndex(), Action.DROP_SLOT));
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Step> scanAndGetSteps(@NotNull ItemStackToDrop target) {
        int minKeep;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        List result = new ArrayList();
        LocalPlayer localPlayer = AutoDropXForge.INSTANCE.getMC().f_91074_;
        Object object = localPlayer != null ? localPlayer.m_150109_() : null;
        if (object == null) {
            return result;
        }
        Inventory playerInventory = object;
        NonNullList nonNullList = playerInventory.f_35974_;
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"playerInventory.items");
        ItemStack itemStack = (ItemStack)CollectionsKt.getOrNull((List)((List)nonNullList), (int)target.getInventoryIndex());
        if (itemStack == null) {
            return result;
        }
        ItemStack currentStack = itemStack;
        ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)currentStack.m_41720_());
        if (!Intrinsics.areEqual((Object)itemId, (Object)target.getResourceLocation())) {
            Object[] objectArray = new Object[]{target.getInventoryIndex(), target.getResourceLocation(), itemId};
            AutoDropXForge.INSTANCE.getLogger().debug("Item mismatch at slot {}: expected {}, found {}", objectArray);
            return result;
        }
        ConfigContainerMenu.ConfigItem configItem = Config.INSTANCE.getItemConfig(currentStack);
        int n = minKeep = configItem != null ? configItem.getLeastAmount() : 0;
        if (target.getCount() >= currentStack.m_41613_()) {
            Step step;
            Step p0 = step = new Step(target.getInventoryIndex(), Action.DROP_STACK);
            boolean bl = false;
            result.add(p0);
        } else {
            List<DropAlgorithm.Operation> list;
            DropAlgorithm.Solution solution = DropAlgorithm.INSTANCE.solve(currentStack.m_41613_(), target.getCount(), minKeep);
            if (solution != null && (list = solution.getOperations()) != null) {
                void $this$forEach$iv;
                Iterable bl = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Step step;
                    DropAlgorithm.Operation operation = (DropAlgorithm.Operation)element$iv;
                    boolean bl2 = false;
                    Step p0 = step = new Step(target.getInventoryIndex(), operation.getAction());
                    boolean bl3 = false;
                    result.add(p0);
                }
            }
        }
        return result;
    }

    private static final String isSameConfiguredItem$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lench/autodropx/forge/feature/drop/DropManager$Action;", "", "(Ljava/lang/String;I)V", "DROP_STACK", "TAKE_HALF", "PLACE_INTO_SLOT", "DROP_HAND", "DROP_SLOT", "autodropx"})
    public static final class Action
    extends Enum<Action> {
        public static final /* enum */ Action DROP_STACK = new Action();
        public static final /* enum */ Action TAKE_HALF = new Action();
        public static final /* enum */ Action PLACE_INTO_SLOT = new Action();
        public static final /* enum */ Action DROP_HAND = new Action();
        public static final /* enum */ Action DROP_SLOT = new Action();
        private static final /* synthetic */ Action[] $VALUES;

        public static Action[] values() {
            return (Action[])$VALUES.clone();
        }

        public static Action valueOf(String value) {
            return Enum.valueOf(Action.class, value);
        }

        static {
            $VALUES = actionArray = new Action[]{Action.DROP_STACK, Action.TAKE_HALF, Action.PLACE_INTO_SLOT, Action.DROP_HAND, Action.DROP_SLOT};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000bJ\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0011\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0017\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0018\u001a\u00020\bH\u00c6\u0003JE\u0010\u0019\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\bH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\r\u00a8\u0006 "}, d2={"Lench/autodropx/forge/feature/drop/DropManager$ItemStackToDrop;", "", "resourceLocation", "Lnet/minecraft/resources/ResourceLocation;", "forgeTag", "Lnet/minecraft/tags/TagKey;", "Lnet/minecraft/world/item/Item;", "count", "", "tagHash", "inventoryIndex", "(Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/tags/TagKey;III)V", "getCount", "()I", "getForgeTag", "()Lnet/minecraft/tags/TagKey;", "getInventoryIndex", "getResourceLocation", "()Lnet/minecraft/resources/ResourceLocation;", "getTagHash", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "", "autodropx"})
    public static final class ItemStackToDrop {
        @Nullable
        private final ResourceLocation resourceLocation;
        @Nullable
        private final TagKey<Item> forgeTag;
        private final int count;
        private final int tagHash;
        private final int inventoryIndex;

        public ItemStackToDrop(@Nullable ResourceLocation resourceLocation, @Nullable TagKey<Item> forgeTag, int count, int tagHash, int inventoryIndex) {
            this.resourceLocation = resourceLocation;
            this.forgeTag = forgeTag;
            this.count = count;
            this.tagHash = tagHash;
            this.inventoryIndex = inventoryIndex;
        }

        @Nullable
        public final ResourceLocation getResourceLocation() {
            return this.resourceLocation;
        }

        @Nullable
        public final TagKey<Item> getForgeTag() {
            return this.forgeTag;
        }

        public final int getCount() {
            return this.count;
        }

        public final int getTagHash() {
            return this.tagHash;
        }

        public final int getInventoryIndex() {
            return this.inventoryIndex;
        }

        @Nullable
        public final ResourceLocation component1() {
            return this.resourceLocation;
        }

        @Nullable
        public final TagKey<Item> component2() {
            return this.forgeTag;
        }

        public final int component3() {
            return this.count;
        }

        public final int component4() {
            return this.tagHash;
        }

        public final int component5() {
            return this.inventoryIndex;
        }

        @NotNull
        public final ItemStackToDrop copy(@Nullable ResourceLocation resourceLocation, @Nullable TagKey<Item> forgeTag, int count, int tagHash, int inventoryIndex) {
            return new ItemStackToDrop(resourceLocation, forgeTag, count, tagHash, inventoryIndex);
        }

        public static /* synthetic */ ItemStackToDrop copy$default(ItemStackToDrop itemStackToDrop, ResourceLocation resourceLocation, TagKey tagKey, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                resourceLocation = itemStackToDrop.resourceLocation;
            }
            if ((n4 & 2) != 0) {
                tagKey = itemStackToDrop.forgeTag;
            }
            if ((n4 & 4) != 0) {
                n = itemStackToDrop.count;
            }
            if ((n4 & 8) != 0) {
                n2 = itemStackToDrop.tagHash;
            }
            if ((n4 & 0x10) != 0) {
                n3 = itemStackToDrop.inventoryIndex;
            }
            return itemStackToDrop.copy(resourceLocation, tagKey, n, n2, n3);
        }

        @NotNull
        public String toString() {
            return "ItemStackToDrop(resourceLocation=" + this.resourceLocation + ", forgeTag=" + this.forgeTag + ", count=" + this.count + ", tagHash=" + this.tagHash + ", inventoryIndex=" + this.inventoryIndex + ")";
        }

        public int hashCode() {
            int result = this.resourceLocation == null ? 0 : this.resourceLocation.hashCode();
            result = result * 31 + (this.forgeTag == null ? 0 : this.forgeTag.hashCode());
            result = result * 31 + Integer.hashCode(this.count);
            result = result * 31 + Integer.hashCode(this.tagHash);
            result = result * 31 + Integer.hashCode(this.inventoryIndex);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ItemStackToDrop)) {
                return false;
            }
            ItemStackToDrop itemStackToDrop = (ItemStackToDrop)other;
            if (!Intrinsics.areEqual((Object)this.resourceLocation, (Object)itemStackToDrop.resourceLocation)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.forgeTag, itemStackToDrop.forgeTag)) {
                return false;
            }
            if (this.count != itemStackToDrop.count) {
                return false;
            }
            if (this.tagHash != itemStackToDrop.tagHash) {
                return false;
            }
            return this.inventoryIndex == itemStackToDrop.inventoryIndex;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lench/autodropx/forge/feature/drop/DropManager$Step;", "", "inventoryIndex", "", "action", "Lench/autodropx/forge/feature/drop/DropManager$Action;", "(ILench/autodropx/forge/feature/drop/DropManager$Action;)V", "getAction", "()Lench/autodropx/forge/feature/drop/DropManager$Action;", "getInventoryIndex", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "autodropx"})
    public static final class Step {
        private final int inventoryIndex;
        @NotNull
        private final Action action;

        public Step(int inventoryIndex, @NotNull Action action) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            this.inventoryIndex = inventoryIndex;
            this.action = action;
        }

        public final int getInventoryIndex() {
            return this.inventoryIndex;
        }

        @NotNull
        public final Action getAction() {
            return this.action;
        }

        public final int component1() {
            return this.inventoryIndex;
        }

        @NotNull
        public final Action component2() {
            return this.action;
        }

        @NotNull
        public final Step copy(int inventoryIndex, @NotNull Action action) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            return new Step(inventoryIndex, action);
        }

        public static /* synthetic */ Step copy$default(Step step, int n, Action action, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = step.inventoryIndex;
            }
            if ((n2 & 2) != 0) {
                action = step.action;
            }
            return step.copy(n, action);
        }

        @NotNull
        public String toString() {
            return "Step(inventoryIndex=" + this.inventoryIndex + ", action=" + this.action + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.inventoryIndex);
            result = result * 31 + this.action.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Step)) {
                return false;
            }
            Step step = (Step)other;
            if (this.inventoryIndex != step.inventoryIndex) {
                return false;
            }
            return this.action == step.action;
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ConfigContainerMenu.ConfigItem.MatchMode.values().length];
            try {
                nArray[ConfigContainerMenu.ConfigItem.MatchMode.ID.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigContainerMenu.ConfigItem.MatchMode.ID_NBT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigContainerMenu.ConfigItem.MatchMode.ITEM_TAG.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Action.values().length];
            try {
                nArray[Action.DROP_STACK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Action.DROP_SLOT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Action.DROP_HAND.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Action.TAKE_HALF.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Action.PLACE_INTO_SLOT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

