/*
 * Decompiled with CFR 0.152.
 */
package net.zolton21.sevendaystosurvive.fabric.blockentity;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_1299;
import net.minecraft.class_1576;
import net.minecraft.class_1588;
import net.minecraft.class_1642;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.zolton21.sevendaystosurvive.config.CommonConfig;
import net.zolton21.sevendaystosurvive.fabric.block.FabricSynapticSealBlock;
import net.zolton21.sevendaystosurvive.fabric.registry.FabricBlockEntityRegistry;
import net.zolton21.sevendaystosurvive.helper.IZombieHelper;
import net.zolton21.sevendaystosurvive.helper.PlayerHelper;
import net.zolton21.sevendaystosurvive.utils.ZombieUtils;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FabricSynapticSealBlockEntity
extends class_2586
implements GeoBlockEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    List<class_3222> protectedPlayers = new CopyOnWriteArrayList<class_3222>();
    List<class_1588> zombiesWithinRange = new CopyOnWriteArrayList<class_1588>();

    public FabricSynapticSealBlockEntity(class_2338 pPos, class_2680 pBlockState) {
        super((class_2591)FabricBlockEntityRegistry.SYNAPTIC_SEAL.get(), pPos, pBlockState);
    }

    public List<class_1588> zombiesWithinRange(class_2338 blockPos, class_2680 blockState, class_3218 world) {
        int activityRange = (Integer)blockState.method_11654((class_2769)FabricSynapticSealBlock.STATE);
        int blockChunkX = Math.floorDiv(blockPos.method_10263(), 16);
        int blockChunkZ = Math.floorDiv(blockPos.method_10260(), 16);
        int minChunkX = blockChunkX - activityRange;
        int maxChunkX = blockChunkX + activityRange;
        int minChunkZ = blockChunkZ - activityRange;
        int maxChunkZ = blockChunkZ + activityRange;
        int minWorldX = minChunkX * 16;
        int maxWorldX = (maxChunkX + 1) * 16 - 1;
        int minWorldZ = minChunkZ * 16;
        int maxWorldZ = (maxChunkZ + 1) * 16 - 1;
        class_238 range = new class_238((double)minWorldX, (double)world.method_31607(), (double)minWorldZ, (double)maxWorldX, (double)world.method_31600(), (double)maxWorldZ);
        ArrayList<class_1588> monsters = new ArrayList<class_1588>();
        monsters.addAll(world.method_18467(class_1642.class, range));
        monsters.addAll(world.method_18467(class_1576.class, range));
        return monsters;
    }

    public boolean isEntityWithinRange(class_2338 blockPos, class_2680 blockState, class_3222 player) {
        int state = (Integer)blockState.method_11654((class_2769)FabricSynapticSealBlock.STATE);
        int activityRange = 0;
        int blockChunkX = Math.floorDiv(blockPos.method_10263(), 16);
        int blockChunkZ = Math.floorDiv(blockPos.method_10260(), 16);
        if (state == 1) {
            activityRange = 1;
        }
        if (state == 2) {
            activityRange = 2;
        }
        int minChunkX = blockChunkX - activityRange;
        int maxChunkX = blockChunkX + activityRange;
        int minChunkZ = blockChunkZ - activityRange;
        int maxChunkZ = blockChunkZ + activityRange;
        int playerChunkX = Math.floorDiv(player.method_31477(), 16);
        int playerChunkZ = Math.floorDiv(player.method_31479(), 16);
        return playerChunkX >= minChunkX && playerChunkX <= maxChunkX && playerChunkZ >= minChunkZ && playerChunkZ <= maxChunkZ;
    }

    public void tick(class_1937 pLevel1, class_2338 pPos, class_2680 pState1) {
        if (!ZombieUtils.isOblivionNight(this.method_10997()) || ((Boolean)CommonConfig.Server.OBLIVION_NIGHT_SYNAPTIC_SEAL_WORKS.get()).booleanValue()) {
            for (class_1657 player : pLevel1.method_18456()) {
                if (player == null) continue;
                class_3222 serverPlayer = (class_3222)player;
                if (this.isEntityWithinRange(pPos, pState1, serverPlayer)) {
                    if (!serverPlayer.method_5805() || !this.protectedPlayers.stream().noneMatch(p -> p.equals((Object)serverPlayer))) continue;
                    this.protectedPlayers.add(serverPlayer);
                    PlayerHelper.changePlayerProtectionState(serverPlayer, true);
                    continue;
                }
                if (!this.protectedPlayers.stream().anyMatch(p -> p.equals((Object)serverPlayer)) || !serverPlayer.method_5805()) continue;
                this.protectedPlayers.remove(serverPlayer);
                PlayerHelper.changePlayerProtectionState(serverPlayer, false);
            }
            for (class_1588 zombie : this.zombiesWithinRange(pPos, pState1, (class_3218)pLevel1)) {
                if (zombie == null || zombie.method_5864() != class_1299.field_6051 && zombie.method_5864() != class_1299.field_6071 || !this.zombiesWithinRange.stream().noneMatch(z -> z.equals((Object)zombie)) || !zombie.method_5805()) continue;
                this.zombiesWithinRange.add(zombie);
                ((IZombieHelper)zombie).sevenDaysToSurvive$setIsWithinSynapticSealActivityRange(true);
            }
            for (class_1588 zombie : this.zombiesWithinRange) {
                if (zombie == null || zombie.method_5864() != class_1299.field_6051 && zombie.method_5864() != class_1299.field_6071 || !this.zombiesWithinRange(pPos, pState1, (class_3218)pLevel1).stream().noneMatch(z -> z.equals((Object)zombie)) || !zombie.method_5805()) continue;
                this.zombiesWithinRange.remove(zombie);
                ((IZombieHelper)zombie).sevenDaysToSurvive$setIsWithinSynapticSealActivityRange(false);
            }
            class_2248 block = this.method_11010().method_26204();
            if (block instanceof FabricSynapticSealBlock) {
                ((FabricSynapticSealBlock)block).updateLists(this.protectedPlayers, this.zombiesWithinRange);
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private PlayState predicate(AnimationState<FabricSynapticSealBlockEntity> synapticSealBlockEntityAnimationState) {
        synapticSealBlockEntityAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.synaptic_seal.idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

