/*
 * Decompiled with CFR 0.152.
 */
package net.zolton21.sevendaystosurvive.ai.goals;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.zolton21.sevendaystosurvive.config.CommonConfig;
import net.zolton21.sevendaystosurvive.helper.IZombieHelper;
import net.zolton21.sevendaystosurvive.helper.PlayerHelper;
import net.zolton21.sevendaystosurvive.utils.ZombieUtils;

public class BuildTowardsTargetGoal
extends Goal {
    protected final double speedModifier;
    private final PathfinderMob mob;
    private int tickCounter;
    private int endJumpTick;
    private boolean isJumping;
    private ItemStack heldItem;
    private int placeBlockTick;
    private boolean isPlacingBlock;
    private BlockPos placeBlockBlockPos;
    private long lastCanUseCheck;

    public BuildTowardsTargetGoal(PathfinderMob creature, double speed) {
        this.mob = creature;
        this.speedModifier = speed;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        long i = this.mob.m_9236_().m_46467_();
        if (i - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = i;
        if (((Boolean)CommonConfig.Server.ZOMBIES_BUILD_AND_DIG_ONLY_ON_OBLIVION_NIGHT.get()).booleanValue() && !ZombieUtils.isOblivionNight(this.mob.m_9236_())) {
            return false;
        }
        if (((IZombieHelper)this.mob).sevenDaysToSurvive$getIsWithinSynapticSealActivityRange()) {
            return false;
        }
        if (((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget() != null && PlayerHelper.isPlayerProtected((ServerPlayer)((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget())) {
            return false;
        }
        if (((IZombieHelper)this.mob).sevenDaysToSurvive$getMobHasPlayerTargetAndCanReach()) {
            return false;
        }
        if (((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget() == null) {
            return false;
        }
        if (!((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget().m_6084_() || ((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget().m_5833_() || ((ServerPlayer)((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget()).m_7500_()) {
            return false;
        }
        if (this.mob.m_20096_() && this.mob.m_9236_().m_8055_(this.mob.m_20183_().m_7918_(0, -1, 0)).m_60795_() && i - ((IZombieHelper)this.mob).sevenDaysToSurvive$getNoMovementSinceTick() >= 200L) {
            return true;
        }
        if (this.mob.m_9236_().m_8055_(this.mob.m_20183_()).m_60819_().m_76178_() && !this.mob.m_9236_().m_8055_(this.mob.m_20183_().m_7918_(0, -1, 0)).m_60819_().m_76178_()) {
            return true;
        }
        if (ZombieUtils.isMobStandingOnAFullBlock((Mob)this.mob) && ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos() != null) {
            if (!this.mob.m_9236_().m_8055_(((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_7918_(0, -1, 0)).m_60819_().m_76178_()) {
                return true;
            }
            if (this.mob.m_9236_().m_8055_(((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos()).m_60819_().m_76178_() && !this.mob.m_9236_().m_8055_(((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos()).m_60795_()) {
                return false;
            }
            if (ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_7918_(0, -1, 0)) && !ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_7918_(0, 1, 0)) && !ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos()) && this.mob.m_9236_().m_8055_(((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos()).m_60819_().m_76178_()) {
                return false;
            }
            if (!(Math.abs(((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_123342_() - this.mob.m_146904_()) >= 3 || Math.abs(((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_123341_() - this.mob.m_146903_()) >= 3 && Math.abs(((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_123343_() - this.mob.m_146907_()) >= 3 || this.mob.m_9236_().m_8055_(((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos()).m_60819_().m_76178_() && this.mob.m_9236_().m_8055_(((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_7918_(0, 1, 0)).m_60819_().m_76178_())) {
                return true;
            }
            if (this.mob.m_146903_() == ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_123341_() && this.mob.m_146907_() == ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_123343_() && (((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_123342_() > this.mob.m_146904_() ? ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_7918_(0, 1, 0)) : ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_123342_() < this.mob.m_146904_() && ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos()))) {
                return false;
            }
            if (ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_7918_(0, -1, 0))) {
                double nextPosY = ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_123342_();
                double mobY = this.mob.m_146904_();
                if (ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_7918_(0, 1, 0))) {
                    return false;
                }
                if (nextPosY > mobY ? ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), this.mob.m_20183_().m_7918_(0, 2, 0)) : nextPosY < mobY && ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_7918_(0, 2, 0))) {
                    return false;
                }
            } else if (ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_7918_(0, -2, 0)) && this.mob.m_20186_() >= (double)((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_123342_() && (((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_123341_() != this.mob.m_146903_() || ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_123343_() != this.mob.m_146907_())) {
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        if (((IZombieHelper)this.mob).sevenDaysToSurvive$getIsWithinSynapticSealActivityRange()) {
            return false;
        }
        if (((Boolean)CommonConfig.Server.ZOMBIES_BUILD_AND_DIG_ONLY_ON_OBLIVION_NIGHT.get()).booleanValue() && !ZombieUtils.isOblivionNight(this.mob.m_9236_())) {
            return false;
        }
        if (((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget() != null && PlayerHelper.isPlayerProtected((ServerPlayer)((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget())) {
            return false;
        }
        if (((IZombieHelper)this.mob).sevenDaysToSurvive$getMobHasPlayerTargetAndCanReach()) {
            return false;
        }
        if (((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget() == null) {
            return false;
        }
        if (!((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget().m_6084_() || ((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget().m_5833_() || ((ServerPlayer)((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget()).m_7500_()) {
            return false;
        }
        if (this.mob.m_20096_() && this.mob.m_9236_().m_8055_(this.mob.m_20183_().m_7918_(0, -1, 0)).m_60795_() && this.mob.m_9236_().m_46467_() - ((IZombieHelper)this.mob).sevenDaysToSurvive$getNoMovementSinceTick() >= 200L) {
            return true;
        }
        if (this.mob.m_9236_().m_8055_(this.mob.m_20183_()).m_60819_().m_76178_() && !this.mob.m_9236_().m_8055_(this.mob.m_20183_().m_7918_(0, -1, 0)).m_60819_().m_76178_()) {
            return true;
        }
        if (((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos() != null && ((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget() != null && ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos() != null) {
            if (!this.isJumping) {
                if (!this.mob.m_9236_().m_8055_(((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_7918_(0, -1, 0)).m_60819_().m_76178_()) {
                    return true;
                }
                if (ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_7918_(0, -1, 0)) && !ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_7918_(0, 1, 0)) && !ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos()) && this.mob.m_9236_().m_8055_(((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos()).m_60819_().m_76178_()) {
                    return false;
                }
                if (this.mob.m_146903_() == ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_123341_() && this.mob.m_146907_() == ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_123343_()) {
                    if (((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_123342_() > this.mob.m_146904_() ? ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_7918_(0, 1, 0)) : ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_123342_() < this.mob.m_146904_() && ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos())) {
                        return false;
                    }
                } else if (ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_7918_(0, -1, 0))) {
                    double nextPosY = ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_123342_();
                    double mobY = this.mob.m_146904_();
                    if (ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_7918_(0, 1, 0))) {
                        return false;
                    }
                    if (nextPosY > mobY ? ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), this.mob.m_20183_().m_7918_(0, 2, 0)) : nextPosY < mobY && ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_7918_(0, 2, 0))) {
                        return false;
                    }
                }
            }
            if (!(Math.abs(((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_123342_() - this.mob.m_146904_()) >= 3 || Math.abs(((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_123341_() - this.mob.m_146903_()) >= 3 && Math.abs(((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_123343_() - this.mob.m_146907_()) >= 3 || this.mob.m_9236_().m_8055_(((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos()).m_60819_().m_76178_() && this.mob.m_9236_().m_8055_(((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_7918_(0, 1, 0)).m_60819_().m_76178_())) {
                return true;
            }
            return true;
        }
        return false;
    }

    public void m_8037_() {
        ++this.tickCounter;
        if (this.isPlacingBlock) {
            this.faceTarget(this.placeBlockBlockPos);
            this.mob.m_21573_().m_26517_(0.0);
            if (this.tickCounter == this.placeBlockTick) {
                this.placeBlock(this.placeBlockBlockPos);
                this.mob.m_21573_().m_26517_(this.speedModifier);
                this.isPlacingBlock = false;
                ((IZombieHelper)this.mob).setSevenDaysToSurvive$nextBlockPos(this.placeBlockBlockPos.m_7918_(0, 1, 0));
            }
        }
        if (this.isJumping && this.tickCounter == this.endJumpTick) {
            this.placeBlock(new BlockPos(this.mob.m_146903_(), this.mob.m_146904_() - 1, this.mob.m_146907_()));
            this.isJumping = false;
        }
        if (!this.isPlacingBlock && this.tickCounter % 10 == 0 && ((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget() != null) {
            if (this.mob.m_20096_() && this.mob.m_9236_().m_8055_(this.mob.m_20183_().m_7918_(0, -1, 0)).m_60795_() && this.mob.m_9236_().m_46467_() - ((IZombieHelper)this.mob).sevenDaysToSurvive$getNoMovementSinceTick() >= 200L) {
                this.startPlacingBlock(this.mob.m_20183_().m_7918_(0, -1, 0));
            }
            if (this.mob.m_9236_().m_8055_(this.mob.m_20183_()).m_60819_().m_76178_() && !this.mob.m_9236_().m_8055_(this.mob.m_20183_().m_7918_(0, -1, 0)).m_60819_().m_76178_()) {
                this.startPlacingBlock(this.mob.m_20183_().m_7918_(0, -1, 0));
            }
            if (((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos() != null) {
                if (!this.mob.m_9236_().m_8055_(((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos()).m_60819_().m_76178_()) {
                    if (Math.abs(((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_123341_() - this.mob.m_146903_()) < 3 || Math.abs(((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_123343_() - this.mob.m_146907_()) < 3) {
                        this.startPlacingBlock(((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos());
                    }
                } else if (!this.mob.m_9236_().m_8055_(((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_7918_(0, 1, 0)).m_60819_().m_76178_()) {
                    if (Math.abs(((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_123341_() - this.mob.m_146903_()) < 3 || Math.abs(((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_123343_() - this.mob.m_146907_()) < 3) {
                        this.startPlacingBlock(((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_7918_(0, 1, 0));
                    }
                } else {
                    if (ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), this.mob.m_20183_())) {
                        this.mobJump(this.tickCounter);
                    }
                    if (this.mob.m_20183_().m_123341_() == ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_123341_() && this.mob.m_20183_().m_123342_() < ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_123342_() && this.mob.m_20183_().m_123343_() == ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_123343_()) {
                        double distance;
                        boolean canPlaceBlock = true;
                        for (int i = 0; i < 3; ++i) {
                            BlockPos blockPos = new BlockPos(this.mob.m_146903_(), this.mob.m_146904_() + i, this.mob.m_146907_());
                            if (!ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), blockPos)) continue;
                            canPlaceBlock = false;
                            break;
                        }
                        if (canPlaceBlock) {
                            this.mobJump(this.tickCounter);
                        }
                        if (((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_123341_() == this.mob.m_146903_() && ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_123343_() == this.mob.m_146907_() && (distance = this.mob.m_20238_(this.mob.m_20183_().m_252807_())) > 0.15) {
                            double currentX = this.mob.m_20185_();
                            double currentZ = this.mob.m_20189_();
                            double offsetX = Math.floor(currentX) + 0.5 - currentX;
                            double offsetZ = Math.floor(currentZ) + 0.5 - currentZ;
                            this.mob.m_20256_(this.mob.m_20184_().m_82520_(offsetX * 0.1, 0.0, offsetZ * 0.1));
                        }
                    } else if (Math.abs(((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_123342_() - this.mob.m_146904_()) < 2 && (Math.abs(((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_123341_() - ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_123341_()) < 3 || Math.abs(((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_123343_() - ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_123343_()) < 3)) {
                        BlockPos blockPos = new BlockPos((Vec3i)((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_7918_(0, -1, 0));
                        if (!ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), blockPos)) {
                            this.startPlacingBlock(blockPos);
                        } else if (!this.mob.m_9236_().m_8055_(((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos()).m_60819_().m_76178_()) {
                            this.startPlacingBlock(((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos());
                        }
                    }
                }
            }
        }
    }

    private void startPlacingBlock(BlockPos blockPos) {
        this.isPlacingBlock = true;
        this.placeBlockTick = this.tickCounter + 10;
        this.placeBlockBlockPos = blockPos;
    }

    public void faceTarget(BlockPos blockPos) {
        this.mob.m_21563_().m_24964_(Vec3.m_82512_((Vec3i)blockPos));
    }

    private void mobJump(int currentTick) {
        this.isJumping = true;
        int x = this.mob.m_146903_();
        int y = this.mob.m_146904_() + 3;
        int z = this.mob.m_146907_();
        this.endJumpTick = ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), new BlockPos(x, y, z)) ? currentTick + 2 : currentTick + 4;
        AABB aabb = new AABB(this.mob.m_20183_());
        List monsterEntities = this.mob.m_9236_().m_45976_(Monster.class, aabb);
        if (!monsterEntities.isEmpty()) {
            for (Monster monsterEntity : monsterEntities) {
                monsterEntity.m_21569_().m_24901_();
            }
        }
    }

    private void placeBlock(BlockPos blockPos) {
        if (this.mob.m_20238_(blockPos.m_252807_()) <= 4.0) {
            ((IZombieHelper)this.mob).setSevenDaysToSurvive$placedBlockBlockPos(blockPos);
            if (!ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), blockPos)) {
                this.mob.m_9236_().m_7731_(blockPos, Blocks.f_50652_.m_49966_(), 3);
                this.mob.m_6674_(InteractionHand.MAIN_HAND);
                this.mob.m_9236_().m_5594_(null, blockPos, SoundEvents.f_12447_, this.mob.m_5720_(), 1.0f, 1.0f);
            }
        }
        GroundPathNavigation GroundPathNavigation2 = (GroundPathNavigation)this.mob.m_21573_();
    }

    public void m_8056_() {
        this.mob.m_21573_().m_26573_();
        ((IZombieHelper)this.mob).sevenDaysToSurvive$customGoalStarted();
        this.tickCounter = 0;
        this.isJumping = false;
        this.isPlacingBlock = false;
        this.heldItem = this.mob.m_21120_(InteractionHand.MAIN_HAND);
        this.mob.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42594_));
    }

    public void m_8041_() {
        this.mob.m_21008_(InteractionHand.MAIN_HAND, this.heldItem);
        ((IZombieHelper)this.mob).sevenDaysToSurvive$customGoalFinished();
    }
}

