/*
 * Decompiled with CFR 0.152.
 */
package net.zolton21.sevendaystosurvive.ai.goals;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.phys.Vec3;
import net.zolton21.sevendaystosurvive.config.CommonConfig;
import net.zolton21.sevendaystosurvive.helper.IZombieHelper;
import net.zolton21.sevendaystosurvive.helper.PlayerHelper;
import net.zolton21.sevendaystosurvive.utils.ZombieUtils;
import org.jetbrains.annotations.Nullable;

public class DiggingGoal
extends Goal {
    protected final double speedModifier;
    private final PathfinderMob mob;
    private ItemStack heldItem;
    @Nullable
    private BlockPos nextBlockPos;
    private int tickCounter;
    private boolean isBreakingBlock;
    private int breakBlockTick;
    private BlockPos breakBlockBlockPos;
    private float blockBreakTime;
    private ItemStack offHandHeldItem;
    private boolean shouldPlaceBlock;
    private int placeBlockTick;
    private BlockPos placeBlockBlockPos;
    private long lastCanUseCheck;

    public DiggingGoal(PathfinderMob creature, double speed) {
        this.mob = creature;
        this.speedModifier = speed;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        long i = this.mob.m_9236_().m_46467_();
        if (i - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = i;
        if (((IZombieHelper)this.mob).sevenDaysToSurvive$getIsWithinSynapticSealActivityRange()) {
            return false;
        }
        if (((Boolean)CommonConfig.Server.ZOMBIES_BUILD_AND_DIG_ONLY_ON_OBLIVION_NIGHT.get()).booleanValue() && !ZombieUtils.isOblivionNight(this.mob.m_9236_())) {
            return false;
        }
        if (((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget() != null && PlayerHelper.isPlayerProtected((ServerPlayer)((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget())) {
            return false;
        }
        if (((IZombieHelper)this.mob).sevenDaysToSurvive$getMobHasPlayerTargetAndCanReach()) {
            return false;
        }
        if (((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget() == null) {
            return false;
        }
        if (!((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget().m_6084_() || ((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget().m_5833_() || ((ServerPlayer)((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget()).m_7500_()) {
            return false;
        }
        if (ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), this.mob.m_20183_().m_7918_(0, -1, 0))) {
            this.nextBlockPos = ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos();
            if (this.nextBlockPos != null && this.mob.m_9236_().m_8055_(this.nextBlockPos).m_60819_().m_76178_()) {
                if (this.mob.m_9236_().m_8055_(this.nextBlockPos.m_7918_(0, -1, 0)).m_60734_() instanceof TrapDoorBlock) {
                    return true;
                }
                if (this.mob.m_9236_().m_8055_(this.mob.m_20183_().m_7918_(0, -1, 0)).m_60734_() instanceof TrapDoorBlock) {
                    return true;
                }
                if (this.mob.m_146903_() == this.nextBlockPos.m_123341_() && this.mob.m_146907_() == this.nextBlockPos.m_123343_()) {
                    if (this.mob.m_20186_() < (double)this.nextBlockPos.m_123342_() ? ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), this.nextBlockPos.m_7918_(0, 1, 0)) : this.mob.m_20186_() > (double)this.nextBlockPos.m_123342_() && ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), this.nextBlockPos)) {
                        return true;
                    }
                } else {
                    double mobY;
                    double nextPosY = this.nextBlockPos.m_123342_();
                    if (nextPosY == (mobY = (double)this.mob.m_146904_())) {
                        if (ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), this.nextBlockPos) && ZombieUtils.isBlockBreakable(this.mob.m_9236_(), this.nextBlockPos)) {
                            return true;
                        }
                        if (ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), this.nextBlockPos.m_7918_(0, 1, 0)) && ZombieUtils.isBlockBreakable(this.mob.m_9236_(), this.nextBlockPos.m_7918_(0, 1, 0))) {
                            return true;
                        }
                    } else if (nextPosY > mobY) {
                        if (ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), this.nextBlockPos) && ZombieUtils.isBlockBreakable(this.mob.m_9236_(), this.nextBlockPos)) {
                            return true;
                        }
                        if (ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), this.mob.m_20183_().m_7918_(0, 2, 0)) ? ZombieUtils.isBlockBreakable(this.mob.m_9236_(), this.mob.m_20183_().m_7918_(0, 2, 0)) : (ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), this.nextBlockPos.m_7918_(0, 1, 0)) ? ZombieUtils.isBlockBreakable(this.mob.m_9236_(), this.nextBlockPos.m_7918_(0, 1, 0)) : (Math.abs(this.mob.m_146903_() - this.nextBlockPos.m_123341_()) < 2 || Math.abs(this.mob.m_146907_() - this.nextBlockPos.m_123343_()) < 2) && ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), this.mob.m_20183_().m_7918_(0, 2, 0)) && ZombieUtils.isBlockBreakable(this.mob.m_9236_(), this.mob.m_20183_().m_7918_(0, 2, 0)))) {
                            return true;
                        }
                    } else {
                        if (ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), this.nextBlockPos) && ZombieUtils.isBlockBreakable(this.mob.m_9236_(), this.nextBlockPos)) {
                            return true;
                        }
                        if (ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), this.nextBlockPos.m_7918_(0, 1, 0)) && ZombieUtils.isBlockBreakable(this.mob.m_9236_(), this.nextBlockPos.m_7918_(0, 1, 0))) {
                            return true;
                        }
                        if (ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), this.nextBlockPos.m_7918_(0, 2, 0)) && ZombieUtils.isBlockBreakable(this.mob.m_9236_(), this.nextBlockPos.m_7918_(0, 2, 0))) {
                            return true;
                        }
                    }
                }
            }
        }
        return !ZombieUtils.isMobStandingOnAFullBlock((Mob)this.mob) && ((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget() != null && this.mob.m_9236_().m_8055_(this.mob.m_20183_()).m_60819_().m_76178_() && this.mob.m_9236_().m_8055_(this.mob.m_20183_().m_7918_(0, -1, 0)).m_60819_().m_76178_();
    }

    public boolean m_8045_() {
        if (((IZombieHelper)this.mob).sevenDaysToSurvive$getIsWithinSynapticSealActivityRange()) {
            return false;
        }
        if (((Boolean)CommonConfig.Server.ZOMBIES_BUILD_AND_DIG_ONLY_ON_OBLIVION_NIGHT.get()).booleanValue() && !ZombieUtils.isOblivionNight(this.mob.m_9236_())) {
            return false;
        }
        if (((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget() != null && PlayerHelper.isPlayerProtected((ServerPlayer)((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget())) {
            return false;
        }
        if (((IZombieHelper)this.mob).sevenDaysToSurvive$getMobHasPlayerTargetAndCanReach()) {
            return false;
        }
        if (((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget() == null) {
            return false;
        }
        if (!((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget().m_6084_() || ((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget().m_5833_() || ((ServerPlayer)((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget()).m_7500_()) {
            return false;
        }
        if (((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget() != null) {
            this.nextBlockPos = ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos();
            if (this.nextBlockPos != null) {
                if (this.mob.m_9236_().m_8055_(this.nextBlockPos.m_7918_(0, -1, 0)).m_60734_() instanceof TrapDoorBlock) {
                    return true;
                }
                if (this.mob.m_9236_().m_8055_(this.mob.m_20183_().m_7918_(0, -1, 0)).m_60734_() instanceof TrapDoorBlock) {
                    return true;
                }
                if (this.mob.m_146903_() == this.nextBlockPos.m_123341_() && this.mob.m_146907_() == this.nextBlockPos.m_123343_()) {
                    if (this.mob.m_146904_() < this.nextBlockPos.m_123342_() ? ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), this.nextBlockPos.m_7918_(0, 1, 0)) && ZombieUtils.isBlockBreakable(this.mob.m_9236_(), this.nextBlockPos.m_7918_(0, 1, 0)) : this.mob.m_146904_() > this.nextBlockPos.m_123342_() && ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), this.nextBlockPos) && ZombieUtils.isBlockBreakable(this.mob.m_9236_(), this.nextBlockPos)) {
                        return true;
                    }
                } else {
                    double mobY;
                    double nextPosY = this.nextBlockPos.m_123342_();
                    if (nextPosY == (mobY = (double)this.mob.m_146904_())) {
                        if (ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), this.nextBlockPos) && ZombieUtils.isBlockBreakable(this.mob.m_9236_(), this.nextBlockPos)) {
                            return true;
                        }
                        if (ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), this.nextBlockPos.m_7918_(0, 1, 0)) && ZombieUtils.isBlockBreakable(this.mob.m_9236_(), this.nextBlockPos.m_7918_(0, 1, 0))) {
                            return true;
                        }
                    } else if (nextPosY > mobY) {
                        if (ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), this.nextBlockPos) && ZombieUtils.isBlockBreakable(this.mob.m_9236_(), this.nextBlockPos)) {
                            return true;
                        }
                        if (ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), this.mob.m_20183_().m_7918_(0, 2, 0)) ? ZombieUtils.isBlockBreakable(this.mob.m_9236_(), this.mob.m_20183_().m_7918_(0, 2, 0)) : (ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), this.nextBlockPos.m_7918_(0, 1, 0)) ? ZombieUtils.isBlockBreakable(this.mob.m_9236_(), this.nextBlockPos.m_7918_(0, 1, 0)) : (Math.abs(this.mob.m_146903_() - this.nextBlockPos.m_123341_()) < 2 || Math.abs(this.mob.m_146907_() - this.nextBlockPos.m_123343_()) < 2) && ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), this.mob.m_20183_().m_7918_(0, 2, 0)) && ZombieUtils.isBlockBreakable(this.mob.m_9236_(), this.mob.m_20183_().m_7918_(0, 2, 0)))) {
                            return true;
                        }
                    } else {
                        if (ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), this.nextBlockPos) && ZombieUtils.isBlockBreakable(this.mob.m_9236_(), this.nextBlockPos)) {
                            return true;
                        }
                        if (ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), this.nextBlockPos.m_7918_(0, 1, 0)) && ZombieUtils.isBlockBreakable(this.mob.m_9236_(), this.nextBlockPos.m_7918_(0, 1, 0))) {
                            return true;
                        }
                        if (ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), this.nextBlockPos.m_7918_(0, 2, 0)) && ZombieUtils.isBlockBreakable(this.mob.m_9236_(), this.nextBlockPos.m_7918_(0, 2, 0))) {
                            return true;
                        }
                    }
                }
                if (this.shouldPlaceBlock) {
                    return true;
                }
            }
            if (!ZombieUtils.isMobStandingOnAFullBlock((Mob)this.mob) && this.mob.m_9236_().m_8055_(this.mob.m_20183_()).m_60819_().m_76178_() && this.mob.m_9236_().m_8055_(this.mob.m_20183_().m_7918_(0, -1, 0)).m_60819_().m_76178_()) {
                return true;
            }
        }
        return false;
    }

    public void m_8056_() {
        this.mob.m_21573_().m_26573_();
        this.tickCounter = 0;
        this.isBreakingBlock = false;
        this.shouldPlaceBlock = false;
        this.placeBlockTick = 0;
        this.heldItem = this.mob.m_21120_(InteractionHand.MAIN_HAND);
        this.mob.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42385_));
        ((IZombieHelper)this.mob).sevenDaysToSurvive$customGoalStarted();
    }

    public void m_8041_() {
        if (this.breakBlockBlockPos != null) {
            this.mob.m_9236_().m_6801_(this.mob.m_19879_(), this.breakBlockBlockPos, -1);
        }
        if (this.nextBlockPos != null && !ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), this.nextBlockPos) && !ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), this.nextBlockPos.m_7918_(0, 1, 0))) {
            double nextBPY;
            double mobY = this.mob.m_20183_().m_123342_();
            if (mobY == (nextBPY = (double)this.nextBlockPos.m_123342_())) {
                ((IZombieHelper)this.mob).setSevenDaysToSurvive$dugNextBlockPos(this.nextBlockPos);
            } else if (nextBPY > mobY) {
                if (!ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), this.mob.m_20183_().m_7918_(0, 2, 0))) {
                    ((IZombieHelper)this.mob).setSevenDaysToSurvive$dugNextBlockPos(this.nextBlockPos);
                }
            } else if (!ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), this.nextBlockPos.m_7918_(0, 2, 0))) {
                ((IZombieHelper)this.mob).setSevenDaysToSurvive$dugNextBlockPos(this.nextBlockPos);
            }
        }
        this.mob.m_21008_(InteractionHand.MAIN_HAND, this.heldItem);
        ((IZombieHelper)this.mob).sevenDaysToSurvive$customGoalFinished();
    }

    public void m_8037_() {
        ++this.tickCounter;
        if (this.shouldPlaceBlock && this.placeBlockBlockPos != null) {
            if (this.placeBlockTick - 3 == this.tickCounter) {
                this.mob.m_6674_(this.mob.m_7655_());
                this.mob.m_9236_().m_7731_(this.placeBlockBlockPos, Blocks.f_50652_.m_49966_(), 3);
            }
            if (this.placeBlockTick == this.tickCounter) {
                this.shouldPlaceBlock = false;
                if (this.offHandHeldItem != null) {
                    this.mob.m_21008_(InteractionHand.OFF_HAND, this.offHandHeldItem);
                }
            }
        }
        if (this.isBreakingBlock) {
            if (!ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), this.breakBlockBlockPos) && !ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), this.breakBlockBlockPos.m_7918_(0, -1, 0))) {
                this.mob.m_21573_().m_26517_(this.speedModifier);
                this.isBreakingBlock = false;
            } else {
                this.mob.m_9236_().m_6801_(this.mob.m_19879_(), this.breakBlockBlockPos, (int)((this.blockBreakTime - (float)(this.breakBlockTick - this.tickCounter)) / this.blockBreakTime * 10.0f));
                this.mob.m_21573_().m_26517_(0.0);
                this.faceTarget(this.breakBlockBlockPos);
                if ((this.breakBlockTick - this.tickCounter) % 5 == 0) {
                    this.mob.m_6674_(this.mob.m_7655_());
                }
                if (this.tickCounter == this.breakBlockTick) {
                    this.breakBlock(this.breakBlockBlockPos);
                    this.mob.m_21573_().m_26517_(this.speedModifier);
                    this.isBreakingBlock = false;
                }
            }
        }
        if (!this.isBreakingBlock && this.tickCounter % 10 == 0 && ((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget() != null) {
            if (!ZombieUtils.isMobStandingOnAFullBlock((Mob)this.mob)) {
                if (!ZombieUtils.hasAFullBlockCollision((Mob)this.mob, this.mob.m_20183_())) {
                    this.startBreakingBlock(this.tickCounter, this.mob.m_20183_());
                } else if (!ZombieUtils.hasAFullBlockCollision((Mob)this.mob, this.mob.m_20183_().m_7918_(0, -1, 0))) {
                    this.startBreakingBlock(this.tickCounter, this.mob.m_20183_().m_7918_(0, -1, 0));
                }
            }
            if (this.nextBlockPos != null) {
                if (this.mob.m_9236_().m_8055_(this.nextBlockPos.m_7918_(0, -1, 0)).m_60734_() instanceof TrapDoorBlock) {
                    this.startBreakingBlock(this.tickCounter, this.nextBlockPos.m_7918_(0, -1, 0));
                }
                if (this.mob.m_9236_().m_8055_(this.mob.m_20183_().m_7918_(0, -1, 0)).m_60734_() instanceof TrapDoorBlock) {
                    this.startBreakingBlock(this.tickCounter, this.mob.m_20183_().m_7918_(0, -1, 0));
                }
                if (this.nextBlockPos.m_123341_() == this.mob.m_146903_() && this.nextBlockPos.m_123343_() == this.mob.m_146907_()) {
                    if (this.mob.m_146904_() > this.nextBlockPos.m_123342_()) {
                        if (ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), this.nextBlockPos)) {
                            this.startBreakingBlock(this.tickCounter, this.nextBlockPos);
                        }
                    } else if (this.mob.m_146904_() < this.nextBlockPos.m_123342_() && ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), this.nextBlockPos.m_7918_(0, 1, 0))) {
                        this.startBreakingBlock(this.tickCounter, this.nextBlockPos.m_7918_(0, 1, 0));
                    }
                } else if (this.nextBlockPos.m_123342_() == this.mob.m_146904_()) {
                    if (ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), this.nextBlockPos)) {
                        this.startBreakingBlock(this.tickCounter, this.nextBlockPos);
                    } else if (ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), this.nextBlockPos.m_7918_(0, 1, 0))) {
                        this.startBreakingBlock(this.tickCounter, this.nextBlockPos.m_7918_(0, 1, 0));
                    }
                } else if (this.nextBlockPos.m_123342_() < this.mob.m_146904_()) {
                    if (ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), this.nextBlockPos.m_7918_(0, 1, 0))) {
                        this.startBreakingBlock(this.tickCounter, this.nextBlockPos.m_7918_(0, 1, 0));
                    } else if (ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), this.nextBlockPos)) {
                        this.startBreakingBlock(this.tickCounter, this.nextBlockPos);
                    } else if (ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), this.nextBlockPos.m_7918_(0, 2, 0))) {
                        this.startBreakingBlock(this.tickCounter, this.nextBlockPos.m_7918_(0, 2, 0));
                    }
                } else if (this.nextBlockPos.m_123342_() > this.mob.m_146904_()) {
                    if (ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), this.nextBlockPos)) {
                        this.startBreakingBlock(this.tickCounter, this.nextBlockPos);
                    } else if (ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), this.nextBlockPos.m_7918_(0, 1, 0))) {
                        this.startBreakingBlock(this.tickCounter, this.nextBlockPos.m_7918_(0, 1, 0));
                    } else if (ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), this.mob.m_20183_().m_7918_(0, 2, 0))) {
                        this.startBreakingBlock(this.tickCounter, this.mob.m_20183_().m_7918_(0, 2, 0));
                    }
                }
            }
        }
    }

    private void startBreakingBlock(int currentTick, BlockPos blockPos) {
        ((IZombieHelper)this.mob).sevenDaysToSurvive$setBreakingBlockBP(blockPos);
        this.isBreakingBlock = true;
        float blockHardness = this.mob.m_9236_().m_8055_(blockPos).m_60800_((BlockGetter)this.mob.m_9236_(), blockPos);
        this.blockBreakTime = blockHardness * 50.0f / ((IZombieHelper)this.mob).sevenDaysToSurvive$getBlockBreakingSpeedModifier();
        if (this.blockBreakTime == 0.0f) {
            this.blockBreakTime = 1.0f;
        }
        this.breakBlockTick = currentTick + (int)this.blockBreakTime;
        this.breakBlockBlockPos = blockPos;
        if (blockPos.m_123341_() == this.mob.m_146903_() && blockPos.m_123343_() == this.mob.m_146907_()) {
            double distance = this.mob.m_20238_(this.mob.m_20183_().m_252807_());
            if (distance > 0.15) {
                double currentX = this.mob.m_20185_();
                double currentZ = this.mob.m_20189_();
                double offsetX = Math.floor(currentX) + 0.5 - currentX;
                double offsetZ = Math.floor(currentZ) + 0.5 - currentZ;
                this.mob.m_20256_(this.mob.m_20184_().m_82520_(offsetX * 0.1, 0.0, offsetZ * 0.1));
            }
            if (blockPos.m_123342_() == this.mob.m_146904_() - 1 && !ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), blockPos.m_7918_(0, -1, 0))) {
                this.placeBlockBlockPos = blockPos.m_7918_(0, -1, 0);
                this.shouldPlaceBlock = true;
                this.placeBlockTick = this.breakBlockTick + 5;
                this.offHandHeldItem = this.mob.m_21120_(InteractionHand.OFF_HAND);
                this.mob.m_21008_(InteractionHand.OFF_HAND, new ItemStack((ItemLike)Items.f_42594_));
            }
        }
    }

    private void breakBlock(BlockPos blockPos) {
        this.mob.m_9236_().m_46961_(blockPos, true);
        this.mob.m_9236_().m_5594_(null, blockPos, this.mob.m_9236_().m_8055_(blockPos).m_60827_().m_56775_(), this.mob.m_5720_(), 1.0f, 1.0f);
    }

    public void faceTarget(BlockPos blockPos) {
        double deltaX = blockPos.m_123341_() - this.mob.m_146903_();
        double deltaZ = blockPos.m_123343_() - this.mob.m_146907_();
        double yaw = Math.atan2(deltaZ, deltaX);
        yaw = Math.toDegrees(yaw) - 90.0;
        this.mob.m_146922_((float)yaw);
        this.mob.m_21563_().m_24964_(Vec3.m_82512_((Vec3i)blockPos));
    }
}

