/*
 * Decompiled with CFR 0.152.
 */
package net.zolton21.sevendaystosurvive.ai.goals;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.zolton21.sevendaystosurvive.config.CommonConfig;
import net.zolton21.sevendaystosurvive.helper.IZombieHelper;
import net.zolton21.sevendaystosurvive.helper.PlayerHelper;
import net.zolton21.sevendaystosurvive.utils.ZombieUtils;
import org.jetbrains.annotations.Nullable;

public class SearchAndGoToPlayerGoal
extends Goal {
    protected final double speedModifier;
    private final PathfinderMob mob;
    private int ticksUntilNextAttack;
    @Nullable
    private Path pathToPlayer;
    private long lastCanUseCheck;
    private boolean isMoving;
    private int notMovingTickCounter;
    private BlockPos mobBP;
    private boolean ranOnce;
    private LivingEntity modGoalTarget;

    public SearchAndGoToPlayerGoal(PathfinderMob creature, double speed) {
        this.mob = creature;
        this.speedModifier = speed;
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET, Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        long i = this.mob.m_9236_().m_46467_();
        if (i - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = i;
        if (((Boolean)CommonConfig.Server.ZOMBIES_BUILD_AND_DIG_ONLY_ON_OBLIVION_NIGHT.get()).booleanValue() && !ZombieUtils.isOblivionNight(this.mob.m_9236_())) {
            return false;
        }
        if (((IZombieHelper)this.mob).sevenDaysToSurvive$getIsWithinSynapticSealActivityRange()) {
            return false;
        }
        if (((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget() != null && PlayerHelper.isPlayerProtected((ServerPlayer)((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget())) {
            return false;
        }
        if (((IZombieHelper)this.mob).sevenDaysToSurvive$getMobHasPlayerTargetAndCanReach()) {
            return false;
        }
        if (((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget() == null) {
            return false;
        }
        if (!((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget().m_6084_() || ((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget().m_5833_() || ((ServerPlayer)((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget()).m_7500_()) {
            return false;
        }
        if (((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos() != null) {
            if (this.mob.m_9236_().m_8055_(((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_7918_(0, -1, 0)).m_60734_() instanceof TrapDoorBlock) {
                return false;
            }
            if (!this.mob.m_9236_().m_8055_(((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos()).m_60819_().m_76178_()) {
                return false;
            }
            if (!this.mob.m_9236_().m_8055_(((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_7918_(0, -1, 0)).m_60819_().m_76178_()) {
                return false;
            }
            if (!this.mob.m_9236_().m_8055_(((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_7918_(0, 1, 0)).m_60819_().m_76178_()) {
                return false;
            }
            if ((ZombieUtils.isMobStandingOnAFullBlock((Mob)this.mob) || ZombieUtils.hasAFullBlockCollision((Mob)this.mob, ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_7918_(0, -1, 0))) && ((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget() != null && ((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget().m_6084_()) {
                if (!ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_7918_(0, -1, 0))) {
                    if (this.mob.m_20183_().m_123342_() >= ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_123342_()) {
                        if (!ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_7918_(0, -2, 0))) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                }
                if (ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_7918_(0, 1, 0))) {
                    return false;
                }
                if (ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos())) {
                    return false;
                }
                return this.mob.m_20183_().m_123342_() >= ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_123342_() || !ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), this.mob.m_20183_().m_7918_(0, 2, 0));
            }
        }
        return false;
    }

    public boolean m_8045_() {
        double d0;
        double attackDistance;
        if (((IZombieHelper)this.mob).sevenDaysToSurvive$getIsWithinSynapticSealActivityRange()) {
            return false;
        }
        if (((Boolean)CommonConfig.Server.ZOMBIES_BUILD_AND_DIG_ONLY_ON_OBLIVION_NIGHT.get()).booleanValue() && !ZombieUtils.isOblivionNight(this.mob.m_9236_())) {
            return false;
        }
        if (((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget() != null && PlayerHelper.isPlayerProtected((ServerPlayer)((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget())) {
            return false;
        }
        if (((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget() != null && (attackDistance = this.mob.m_262793_(((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget())) <= (d0 = this.getAttackReachSqr(((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget()))) {
            return true;
        }
        if (((IZombieHelper)this.mob).sevenDaysToSurvive$getMobHasPlayerTargetAndCanReach()) {
            return false;
        }
        if (((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget() == null) {
            return false;
        }
        if (!((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget().m_6084_() || ((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget().m_5833_() || ((ServerPlayer)((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget()).m_7500_()) {
            return false;
        }
        if (((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget() != null && ((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget().m_6084_() && ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos() != null) {
            if (this.mob.m_9236_().m_8055_(((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_7918_(0, -1, 0)).m_60734_() instanceof TrapDoorBlock) {
                return false;
            }
            if (!this.mob.m_9236_().m_8055_(((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos()).m_60819_().m_76178_()) {
                return false;
            }
            if (!this.mob.m_9236_().m_8055_(((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_7918_(0, -1, 0)).m_60819_().m_76178_()) {
                return false;
            }
            if (!this.mob.m_9236_().m_8055_(((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_7918_(0, 1, 0)).m_60819_().m_76178_()) {
                return false;
            }
        }
        if (this.mob.m_21573_().m_26570_() != null) {
            if (this.mob.m_21573_().m_26577_()) {
                return false;
            }
            if (((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos() != null && this.mob.m_146904_() == ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_123342_() && !this.mob.m_21573_().m_26571_()) {
                return true;
            }
        }
        if (((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget() != null && ((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget().m_6084_()) {
            if (((IZombieHelper)this.mob).sevenDaysToSurvive$getPathToNextBlockPos() != null) {
                if (!ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_7918_(0, -1, 0))) {
                    if (this.mob.m_20183_().m_123342_() >= ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_123342_()) {
                        if (ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), this.mob.m_20183_().m_7918_(0, -1, 0)) && !ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_7918_(0, -2, 0))) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                }
                if (ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_7918_(0, 1, 0))) {
                    return false;
                }
                if (ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos())) {
                    return false;
                }
                if (this.mob.m_20183_().m_123342_() < ((IZombieHelper)this.mob).sevenDaysToSurvive$getNextBlockPos().m_123342_() && ZombieUtils.HasBlockEntityCollision(this.mob.m_9236_(), this.mob.m_20183_().m_7918_(0, 2, 0))) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public void m_8037_() {
        if (this.pathToPlayer != ((IZombieHelper)this.mob).getSevenDaysToSurvive$pathToTargetEntity()) {
            this.pathToPlayer = ((IZombieHelper)this.mob).getSevenDaysToSurvive$pathToTargetEntity();
            this.ranOnce = false;
        }
        if (((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget() != null) {
            this.moveTowardsPlayer();
            double d0 = this.mob.m_262793_(((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget());
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
            this.checkAndPerformAttack(((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget(), d0);
        }
        if (this.isMoving) {
            this.notMovingTickCounter = 0;
            if (this.mobBP == this.mob.m_20183_()) {
                this.isMoving = false;
            }
        } else {
            ++this.notMovingTickCounter;
            if (this.notMovingTickCounter >= 60) {
                ((IZombieHelper)this.mob).sevenDaysToSurvive$resetModGoalTargetAndNextBlockPos();
                this.m_8041_();
            }
            if (this.mobBP != this.mob.m_20183_()) {
                this.isMoving = true;
            }
        }
        this.mobBP = this.mob.m_20183_();
    }

    private void checkAndPerformAttack(LivingEntity target, double pDistToEnemySqr) {
        double d0 = this.getAttackReachSqr(target);
        if (pDistToEnemySqr <= d0) {
            this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            if (this.ticksUntilNextAttack <= 0) {
                this.ticksUntilNextAttack = this.m_183277_(20);
                this.mob.m_6674_(InteractionHand.MAIN_HAND);
                this.mob.m_7327_((Entity)target);
            }
        }
    }

    private double getAttackReachSqr(LivingEntity pAttackTarget) {
        return this.mob.m_20205_() * 2.0f * this.mob.m_20205_() * 2.0f + pAttackTarget.m_20205_();
    }

    public void m_8056_() {
        ((IZombieHelper)this.mob).sevenDaysToSurvive$customGoalStarted();
        this.mob.m_21573_().m_26573_();
        this.ranOnce = false;
        this.pathToPlayer = ((IZombieHelper)this.mob).getSevenDaysToSurvive$pathToTargetEntity();
        this.isMoving = true;
        this.notMovingTickCounter = 0;
        this.mobBP = this.mob.m_20183_();
        PathfinderMob pathfinderMob = this.mob;
        if (pathfinderMob instanceof Zombie) {
            Zombie zombie = (Zombie)pathfinderMob;
            zombie.m_21561_(true);
        }
    }

    public void moveTowardsPlayer() {
        if (((IZombieHelper)this.mob).getSevenDaysToSurvive$placedBlockBlockPos() != null && !this.mob.m_9236_().m_8055_(((IZombieHelper)this.mob).getSevenDaysToSurvive$placedBlockBlockPos()).m_60795_() || ((IZombieHelper)this.mob).getSevenDaysToSurvive$dugNextBlockPos() != null && this.mob.m_9236_().m_8055_(((IZombieHelper)this.mob).getSevenDaysToSurvive$dugNextBlockPos()).m_60795_()) {
            BlockPos nextBP = ((IZombieHelper)this.mob).getSevenDaysToSurvive$placedBlockBlockPos() != null ? ((IZombieHelper)this.mob).getSevenDaysToSurvive$placedBlockBlockPos().m_7918_(0, 1, 0) : ((IZombieHelper)this.mob).getSevenDaysToSurvive$dugNextBlockPos();
            Path path = this.mob.m_21573_().m_7864_(nextBP, 0);
            if (path != null) {
                this.mob.m_21573_().m_26536_(path, this.speedModifier);
                if (this.mob.m_21573_().m_26570_() != null && this.mob.m_21573_().m_26570_().m_77392_()) {
                    double distance = this.mob.m_20238_(path.m_77406_().m_252807_());
                    if (distance > 0.15) {
                        Vec3 multiplication = nextBP.m_252807_().m_82546_(this.mob.m_20183_().m_252807_()).m_82541_().m_82542_(0.1, 0.1, 0.1);
                        this.mob.m_20256_(multiplication);
                        this.mob.m_21563_().m_24964_(nextBP.m_252807_());
                    } else {
                        ((IZombieHelper)this.mob).setSevenDaysToSurvive$dugNextBlockPos(null);
                        ((IZombieHelper)this.mob).setSevenDaysToSurvive$placedBlockBlockPos(null);
                    }
                }
            }
        } else {
            this.modGoalTarget = ((IZombieHelper)this.mob).sevenDaysToSurvive$getModGoalTarget();
            if (this.pathToPlayer != null && this.notMovingTickCounter <= 40) {
                if (this.pathToPlayer.m_77403_()) {
                    this.mob.m_21573_().m_5624_((Entity)this.modGoalTarget, this.speedModifier);
                } else {
                    this.runOnce();
                }
            } else {
                this.mob.m_21573_().m_5624_((Entity)this.modGoalTarget, this.speedModifier);
            }
        }
    }

    private void runOnce() {
        if (!this.ranOnce) {
            this.mob.m_21573_().m_26536_(this.pathToPlayer, this.speedModifier);
            this.ranOnce = true;
        }
    }

    public void m_8041_() {
        this.mob.m_21573_().m_26573_();
        PathfinderMob pathfinderMob = this.mob;
        if (pathfinderMob instanceof Zombie) {
            Zombie zombie = (Zombie)pathfinderMob;
            zombie.m_21561_(false);
        }
        ((IZombieHelper)this.mob).sevenDaysToSurvive$customGoalFinished();
        if (((IZombieHelper)this.mob).getSevenDaysToSurvive$placedBlockBlockPos() != null) {
            ((IZombieHelper)this.mob).setSevenDaysToSurvive$placedBlockBlockPos(null);
        }
        if (((IZombieHelper)this.mob).getSevenDaysToSurvive$dugNextBlockPos() != null) {
            ((IZombieHelper)this.mob).setSevenDaysToSurvive$dugNextBlockPos(null);
        }
    }
}

