/*
 * Decompiled with CFR 0.152.
 */
package net.zolton21.sevendaystosurvive.forge.block;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.zolton21.sevendaystosurvive.forge.blockentity.ForgeSynapticSealBlockEntity;
import net.zolton21.sevendaystosurvive.forge.registry.ForgeBlockEntityRegistry;
import net.zolton21.sevendaystosurvive.helper.IZombieHelper;
import net.zolton21.sevendaystosurvive.helper.PlayerHelper;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class ForgeSynapticSealBlock
extends BaseEntityBlock {
    public static final int MIN_SHARD_COUNT = 0;
    public static final int MAX_SHARD_COUNT = 8;
    public static final IntegerProperty ECHO_SHARD_COUNT = IntegerProperty.m_61631_((String)"echo_shard_count", (int)0, (int)8);
    public static final IntegerProperty STATE = IntegerProperty.m_61631_((String)"state", (int)0, (int)2);
    List<ServerPlayer> protectedPlayers = new ArrayList<ServerPlayer>();
    List<Monster> zombiesWithinRange = new ArrayList<Monster>();

    public ForgeSynapticSealBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)ECHO_SHARD_COUNT, (Comparable)Integer.valueOf(0))).m_61124_((Property)STATE, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{STATE}).m_61104_(new Property[]{ECHO_SHARD_COUNT});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)ECHO_SHARD_COUNT, (Comparable)Integer.valueOf(0))).m_61124_((Property)STATE, (Comparable)Integer.valueOf(0));
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        super.m_214162_(pState, pLevel, pPos, pRandom);
        if (pLevel.m_5776_()) {
            double radius = 0.5;
            DustParticleOptions particle = new DustParticleOptions(new Vector3f(0.161f, 0.874f, 0.922f), 1.0f);
            int particleCount = (Integer)pState.m_61143_((Property)ECHO_SHARD_COUNT) * 5;
            for (int i = 0; i < particleCount; ++i) {
                double theta = pRandom.m_188500_() * Math.PI;
                double phi = pRandom.m_188500_() * 2.0 * Math.PI;
                double x = (double)pPos.m_123341_() + 0.5 + radius * Math.sin(theta) * Math.cos(phi);
                double y = (double)pPos.m_123342_() + 0.5 + radius * Math.cos(theta);
                double z = (double)pPos.m_123343_() + 0.5 + radius * Math.sin(theta) * Math.sin(phi);
                pLevel.m_7106_((ParticleOptions)particle, x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (!pLevel.m_5776_()) {
            ItemStack itemStack = pPlayer.m_21205_();
            int value = (Integer)pState.m_61143_((Property)ECHO_SHARD_COUNT);
            if (itemStack.m_41720_() == Items.f_220224_) {
                if (value < 8) {
                    itemStack.m_41774_(1);
                    ++value;
                }
            } else if (itemStack.m_41619_() && pPlayer.m_6047_() && value > 0) {
                pPlayer.m_36356_(new ItemStack((ItemLike)Items.f_220224_));
                --value;
            }
            this.updateAndDisplayState(value, pPlayer, pState, pPos, pLevel);
        }
        return InteractionResult.SUCCESS;
    }

    private void updateAndDisplayState(int shardCountValue, Player pPlayer, BlockState state, BlockPos pPos, Level pLevel) {
        ChatFormatting chatFormatting;
        int range;
        if (shardCountValue < 4) {
            range = 0;
            pLevel.m_7731_(pPos, (BlockState)((BlockState)state.m_61124_((Property)STATE, (Comparable)Integer.valueOf(0))).m_61124_((Property)ECHO_SHARD_COUNT, (Comparable)Integer.valueOf(shardCountValue)), 3);
            chatFormatting = ChatFormatting.RED;
        } else if (shardCountValue < 8) {
            range = 1;
            pLevel.m_7731_(pPos, (BlockState)((BlockState)state.m_61124_((Property)STATE, (Comparable)Integer.valueOf(1))).m_61124_((Property)ECHO_SHARD_COUNT, (Comparable)Integer.valueOf(shardCountValue)), 3);
            chatFormatting = ChatFormatting.YELLOW;
        } else {
            range = 2;
            pLevel.m_7731_(pPos, (BlockState)((BlockState)state.m_61124_((Property)STATE, (Comparable)Integer.valueOf(2))).m_61124_((Property)ECHO_SHARD_COUNT, (Comparable)Integer.valueOf(shardCountValue)), 3);
            chatFormatting = ChatFormatting.GREEN;
        }
        MutableComponent text = Component.m_237113_((String)(shardCountValue + "/8   ")).m_130940_(chatFormatting);
        MutableComponent area = Component.m_237113_((String)(1 + 2 * range + "x" + (1 + 2 * range))).m_130940_(chatFormatting);
        pPlayer.m_5661_((Component)Component.m_237115_((String)"message.sevendaystosurvive.synaptic.seal.charge").m_7220_((Component)text).m_7220_((Component)Component.m_237115_((String)"message.sevendaystosurvive.synaptic.seal.safe.area")).m_130946_(": ").m_7220_((Component)area).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"message.sevendaystosurvive.synaptic.seal.chunks")), true);
    }

    public void m_6786_(LevelAccessor pLevel, BlockPos pPos, BlockState pState) {
        if (!pLevel.m_5776_()) {
            for (Player player : this.protectedPlayers) {
                if (player == null || !player.m_6084_()) continue;
                PlayerHelper.changePlayerProtectionState((ServerPlayer)player, false);
            }
            for (Monster monster : this.zombiesWithinRange) {
                if (monster == null || !monster.m_6084_()) continue;
                ((IZombieHelper)monster).sevenDaysToSurvive$setIsWithinSynapticSealActivityRange(false);
            }
            super.m_6786_(pLevel, pPos, pState);
            ItemStack drop = new ItemStack((ItemLike)Items.f_220224_, ((Integer)pState.m_61143_((Property)ECHO_SHARD_COUNT)).intValue());
            ForgeSynapticSealBlock.m_49840_((Level)((Level)pLevel), (BlockPos)pPos, (ItemStack)drop);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new ForgeSynapticSealBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pLevel.m_5776_()) {
            return null;
        }
        return ForgeSynapticSealBlock.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)ForgeBlockEntityRegistry.SYNAPTIC_SEAL.get()), (pLevel1, pPos, pState1, pBlockEntity) -> pBlockEntity.tick(pLevel1, pPos, pState1));
    }

    public void updateLists(List<ServerPlayer> list1, List<Monster> list2) {
        this.protectedPlayers.clear();
        this.zombiesWithinRange.clear();
        if (!list1.isEmpty()) {
            this.protectedPlayers.addAll(list1);
        }
        if (!list2.isEmpty()) {
            this.zombiesWithinRange.addAll(list2);
        }
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return Integer.min((Integer)state.m_61143_((Property)ECHO_SHARD_COUNT) * 2, 15);
    }
}

