/*
 * Decompiled with CFR 0.152.
 */
package net.zolton21.sevendaystosurvive.forge.blockentity;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.zolton21.sevendaystosurvive.config.CommonConfig;
import net.zolton21.sevendaystosurvive.forge.block.ForgeSynapticSealBlock;
import net.zolton21.sevendaystosurvive.forge.registry.ForgeBlockEntityRegistry;
import net.zolton21.sevendaystosurvive.helper.IZombieHelper;
import net.zolton21.sevendaystosurvive.helper.PlayerHelper;
import net.zolton21.sevendaystosurvive.utils.ZombieUtils;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ForgeSynapticSealBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    List<ServerPlayer> protectedPlayers = new CopyOnWriteArrayList<ServerPlayer>();
    List<Monster> zombiesWithinRange = new CopyOnWriteArrayList<Monster>();

    public ForgeSynapticSealBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ForgeBlockEntityRegistry.SYNAPTIC_SEAL.get(), pPos, pBlockState);
    }

    public List<Monster> zombiesWithinRange(BlockPos blockPos, BlockState blockState, ServerLevel world) {
        int activityRange = (Integer)blockState.m_61143_((Property)ForgeSynapticSealBlock.STATE);
        int blockChunkX = Math.floorDiv(blockPos.m_123341_(), 16);
        int blockChunkZ = Math.floorDiv(blockPos.m_123343_(), 16);
        int minChunkX = blockChunkX - activityRange;
        int maxChunkX = blockChunkX + activityRange;
        int minChunkZ = blockChunkZ - activityRange;
        int maxChunkZ = blockChunkZ + activityRange;
        int minWorldX = minChunkX * 16;
        int maxWorldX = (maxChunkX + 1) * 16 - 1;
        int minWorldZ = minChunkZ * 16;
        int maxWorldZ = (maxChunkZ + 1) * 16 - 1;
        AABB range = new AABB((double)minWorldX, (double)world.m_141937_(), (double)minWorldZ, (double)maxWorldX, (double)world.m_151558_(), (double)maxWorldZ);
        ArrayList<Monster> monsters = new ArrayList<Monster>();
        monsters.addAll(world.m_45976_(Zombie.class, range));
        monsters.addAll(world.m_45976_(Husk.class, range));
        return monsters;
    }

    public boolean isEntityWithinRange(BlockPos blockPos, BlockState blockState, ServerPlayer player) {
        int state = (Integer)blockState.m_61143_((Property)ForgeSynapticSealBlock.STATE);
        int activityRange = 0;
        int blockChunkX = Math.floorDiv(blockPos.m_123341_(), 16);
        int blockChunkZ = Math.floorDiv(blockPos.m_123343_(), 16);
        if (state == 1) {
            activityRange = 1;
        }
        if (state == 2) {
            activityRange = 2;
        }
        int minChunkX = blockChunkX - activityRange;
        int maxChunkX = blockChunkX + activityRange;
        int minChunkZ = blockChunkZ - activityRange;
        int maxChunkZ = blockChunkZ + activityRange;
        int playerChunkX = Math.floorDiv(player.m_146903_(), 16);
        int playerChunkZ = Math.floorDiv(player.m_146907_(), 16);
        return playerChunkX >= minChunkX && playerChunkX <= maxChunkX && playerChunkZ >= minChunkZ && playerChunkZ <= maxChunkZ;
    }

    public void tick(Level pLevel1, BlockPos pPos, BlockState pState1) {
        if (!ZombieUtils.isOblivionNight(this.m_58904_()) || ((Boolean)CommonConfig.Server.OBLIVION_NIGHT_SYNAPTIC_SEAL_WORKS.get()).booleanValue()) {
            for (Player player : pLevel1.m_6907_()) {
                if (player == null) continue;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (this.isEntityWithinRange(pPos, pState1, serverPlayer)) {
                    if (!serverPlayer.m_6084_() || !this.protectedPlayers.stream().noneMatch(p -> p.equals((Object)serverPlayer))) continue;
                    this.protectedPlayers.add(serverPlayer);
                    PlayerHelper.changePlayerProtectionState(serverPlayer, true);
                    continue;
                }
                if (!this.protectedPlayers.stream().anyMatch(p -> p.equals((Object)serverPlayer)) || !serverPlayer.m_6084_()) continue;
                this.protectedPlayers.remove(serverPlayer);
                PlayerHelper.changePlayerProtectionState(serverPlayer, false);
            }
            for (Monster zombie : this.zombiesWithinRange(pPos, pState1, (ServerLevel)pLevel1)) {
                if (zombie == null || zombie.m_6095_() != EntityType.f_20501_ && zombie.m_6095_() != EntityType.f_20458_ || !this.zombiesWithinRange.stream().noneMatch(z -> z.equals((Object)zombie)) || !zombie.m_6084_()) continue;
                this.zombiesWithinRange.add(zombie);
                ((IZombieHelper)zombie).sevenDaysToSurvive$setIsWithinSynapticSealActivityRange(true);
            }
            for (Monster zombie : this.zombiesWithinRange) {
                if (zombie == null || zombie.m_6095_() != EntityType.f_20501_ && zombie.m_6095_() != EntityType.f_20458_ || !this.zombiesWithinRange(pPos, pState1, (ServerLevel)pLevel1).stream().noneMatch(z -> z.equals((Object)zombie)) || !zombie.m_6084_()) continue;
                this.zombiesWithinRange.remove(zombie);
                ((IZombieHelper)zombie).sevenDaysToSurvive$setIsWithinSynapticSealActivityRange(false);
            }
            Block block = this.m_58900_().m_60734_();
            if (block instanceof ForgeSynapticSealBlock) {
                ((ForgeSynapticSealBlock)block).updateLists(this.protectedPlayers, this.zombiesWithinRange);
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private PlayState predicate(AnimationState<ForgeSynapticSealBlockEntity> synapticSealBlockEntityAnimationState) {
        synapticSealBlockEntityAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.synaptic_seal.idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

