/*
 * Decompiled with CFR 0.152.
 */
package net.zolton21.sevendaystosurvive.forge.events;

import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.zolton21.sevendaystosurvive.config.CommonConfig;
import net.zolton21.sevendaystosurvive.helper.IZombieHelper;
import net.zolton21.sevendaystosurvive.utils.ZombieUtils;

@Mod.EventBusSubscriber(modid="sevendaystosurvive", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ModForgeEvents {
    @SubscribeEvent
    public static void onPlayerSleep(PlayerSleepInBedEvent event) {
        Player player = event.getEntity();
        if (ZombieUtils.isOblivionNight(player.m_9236_())) {
            event.setResult(Player.BedSleepingProblem.OTHER_PROBLEM);
            player.m_5661_((Component)Component.m_237115_((String)"message.sevendaystosurvive.oblivion.night.sleep.problem"), true);
        }
    }

    @SubscribeEvent
    public static void onEntityChangeDimension(EntityTravelToDimensionEvent event) {
        int range = ZombieUtils.isOblivionNight(event.getEntity().m_9236_()) ? (Integer)CommonConfig.Server.PLAYER_DETECTION_RANGE_OBLIVION_NIGHT.get() : (Integer)CommonConfig.Server.PLAYER_DETECTION_RANGE.get();
        AABB AABBrange = new AABB((double)range, (double)range, (double)range, (double)(-range), (double)(-range), (double)(-range));
        ArrayList monsters = new ArrayList();
        monsters.addAll(event.getEntity().m_9236_().m_45976_(Zombie.class, AABBrange));
        monsters.addAll(event.getEntity().m_9236_().m_45976_(Husk.class, AABBrange));
        for (Monster monster : monsters) {
            if (!(monster instanceof Zombie)) continue;
            Zombie zombie = (Zombie)monster;
            ((IZombieHelper)zombie).sevenDaysToSurvive$resetModGoalTargetAndNextBlockPos();
        }
    }

    @SubscribeEvent
    public static void onZombieSpawn(EntityJoinLevelEvent event) {
        Zombie zombieTypeEntity;
        Entity mobEntity = event.getEntity();
        if (ZombieUtils.isOblivionNight(mobEntity.m_9236_()) && (mobEntity.m_6095_() == EntityType.f_20501_ || mobEntity.m_6095_() == EntityType.f_20458_) && mobEntity instanceof Zombie && !(zombieTypeEntity = (Zombie)mobEntity).m_6162_() && zombieTypeEntity.m_21051_(Attributes.f_22279_) != null && zombieTypeEntity.m_21051_(Attributes.f_22279_).m_22111_(ZombieUtils.speedBoostModifier.m_22209_()) == null) {
            zombieTypeEntity.m_21051_(Attributes.f_22279_).m_22125_(ZombieUtils.speedBoostModifier);
            ItemStack[] randomSet = ZombieUtils.getWeaponAndArmorSet();
            zombieTypeEntity.m_8061_(EquipmentSlot.HEAD, randomSet[0]);
            zombieTypeEntity.m_8061_(EquipmentSlot.CHEST, randomSet[1]);
            zombieTypeEntity.m_8061_(EquipmentSlot.LEGS, randomSet[2]);
            zombieTypeEntity.m_8061_(EquipmentSlot.FEET, randomSet[3]);
            zombieTypeEntity.m_8061_(EquipmentSlot.MAINHAND, randomSet[4]);
            zombieTypeEntity.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
            zombieTypeEntity.m_21409_(EquipmentSlot.HEAD, 0.0f);
            zombieTypeEntity.m_21409_(EquipmentSlot.CHEST, 0.0f);
            zombieTypeEntity.m_21409_(EquipmentSlot.LEGS, 0.0f);
            zombieTypeEntity.m_21409_(EquipmentSlot.FEET, 0.0f);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        long time;
        if (ZombieUtils.isOblivionNight(event.player.m_9236_()) && (time = event.player.m_9236_().m_46468_() % 24000L) >= 12000L && time <= 12200L) {
            MutableComponent text = Component.m_237115_((String)"message.sevendaystosurvive.oblivion.night.beginning").m_130940_(ChatFormatting.DARK_RED);
            event.player.m_5661_((Component)text, true);
        }
    }
}

