/*
 * Decompiled with CFR 0.152.
 */
package net.zolton21.sevendaystosurvive.mixin;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.zolton21.sevendaystosurvive.ai.goals.BuildTowardsTargetGoal;
import net.zolton21.sevendaystosurvive.ai.goals.DiggingGoal;
import net.zolton21.sevendaystosurvive.ai.goals.SearchAndGoToPlayerGoal;
import net.zolton21.sevendaystosurvive.config.CommonConfig;
import net.zolton21.sevendaystosurvive.helper.IZombieHelper;
import net.zolton21.sevendaystosurvive.utils.ZombieUtils;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Zombie.class})
public abstract class ZombieMixin
extends Monster
implements IZombieHelper {
    @Unique
    private boolean sevenDaysToSurvive$executingCustomGoal = false;
    @Unique
    @Nullable
    private Path sevenDaysToSurvive$pathToTargetEntity;
    @Unique
    @Nullable
    private LivingEntity sevenDaysToSurvive$modGoalTarget;
    @Unique
    @Nullable
    private BlockPos sevenDaysToSurvive$nextBlockPos;
    @Unique
    private float sevenDaysToSurvive$blockBreakingSpeedModifier;
    @Unique
    @Nullable
    private Path sevenDaysToSurvive$pathToNextBlockPos;
    @Unique
    private boolean sevenDaysToSurvive$isWithinSynapticSealActivityRange = false;
    @Unique
    @Nullable
    private BlockPos sevenDaysToSurvive$previousBlockPos;
    @Unique
    @Nullable
    private BlockPos sevenDaysToSurvive$placedBlockBlockPos;
    @Unique
    @Nullable
    private BlockPos sevenDaysToSurvive$dugNextBlockPos;
    @Unique
    private int sevenDaysToSurvive$ticksUntilNextPathRecalculation = 0;
    @Unique
    private boolean sevenDaysToSurvive$mobHasPlayerTargetAndCanReach = false;
    @Unique
    private long sevenDaysToSurvive$ticksUntilNextCustomPathSearch;
    @Unique
    @Nullable
    private BlockPos sevenDaysToSurvive$breakingBlockBP;
    @Unique
    private BlockPos sevenDaysToSurvive$mobCurrentBlockPostion;
    @Unique
    private long sevenDaysToSurvive$noMovementSinceTick;

    @Shadow
    protected abstract void m_8099_();

    @Shadow
    public abstract int m_213860_();

    @Shadow
    public abstract void m_8119_();

    protected ZombieMixin(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Inject(method={"addBehaviourGoals()V"}, at={@At(value="HEAD")})
    public void applyCustomAI(CallbackInfo ci) {
        if (this.m_6095_() == EntityType.f_20501_ || this.m_6095_() == EntityType.f_20458_) {
            this.f_21345_.m_25352_(3, (Goal)new DiggingGoal((PathfinderMob)this, 1.0));
            this.f_21345_.m_25352_(3, (Goal)new BuildTowardsTargetGoal((PathfinderMob)this, 1.0));
            this.f_21345_.m_25352_(3, (Goal)new SearchAndGoToPlayerGoal((PathfinderMob)this, 1.0));
            this.sevenDaysToSurvive$blockBreakingSpeedModifier = (float)Math.round((1.2f + new Random().nextFloat()) * 10.0f) / 10.0f;
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    public void tickInject(CallbackInfo ci) {
        if (this.m_6095_() == EntityType.f_20501_ || this.m_6095_() == EntityType.f_20458_) {
            this.sevenDaysToSurvive$additionalTickLogic();
        }
    }

    @Unique
    private void sevenDaysToSurvive$additionalTickLogic() {
        if (this.m_6084_()) {
            --this.sevenDaysToSurvive$ticksUntilNextPathRecalculation;
            if (this.m_21573_() instanceof GroundPathNavigation) {
                if (this.m_5448_() == null) {
                    if (!this.sevenDaysToSurvive$executingCustomGoal && this.f_19797_ % 60 == 0) {
                        this.sevenDaysToSurvive$findReachableTarget();
                    }
                } else if (this.sevenDaysToSurvive$getModGoalTarget() != this.m_5448_() && this.m_5448_() instanceof ServerPlayer) {
                    this.sevenDaysToSurvive$mobHasPlayerTargetAndCanReach = ZombieUtils.mobHasPlayerTargetAndCanReach((Mob)this);
                    this.sevenDaysToSurvive$modGoalTarget = this.m_5448_();
                }
                if (this.sevenDaysToSurvive$getModGoalTarget() != null) {
                    if (!this.sevenDaysToSurvive$getModGoalTarget().m_6084_() || this.sevenDaysToSurvive$getModGoalTarget().m_5833_() || ((ServerPlayer)this.sevenDaysToSurvive$getModGoalTarget()).m_7500_()) {
                        this.sevenDaysToSurvive$resetModGoalTargetAndNextBlockPos();
                    } else {
                        if (this.sevenDaysToSurvive$pathToTargetEntity == null || this.sevenDaysToSurvive$ticksUntilNextPathRecalculation <= 0) {
                            this.sevenDaysToSurvive$createPathToTargetEntity();
                        }
                        long i = this.m_9236_().m_46467_();
                        if (this.sevenDaysToSurvive$mobCurrentBlockPostion != this.m_20183_()) {
                            this.sevenDaysToSurvive$mobCurrentBlockPostion = this.m_20183_();
                            this.sevenDaysToSurvive$noMovementSinceTick = i;
                        }
                        if (this.f_19797_ % 40 == 0 && !this.sevenDaysToSurvive$mobHasPlayerTargetAndCanReach && this.sevenDaysToSurvive$canReachTarget(this.sevenDaysToSurvive$modGoalTarget)) {
                            this.m_6710_(this.sevenDaysToSurvive$modGoalTarget);
                        }
                        if (this.sevenDaysToSurvive$previousBlockPos != this.m_20183_()) {
                            this.sevenDaysToSurvive$findNextBlockPosition();
                            if (!this.sevenDaysToSurvive$executingCustomGoal && this.sevenDaysToSurvive$getNextBlockPos() != null) {
                                this.sevenDaysToSurvive$pathToNextBlockPos = this.m_21573_().m_7864_(this.sevenDaysToSurvive$getNextBlockPos(), 0);
                            }
                        } else if (i - this.sevenDaysToSurvive$ticksUntilNextCustomPathSearch > 60L) {
                            this.sevenDaysToSurvive$ticksUntilNextCustomPathSearch = i;
                            this.sevenDaysToSurvive$findNextBlockPosition();
                        }
                    }
                }
                if (this.f_19797_ % 500 == 0 && this.sevenDaysToSurvive$modGoalTarget != null) {
                    this.sevenDaysToSurvive$findReachableTarget();
                }
            }
        }
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    private void onLoad(CompoundTag tag, CallbackInfo ci) {
        if ((this.m_6095_() == EntityType.f_20501_ || this.m_6095_() == EntityType.f_20458_) && tag.m_128441_("BlockBreakingSpeedModifier")) {
            this.sevenDaysToSurvive$blockBreakingSpeedModifier = tag.m_128457_("BlockBreakingSpeedModifier");
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void onSave(CompoundTag tag, CallbackInfo ci) {
        if (this.m_6095_() == EntityType.f_20501_ || this.m_6095_() == EntityType.f_20458_) {
            tag.m_128350_("BlockBreakingSpeedModifier", this.sevenDaysToSurvive$blockBreakingSpeedModifier);
        }
    }

    public void m_6043_() {
        if (!(this.m_8077_() || this.m_6095_() != EntityType.f_20501_ && this.m_6095_() != EntityType.f_20458_ || this.sevenDaysToSurvive$modGoalTarget != null && this.m_9236_().m_46791_() != Difficulty.PEACEFUL)) {
            super.m_6043_();
        }
    }

    @Unique
    private boolean sevenDaysToSurvive$canReachTarget(LivingEntity livingEntity) {
        Path path;
        if (this.sevenDaysToSurvive$modGoalTarget != null && this.m_9236_().m_46472_() == this.sevenDaysToSurvive$modGoalTarget.m_9236_().m_46472_() && (path = this.m_21573_().m_6570_((Entity)livingEntity, 0)) != null && livingEntity.m_20183_().equals((Object)path.m_77406_())) {
            return path.m_77403_();
        }
        return false;
    }

    @Override
    public void sevenDaysToSurvive$customGoalStarted() {
        this.sevenDaysToSurvive$executingCustomGoal = true;
    }

    @Override
    public void sevenDaysToSurvive$customGoalFinished() {
        this.sevenDaysToSurvive$executingCustomGoal = false;
        this.sevenDaysToSurvive$createPathToTargetEntity();
    }

    @Unique
    public void sevenDaysToSurvive$findReachableTarget() {
        int range = ZombieUtils.isOblivionNight(this.m_9236_()) ? (Integer)CommonConfig.Server.PLAYER_DETECTION_RANGE_OBLIVION_NIGHT.get() : (Integer)CommonConfig.Server.PLAYER_DETECTION_RANGE.get();
        this.sevenDaysToSurvive$modGoalTarget = ZombieUtils.getNearestUnprotectedSurvivalPlayer((Mob)this, range);
    }

    @Unique
    public void sevenDaysToSurvive$findNextBlockPosition() {
        if (this.sevenDaysToSurvive$modGoalTarget != null) {
            this.sevenDaysToSurvive$previousBlockPos = this.m_20183_();
            if (this.m_146903_() == this.sevenDaysToSurvive$modGoalTarget.m_146903_() && this.m_146907_() == this.sevenDaysToSurvive$modGoalTarget.m_146907_()) {
                if (this.m_146904_() > this.sevenDaysToSurvive$modGoalTarget.m_146904_()) {
                    this.sevenDaysToSurvive$nextBlockPos = new BlockPos(this.m_146903_(), this.m_146904_() - 1, this.m_146907_());
                } else if (this.m_146904_() < this.sevenDaysToSurvive$modGoalTarget.m_146904_()) {
                    this.sevenDaysToSurvive$nextBlockPos = new BlockPos(this.m_146903_(), this.m_146904_() + 1, this.m_146907_());
                }
            } else {
                double absY;
                int y = this.m_146904_();
                int targetYPos = this.sevenDaysToSurvive$modGoalTarget.m_146904_();
                Direction.Axis axis = this.sevenDaysToSurvive$setAxis();
                Direction.AxisDirection axisDirection = this.sevenDaysToSurvive$setAxisDirection(axis);
                double absXZ = Math.abs(this.m_146903_() - this.sevenDaysToSurvive$modGoalTarget.m_146903_()) + Math.abs(this.m_146907_() - this.sevenDaysToSurvive$modGoalTarget.m_146907_());
                if (absXZ < (absY = (double)(Math.abs(this.m_146904_() - this.sevenDaysToSurvive$modGoalTarget.m_146904_()) + 1))) {
                    this.sevenDaysToSurvive$nextBlockPos = y < targetYPos ? new BlockPos(this.m_146903_(), y + 1, this.m_146907_()) : (y > targetYPos ? new BlockPos(this.m_146903_(), y - 1, this.m_146907_()) : new BlockPos(this.m_146903_(), y, this.m_146907_()));
                } else {
                    if (absXZ == absY) {
                        if (this.m_146904_() < targetYPos) {
                            ++y;
                        } else if (this.m_146904_() > targetYPos) {
                            --y;
                        }
                    }
                    if (axis == Direction.Axis.X) {
                        this.sevenDaysToSurvive$nextBlockPos = axisDirection == Direction.AxisDirection.POSITIVE ? new BlockPos(this.m_146903_() + 1, y, this.m_146907_()) : new BlockPos(this.m_146903_() - 1, y, this.m_146907_());
                    }
                    if (axis == Direction.Axis.Z) {
                        this.sevenDaysToSurvive$nextBlockPos = axisDirection == Direction.AxisDirection.POSITIVE ? new BlockPos(this.m_146903_(), y, this.m_146907_() + 1) : new BlockPos(this.m_146903_(), y, this.m_146907_() - 1);
                    }
                }
                if (this.sevenDaysToSurvive$nextBlockPos != null && this.m_9236_().m_8055_(this.sevenDaysToSurvive$nextBlockPos).m_280296_() && this.m_9236_().m_8055_(this.sevenDaysToSurvive$nextBlockPos).m_60800_((BlockGetter)this.m_9236_(), this.sevenDaysToSurvive$nextBlockPos) < 0.0f && this.m_9236_().m_8055_(this.sevenDaysToSurvive$nextBlockPos.m_6630_(1)).m_280296_()) {
                    this.sevenDaysToSurvive$nextBlockPos = this.m_9236_().m_8055_(this.sevenDaysToSurvive$nextBlockPos).m_60800_((BlockGetter)this.m_9236_(), this.sevenDaysToSurvive$nextBlockPos) >= 0.0f ? this.sevenDaysToSurvive$nextBlockPos.m_6630_(1) : this.m_20183_().m_7918_(0, 1, 0);
                }
            }
        }
    }

    @Override
    public Path sevenDaysToSurvive$getPathToNextBlockPos() {
        return this.sevenDaysToSurvive$pathToNextBlockPos;
    }

    @Unique
    private Direction.Axis sevenDaysToSurvive$setAxis() {
        Direction.Axis axis = Math.abs(this.m_20185_() - (double)((int)this.sevenDaysToSurvive$modGoalTarget.m_20185_())) >= Math.abs(this.m_20189_() - (double)((int)this.sevenDaysToSurvive$modGoalTarget.m_20189_())) ? Direction.Axis.X : Direction.Axis.Z;
        return axis;
    }

    @Unique
    private Direction.AxisDirection sevenDaysToSurvive$setAxisDirection(Direction.Axis direction) {
        Direction.AxisDirection axisDirection = direction == Direction.Axis.X ? ((double)((int)this.sevenDaysToSurvive$modGoalTarget.m_20185_()) - this.m_20185_() > 0.0 ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE) : ((double)((int)this.sevenDaysToSurvive$modGoalTarget.m_20189_()) - this.m_20189_() > 0.0 ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE);
        return axisDirection;
    }

    @Override
    public float sevenDaysToSurvive$getBlockBreakingSpeedModifier() {
        return this.sevenDaysToSurvive$blockBreakingSpeedModifier;
    }

    @Override
    public BlockPos sevenDaysToSurvive$getNextBlockPos() {
        return this.sevenDaysToSurvive$nextBlockPos;
    }

    @Override
    public LivingEntity sevenDaysToSurvive$getModGoalTarget() {
        return this.sevenDaysToSurvive$modGoalTarget;
    }

    @Override
    public void sevenDaysToSurvive$resetModGoalTargetAndNextBlockPos() {
        this.sevenDaysToSurvive$modGoalTarget = null;
        this.sevenDaysToSurvive$nextBlockPos = null;
        this.sevenDaysToSurvive$previousBlockPos = null;
        this.sevenDaysToSurvive$dugNextBlockPos = null;
        this.sevenDaysToSurvive$placedBlockBlockPos = null;
        this.sevenDaysToSurvive$pathToTargetEntity = null;
        this.sevenDaysToSurvive$pathToNextBlockPos = null;
        this.sevenDaysToSurvive$ticksUntilNextPathRecalculation = 0;
    }

    @Override
    public void sevenDaysToSurvive$setIsWithinSynapticSealActivityRange(boolean isTrue) {
        this.sevenDaysToSurvive$isWithinSynapticSealActivityRange = isTrue;
    }

    @Override
    public boolean sevenDaysToSurvive$getIsWithinSynapticSealActivityRange() {
        return this.sevenDaysToSurvive$isWithinSynapticSealActivityRange;
    }

    @Override
    public void setSevenDaysToSurvive$nextBlockPos(@Nullable BlockPos blockPos) {
        this.sevenDaysToSurvive$nextBlockPos = blockPos;
    }

    @Override
    public void setSevenDaysToSurvive$placedBlockBlockPos(@Nullable BlockPos blockPos) {
        this.sevenDaysToSurvive$placedBlockBlockPos = blockPos;
    }

    @Override
    public void setSevenDaysToSurvive$dugNextBlockPos(@Nullable BlockPos blockPos) {
        this.sevenDaysToSurvive$dugNextBlockPos = blockPos;
    }

    @Override
    @Nullable
    public BlockPos getSevenDaysToSurvive$placedBlockBlockPos() {
        return this.sevenDaysToSurvive$placedBlockBlockPos;
    }

    @Override
    @Nullable
    public BlockPos getSevenDaysToSurvive$dugNextBlockPos() {
        return this.sevenDaysToSurvive$dugNextBlockPos;
    }

    @Override
    @Nullable
    public Path getSevenDaysToSurvive$pathToTargetEntity() {
        return this.sevenDaysToSurvive$pathToTargetEntity;
    }

    @Override
    public void sevenDaysToSurvive$createPathToTargetEntity() {
        if (this.sevenDaysToSurvive$getModGoalTarget() != null) {
            this.sevenDaysToSurvive$pathToTargetEntity = this.m_21573_().m_6570_((Entity)this.sevenDaysToSurvive$getModGoalTarget(), 0);
        }
        this.sevenDaysToSurvive$ticksUntilNextPathRecalculation = 200;
    }

    @Override
    @Unique
    public boolean sevenDaysToSurvive$getMobHasPlayerTargetAndCanReach() {
        return this.sevenDaysToSurvive$mobHasPlayerTargetAndCanReach;
    }

    @Override
    public void sevenDaysToSurvive$setBreakingBlockBP(@Nullable BlockPos blockPos) {
        this.sevenDaysToSurvive$breakingBlockBP = blockPos;
    }

    public void m_6667_(DamageSource pDamageSource) {
        if (this.sevenDaysToSurvive$breakingBlockBP != null && !this.m_9236_().m_8055_(this.sevenDaysToSurvive$breakingBlockBP).m_60795_()) {
            this.m_9236_().m_6801_(this.m_19879_(), this.sevenDaysToSurvive$breakingBlockBP, -1);
        }
        super.m_6667_(pDamageSource);
    }

    @Override
    public long sevenDaysToSurvive$getNoMovementSinceTick() {
        return this.sevenDaysToSurvive$noMovementSinceTick;
    }
}

