/*
 * Decompiled with CFR 0.152.
 */
package net.zolton21.sevendaystosurvive.utils;

import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.zolton21.sevendaystosurvive.config.CommonConfig;
import net.zolton21.sevendaystosurvive.helper.PlayerHelper;
import org.jetbrains.annotations.NotNull;

public class ZombieUtils {
    public static final AttributeModifier speedBoostModifier = new AttributeModifier(UUID.fromString("e3689d2f-12c9-4af2-94bb-db025908da17"), "SpeedBoostModifier", (double)0.13f, AttributeModifier.Operation.ADDITION);

    public static boolean isBlockBreakable(Level level, BlockPos pos) {
        BlockState blockState = level.m_8055_(pos);
        ResourceLocation BlockId = level.m_9598_().m_175515_(Registries.f_256747_).m_7981_((Object)blockState.m_60734_());
        if (blockState.m_60800_((BlockGetter)level, pos) == -1.0f) {
            return false;
        }
        return BlockId == null || !((List)CommonConfig.Server.UNBREAKABLE_BLOCKS_LIST.get()).contains(BlockId.toString());
    }

    public static boolean mobHasPlayerTargetAndCanReach(Mob mob) {
        LivingEntity livingEntity;
        if (mob.m_5448_() != null && (livingEntity = mob.m_5448_()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            Path path = mob.m_21573_().m_7864_(player.m_20183_(), 0);
            if (path != null && path.m_77406_() == player.m_20183_()) {
                return path.m_77403_();
            }
        }
        return false;
    }

    public static boolean isMobStandingOnAFullBlock(Mob mob) {
        if (!ZombieUtils.hasAFullBlockCollision(mob, mob.m_20183_())) {
            return false;
        }
        return ZombieUtils.hasAFullBlockCollision(mob, mob.m_20183_().m_7918_(0, -1, 0));
    }

    public static boolean hasAFullBlockCollision(Mob mob, BlockPos blockPos) {
        BlockState blockState = mob.m_9236_().m_8055_(blockPos);
        if (blockState.m_60795_()) {
            return true;
        }
        VoxelShape collisionShape = blockState.m_60812_((BlockGetter)mob.m_9236_(), blockPos);
        return !collisionShape.m_83281_() && collisionShape.m_83215_().f_82292_ == 1.0;
    }

    public static boolean HasBlockEntityCollision(Level level, BlockPos blockPos) {
        BlockState blockState = level.m_8055_(blockPos);
        return !blockState.m_60742_((BlockGetter)level, blockPos, CollisionContext.m_82749_()).m_83281_();
    }

    public static ServerPlayer getNearestUnprotectedSurvivalPlayer(Mob mob, double range) {
        ServerPlayer nearestPlayer = null;
        if (mob.m_20194_() != null) {
            ServerLevel serverLevel = mob.m_20194_().m_129880_(mob.m_9236_().m_46472_());
            double closestDistance = Double.MAX_VALUE;
            if (serverLevel != null) {
                for (ServerPlayer player : serverLevel.m_6907_()) {
                    double distance;
                    if (player.m_9236_().m_46472_() != mob.m_9236_().m_46472_() || !((double)player.m_20270_((Entity)mob) <= range) || !player.m_6084_() || player.m_5833_() || player.m_7500_() || PlayerHelper.isPlayerProtected(player) || !((distance = mob.m_20280_((Entity)player)) < closestDistance)) continue;
                    closestDistance = distance;
                    nearestPlayer = player;
                }
            }
        }
        return nearestPlayer;
    }

    public static boolean isOblivionNight(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            long time = serverLevel.m_46468_() % 24000L;
            long daysPassed = serverLevel.m_46468_() / 24000L + 1L;
            if (daysPassed % (long)((Integer)CommonConfig.Server.OBLIVION_NIGHT_FREQUENCY.get()).intValue() == 0L && 12010L < time && time < 23991L) {
                return true;
            }
        }
        return false;
    }

    public static ItemStack @NotNull [] getWeaponAndArmorSet() {
        ItemStack[][] armorSets = new ItemStack[][]{{new ItemStack((ItemLike)Items.f_42407_), new ItemStack((ItemLike)Items.f_42408_), new ItemStack((ItemLike)Items.f_42462_), new ItemStack((ItemLike)Items.f_42463_), new ItemStack((ItemLike)Items.f_42425_)}, {new ItemStack((ItemLike)Items.f_42464_), new ItemStack((ItemLike)Items.f_42465_), new ItemStack((ItemLike)Items.f_42466_), new ItemStack((ItemLike)Items.f_42467_), new ItemStack((ItemLike)Items.f_42383_)}, {new ItemStack((ItemLike)Items.f_42468_), new ItemStack((ItemLike)Items.f_42469_), new ItemStack((ItemLike)Items.f_42470_), new ItemStack((ItemLike)Items.f_42471_), new ItemStack((ItemLike)Items.f_42383_)}};
        Random random = new Random();
        return armorSets[random.nextInt(armorSets.length)];
    }
}

