/*
 * Decompiled with CFR 0.152.
 */
package dev.foxgirl.pickaxetrims.shared;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.foxgirl.pickaxetrims.shared.PickaxeTrimsImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5244;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6899;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9299;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PickaxeTrim(@NotNull class_6880<class_1792> ingredient, boolean showInTooltip) implements class_9299
{
    @NotNull
    public static final Codec<PickaxeTrim> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_6899.method_40400((class_5321)class_7924.field_41197).fieldOf("ingredient").forGetter(PickaxeTrim::ingredient), (App)Codec.BOOL.optionalFieldOf("show_in_tooltip", (Object)true).forGetter(PickaxeTrim::showInTooltip)).apply((Applicative)instance, PickaxeTrim::new));
    @NotNull
    public static final class_9139<class_9129, PickaxeTrim> PACKET_CODEC = class_9139.method_56435((class_9139)class_9135.method_56383((class_5321)class_7924.field_41197), PickaxeTrim::ingredient, (class_9139)class_9135.field_48547, PickaxeTrim::showInTooltip, PickaxeTrim::new);
    private static final class_2561 UPGRADE_TEXT = class_2561.method_43471((String)class_156.method_646((String)"item", (class_2960)class_2960.method_60656((String)"smithing_template.upgrade"))).method_27692(class_124.field_1080);

    @Nullable
    public TrimType trimType() {
        return TrimType.from((class_1792)this.ingredient.comp_349());
    }

    @Nullable
    public static PickaxeTrim get(@NotNull class_1799 stack) {
        return (PickaxeTrim)stack.method_57824(PickaxeTrimsImpl.getInstance().getTrimComponentType());
    }

    @NotNull
    public static class_1799 set(@NotNull class_1799 stack, @NotNull PickaxeTrim trim) {
        stack.method_57379(PickaxeTrimsImpl.getInstance().getTrimComponentType(), (Object)trim);
        return stack;
    }

    @NotNull
    public static class_1799 set(@NotNull class_1799 stack, @NotNull TrimType trimType) {
        return PickaxeTrim.set(stack, new PickaxeTrim((class_6880<class_1792>)class_6880.method_40223((Object)trimType.getItem()), true));
    }

    @Nullable
    public static PickaxeType getPickaxeType(@Nullable class_1799 stack) {
        if (stack == null) {
            return null;
        }
        return PickaxeType.from(stack.method_7909());
    }

    @Nullable
    public static TrimType getTrimType(@Nullable class_1799 stack) {
        PickaxeTrim trim;
        if (stack != null && (trim = PickaxeTrim.get(stack)) != null) {
            return trim.trimType();
        }
        return null;
    }

    public static boolean isOfTrimType(@Nullable class_1799 stack, @NotNull TrimType trimType) {
        return PickaxeTrim.getTrimType(stack) == trimType;
    }

    public void method_57409(class_1792.class_9635 context, Consumer<class_2561> tooltip, class_1836 type) {
        TrimType trimType;
        if (this.showInTooltip && (trimType = this.trimType()) != null) {
            tooltip.accept(UPGRADE_TEXT);
            tooltip.accept((class_2561)class_5244.method_48320().method_10852(trimType.getMaterialText()));
            tooltip.accept((class_2561)class_5244.method_48320().method_10852(trimType.getDescriptionText()));
        }
    }

    public static enum TrimType {
        CRYING_OBSIDIAN{

            @NotNull
            public String toString() {
                return "crying_obsidian";
            }

            @Override
            @NotNull
            public class_1792 getItem() {
                return class_1802.field_22421;
            }

            @Override
            @NotNull
            public class_124 getColor() {
                return class_124.field_1064;
            }
        }
        ,
        LAPIS_LAZULI{

            @NotNull
            public String toString() {
                return "lapis_lazuli";
            }

            @Override
            @NotNull
            public class_1792 getItem() {
                return class_1802.field_8759;
            }

            @Override
            @NotNull
            public class_124 getColor() {
                return class_124.field_1078;
            }
        }
        ,
        EMERALD{

            @NotNull
            public String toString() {
                return "emerald";
            }

            @Override
            @NotNull
            public class_1792 getItem() {
                return class_1802.field_8687;
            }

            @Override
            @NotNull
            public class_124 getColor() {
                return class_124.field_1060;
            }
        }
        ,
        QUARTZ{

            @NotNull
            public String toString() {
                return "quartz";
            }

            @Override
            @NotNull
            public class_1792 getItem() {
                return class_1802.field_8155;
            }

            @Override
            @NotNull
            public class_124 getColor() {
                return class_124.field_1068;
            }
        }
        ,
        REDSTONE{

            @NotNull
            public String toString() {
                return "redstone";
            }

            @Override
            @NotNull
            public class_1792 getItem() {
                return class_1802.field_8725;
            }

            @Override
            @NotNull
            public class_124 getColor() {
                return class_124.field_1061;
            }
        }
        ,
        COPPER{

            @NotNull
            public String toString() {
                return "copper";
            }

            @Override
            @NotNull
            public class_1792 getItem() {
                return class_1802.field_27022;
            }

            @Override
            @NotNull
            public class_124 getColor() {
                return class_124.field_1065;
            }
        };

        @NotNull
        public static final List<TrimType> VALUES;
        public static final int COUNT;
        @NotNull
        private static final Map<String, TrimType> BY_NAME;

        @Nullable
        public static TrimType parse(@Nullable String name) {
            return BY_NAME.get(name);
        }

        @Nullable
        public static TrimType from(@NotNull class_1792 item) {
            if (item == class_1802.field_22421) {
                return CRYING_OBSIDIAN;
            }
            if (item == class_1802.field_8759) {
                return LAPIS_LAZULI;
            }
            if (item == class_1802.field_8687) {
                return EMERALD;
            }
            if (item == class_1802.field_8155) {
                return QUARTZ;
            }
            if (item == class_1802.field_8725) {
                return REDSTONE;
            }
            if (item == class_1802.field_27022) {
                return COPPER;
            }
            return null;
        }

        @NotNull
        public abstract class_1792 getItem();

        @NotNull
        public abstract class_124 getColor();

        @NotNull
        public class_2561 getMaterialText() {
            return class_2561.method_43471((String)("pickaxetrims.material." + String.valueOf((Object)this))).method_27692(this.getColor());
        }

        @NotNull
        public class_2561 getDescriptionText() {
            return class_2561.method_43471((String)("pickaxetrims.description." + String.valueOf((Object)this))).method_27692(this.getColor());
        }

        static {
            VALUES = ImmutableList.copyOf((Object[])TrimType.values());
            COUNT = VALUES.size();
            BY_NAME = (Map)class_156.method_654(new HashMap(), map -> {
                for (TrimType type : VALUES) {
                    map.put(type.toString(), type);
                }
            });
        }
    }

    public static enum PickaxeType {
        NETHERITE,
        DIAMOND,
        GOLD,
        IRON;

        @NotNull
        public static final List<PickaxeType> VALUES;
        public static final int COUNT;

        @Nullable
        private static PickaxeType from(@NotNull class_1792 item) {
            if (item == class_1802.field_22024) {
                return NETHERITE;
            }
            if (item == class_1802.field_8377) {
                return DIAMOND;
            }
            if (item == class_1802.field_8335) {
                return GOLD;
            }
            if (item == class_1802.field_8403) {
                return IRON;
            }
            return null;
        }

        @NotNull
        public class_1792 getItem() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> class_1802.field_22024;
                case 1 -> class_1802.field_8377;
                case 2 -> class_1802.field_8335;
                case 3 -> class_1802.field_8403;
            };
        }

        @NotNull
        public String toString() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "netherite_pickaxe";
                case 1 -> "diamond_pickaxe";
                case 2 -> "gold_pickaxe";
                case 3 -> "iron_pickaxe";
            };
        }

        static {
            VALUES = ImmutableList.copyOf((Object[])PickaxeType.values());
            COUNT = VALUES.size();
        }
    }
}

