/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.cannon;

import com.mojang.datafixers.util.Pair;
import net.mehvahdjukaar.supplementaries.common.block.cannon.CannonAccess;
import net.mehvahdjukaar.supplementaries.common.block.cannon.CannonTrajectory;
import net.mehvahdjukaar.supplementaries.common.block.cannon.CannonUtils;
import net.mehvahdjukaar.supplementaries.common.block.cannon.ShootingMode;
import net.mehvahdjukaar.supplementaries.common.block.tiles.CannonBlockTile;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_239;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_4184;
import net.minecraft.class_5250;
import net.minecraft.class_5498;
import net.minecraft.class_744;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class CannonController {
    protected static boolean isOnCannonBoat = false;
    protected static CannonAccess access;
    private static class_5498 lastCameraType;
    protected static class_239 hit;
    private static float yawIncrease;
    private static float pitchIncrease;
    private static boolean needsToUpdateServer;
    protected static ShootingMode shootingMode;
    @Nullable
    protected static CannonTrajectory trajectory;
    private static class_243 lastCameraPos;
    private static float lastZoomOut;
    private static float lastCameraYaw;
    private static float lastCameraPitch;
    protected static boolean showsTrajectory;

    public static void startControlling(CannonAccess cannonAccess) {
        class_310 mc = class_310.method_1551();
        if (access == null) {
            access = cannonAccess;
            shootingMode = cannonAccess.getInternalCannon().getTrajectoryData().drag() != 0.0f ? ShootingMode.DOWN : ShootingMode.STRAIGHT;
            lastCameraType = mc.field_1690.method_31044();
        }
        mc.field_1690.method_31043(class_5498.field_26665);
        class_5250 message = class_2561.method_43469((String)"message.supplementaries.cannon_maneuver", (Object[])new Object[]{mc.field_1690.field_1832.method_16007(), mc.field_1690.field_1886.method_16007()});
        mc.field_1705.method_1758((class_2561)message, false);
        mc.method_44713().method_37015((class_2561)message);
    }

    private static void stopControllingAndSync() {
        if (access == null) {
            return;
        }
        access.syncToServer(false, true);
        CannonController.stopControlling();
    }

    public static void stopControlling() {
        if (access == null) {
            return;
        }
        access = null;
        lastCameraYaw = 0.0f;
        lastCameraPitch = 0.0f;
        lastZoomOut = 0.0f;
        lastCameraPos = null;
        if (lastCameraType != null) {
            class_310.method_1551().field_1690.method_31043(lastCameraType);
        }
    }

    public static boolean isActive() {
        return access != null;
    }

    public static boolean setupCamera(class_4184 camera, class_1922 level, class_1297 entity, boolean detached, boolean thirdPersonReverse, float partialTick) {
        if (!CannonController.isActive()) {
            return false;
        }
        class_243 centerCannonPos = access.getCannonGlobalPosition(partialTick);
        if (lastCameraPos == null) {
            lastCameraPos = camera.method_19326();
            lastCameraYaw = camera.method_19330();
            lastCameraPitch = camera.method_19329();
        }
        class_243 targetCameraPos = centerCannonPos.method_1031(0.0, 2.0, 0.0);
        float targetYRot = camera.method_19330() + yawIncrease;
        float targetXRot = class_3532.method_15363((float)(camera.method_19329() + pitchIncrease), (float)-90.0f, (float)90.0f);
        camera.method_19322(targetCameraPos);
        camera.method_19325(targetYRot, targetXRot);
        lastCameraPos = camera.method_19326();
        lastCameraYaw = camera.method_19330();
        lastCameraPitch = camera.method_19329();
        lastZoomOut = camera.method_19318(4.0f);
        float horizontalOffset = -1.0f;
        camera.method_19324(-lastZoomOut, 0.0f, horizontalOffset);
        yawIncrease = 0.0f;
        pitchIncrease = 0.0f;
        CannonBlockTile cannonTile = access.getInternalCannon();
        if (!cannonTile.isFiring()) {
            class_243 lookDir2 = new class_243(camera.method_19335());
            float maxRange = 128.0f;
            class_243 actualCameraPos = camera.method_19326().method_1019(lookDir2.method_1029());
            class_243 endPos = actualCameraPos.method_1019(lookDir2.method_1021((double)maxRange));
            hit = level.method_17742(new class_3959(actualCameraPos, endPos, class_3959.class_3960.field_17559, class_3959.class_242.field_1347, entity));
            class_243 targetVector = hit.method_17784().method_1020(centerCannonPos);
            class_241 target = new class_241((float)class_3532.method_39241((double)targetVector.field_1352, (double)targetVector.field_1350), (float)targetVector.field_1351);
            target = target.method_35586(target.method_35581().method_35582(0.05f));
            float wantedCannonYaw = (float)Math.PI + (float)class_3532.method_15349((double)(-targetVector.field_1352), (double)targetVector.field_1350);
            Pair<CannonTrajectory, Float> comp = CannonUtils.computeTrajectory(access, hit.method_17784(), shootingMode);
            trajectory = (CannonTrajectory)comp.getFirst();
            float wantedYaw = ((Float)comp.getSecond()).floatValue();
            CannonController.updateCannonRenderAngles(partialTick, wantedYaw);
        }
        return true;
    }

    private static void updateCannonRenderAngles(float partialTick, float wantedYaw) {
        if (trajectory != null) {
            float followSpeed = 1.0f;
            CannonBlockTile cannon = access.getInternalCannon();
            cannon.setPitch(access, class_3532.method_17821((float)followSpeed, (float)cannon.getPitch(), (float)(trajectory.pitch() * 57.295776f)));
            cannon.setRenderYaw(access, wantedYaw * 57.295776f + access.getCannonGlobalYawOffset(partialTick));
        }
    }

    public static boolean onPlayerRotated(double yawAdd, double pitchAdd) {
        if (CannonController.isActive()) {
            float scale = 0.2f;
            yawIncrease += (float)(yawAdd * (double)scale);
            pitchIncrease += (float)(pitchAdd * (double)scale);
            if (yawAdd != 0.0 || pitchAdd != 0.0) {
                needsToUpdateServer = true;
            }
            if (isOnCannonBoat) {
                class_746 player = class_310.method_1551().field_1724;
                player.method_5872(class_3532.method_15338((double)((double)lastCameraYaw + yawAdd - (double)player.field_6241)), class_3532.method_15338((double)((double)lastCameraPitch + pitchAdd - (double)player.method_36455())));
                player.field_6259 = player.field_6241;
                player.field_6004 = player.method_36455();
            }
            return true;
        }
        return false;
    }

    public static void onKeyJump() {
        if (trajectory != null && trajectory.gravity() != 0.0f) {
            shootingMode = shootingMode.cycle();
            needsToUpdateServer = true;
        }
    }

    public static void onKeyInventory() {
        access.sendOpenGuiRequest();
    }

    public static void onKeyShift() {
        CannonController.stopControllingAndSync();
    }

    public static void onMouseScrolled(double scrollDelta) {
        if (scrollDelta != 0.0) {
            CannonBlockTile tile = access.getInternalCannon();
            byte newPower = (byte)(1 + Math.floorMod((int)((double)(tile.getPowerLevel() - 1) + scrollDelta), 4));
            tile.setPowerLevel(newPower);
            needsToUpdateServer = true;
        }
    }

    public static void onPlayerAttack() {
        if (access != null && access.getInternalCannon().readyToFire()) {
            access.syncToServer(true, false);
        }
    }

    public static void onPlayerUse() {
        showsTrajectory = !showsTrajectory;
    }

    public static void onInputUpdate(class_744 input) {
        if (!isOnCannonBoat) {
            input.field_3909 = false;
            input.field_3910 = false;
            input.field_3908 = false;
            input.field_3906 = false;
            input.field_3905 = 0.0f;
            input.field_3907 = 0.0f;
        }
        input.field_3903 = false;
        input.field_3904 = false;
    }

    public static void onClientTick(class_310 mc) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        isOnCannonBoat = player.method_5854() instanceof CannonAccess;
        if (!CannonController.isActive()) {
            return;
        }
        if (access.method_5443((class_1657)player)) {
            if (needsToUpdateServer) {
                needsToUpdateServer = false;
                access.syncToServer(false, false);
            }
        } else {
            CannonController.stopControllingAndSync();
        }
    }

    public static boolean onEarlyKeyPress(int key, int scanCode, int action, int modifiers) {
        if (!CannonController.isActive()) {
            return false;
        }
        if (action != 1) {
            return false;
        }
        class_315 options = class_310.method_1551().field_1690;
        if (key == 256) {
            CannonController.stopControllingAndSync();
            return true;
        }
        if (options.field_1822.method_1417(key, scanCode)) {
            CannonController.onKeyInventory();
            return true;
        }
        if (options.field_1903.method_1417(key, scanCode)) {
            CannonController.onKeyJump();
            return true;
        }
        if (options.field_1832.method_1417(key, scanCode)) {
            CannonController.onKeyShift();
            return true;
        }
        return false;
    }

    public static boolean rendersXpBar() {
        return CannonController.isActive() || isOnCannonBoat;
    }

    static {
        shootingMode = ShootingMode.DOWN;
        lastZoomOut = 0.0f;
        lastCameraYaw = 0.0f;
        lastCameraPitch = 0.0f;
        showsTrajectory = true;
    }
}

