/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import java.util.EnumMap;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.client.util.RenderUtil;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.mehvahdjukaar.supplementaries.client.GlobeManager;
import net.mehvahdjukaar.supplementaries.client.GlobeRenderData;
import net.mehvahdjukaar.supplementaries.client.renderers.NoiseRenderType;
import net.mehvahdjukaar.supplementaries.client.renderers.SphereRenderType;
import net.mehvahdjukaar.supplementaries.common.block.tiles.GlobeBlockTile;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.reg.ClientRegistry;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_284;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_5614;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class GlobeBlockTileRenderer
implements class_827<GlobeBlockTile> {
    private final Map<GlobeManager.Model, class_630> models = new EnumMap<GlobeManager.Model, class_630>(GlobeManager.Model.class);
    private final boolean noise;
    public static GlobeBlockTileRenderer INSTANCE = null;

    public static class_5607 createBaseMesh() {
        class_5609 mesh = new class_5609();
        class_5610 root = mesh.method_32111();
        root.method_32117("globe", class_5606.method_32108().method_32101(0, 0).method_32097(-4.0f, -28.0f, -4.0f, 8.0f, 8.0f, 8.0f), class_5603.method_32090((float)0.0f, (float)24.0f, (float)0.0f));
        return class_5607.method_32110((class_5609)mesh, (int)32, (int)16);
    }

    public static class_5607 createSpecialMesh() {
        class_5609 mesh = new class_5609();
        class_5610 root = mesh.method_32111();
        root.method_32117("flat", class_5606.method_32108().method_32101(0, 0).method_32097(-4.0f, -28.0f, -4.0f, 8.0f, 4.0f, 8.0f).method_32101(0, 13).method_32097(-4.0f, -24.0f, -4.0f, 8.0f, 2.0f, 8.0f).method_32101(4, 23).method_32097(-3.0f, -22.0f, -3.0f, 6.0f, 1.0f, 6.0f).method_32101(8, 24).method_32097(-2.0f, -21.0f, -2.0f, 4.0f, 1.0f, 4.0f), class_5603.method_32090((float)0.0f, (float)24.0f, (float)0.0f));
        root.method_32117("sheared", class_5606.method_32108().method_32101(0, 0).method_32097(-4.0f, -28.0f, -4.0f, 8.0f, 8.0f, 4.0f).method_32101(0, 12).method_32097(0.0f, -28.0f, 0.0f, 4.0f, 8.0f, 4.0f), class_5603.method_32090((float)0.0f, (float)24.0f, (float)0.0f));
        class_5610 snow = root.method_32117("snow", class_5606.method_32108().method_32101(0, 0).method_32097(-4.0f, -28.0f, -4.0f, 8.0f, 5.0f, 8.0f).method_32101(0, 14).method_32097(-4.0f, -23.0f, -4.0f, 8.0f, 1.0f, 8.0f).method_32101(4, 16).method_32097(-3.0f, -22.0f, -3.0f, 6.0f, 1.0f, 6.0f).method_32101(0, 17).method_32097(-2.0f, -24.0f, -2.0f, 4.0f, 1.0f, 4.0f).method_32101(0, 28).method_32097(-1.0f, -25.975f, -1.0f, 2.0f, 2.0f, 2.0f).method_32101(12, 20).method_32097(-1.0f, -21.0f, -1.0f, 2.0f, 1.0f, 2.0f), class_5603.method_32090((float)0.0f, (float)24.0f, (float)0.0f));
        snow.method_32117("roof_l", class_5606.method_32108().method_32101(11, 27).method_32097(0.0f, -1.0f, -1.0f, 2.0f, 1.0f, 2.0f), class_5603.method_32091((float)0.0f, (float)-25.9f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        snow.method_32117("roof_r", class_5606.method_32108().method_32101(0, 27).method_32097(-2.0f, -1.0f, -1.0f, 3.0f, 1.0f, 2.0f), class_5603.method_32091((float)0.0f, (float)-25.9f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        return class_5607.method_32110((class_5609)mesh, (int)32, (int)32);
    }

    public GlobeBlockTileRenderer(class_5614.class_5615 context) {
        class_630 model = context.method_32140(ClientRegistry.GLOBE_BASE_MODEL);
        this.models.put(GlobeManager.Model.GLOBE, model.method_32086("globe"));
        class_630 special = context.method_32140(ClientRegistry.GLOBE_SPECIAL_MODEL);
        this.models.put(GlobeManager.Model.FLAT, special.method_32086("flat"));
        this.models.put(GlobeManager.Model.SNOW, special.method_32086("snow"));
        this.models.put(GlobeManager.Model.SHEARED, special.method_32086("sheared"));
        INSTANCE = this;
        this.noise = MiscUtils.FESTIVITY.isAprilsFool();
    }

    public void render(GlobeBlockTile tile, float partialTicks, class_4587 poseStack, class_4597 bufferIn, int combinedLightIn, int combinedOverlayIn) {
        poseStack.method_22903();
        poseStack.method_22904(0.5, 0.5, 0.5);
        poseStack.method_22907(RotHlpr.rot((class_2350)tile.getDirection()));
        poseStack.method_22904(0.0, 0.0625, 0.0);
        poseStack.method_22907(RotHlpr.X22);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(90.0f - tile.getRotation(partialTicks)));
        this.renderGlobe(tile.getRenderData(), poseStack, bufferIn, combinedLightIn, combinedOverlayIn, tile.isSepia(), tile.method_10997());
        poseStack.method_22909();
    }

    public void renderGlobe(GlobeRenderData data, class_4587 poseStack, class_4597 buffer, int light, int overlay, boolean isSepia, class_1937 level) {
        class_4588 builder;
        poseStack.method_22903();
        poseStack.method_22907(RotHlpr.X180);
        GlobeManager.Model globeModel = data.getModel(isSepia);
        if (globeModel == GlobeManager.Model.ROUND || this.noise && isSepia) {
            poseStack.method_22907(RotHlpr.Z180);
            class_4588 builder2 = buffer.getBuffer(SphereRenderType.RENDER_TYPE.apply(data.getTexture(isSepia)));
            try {
                class_310 mc = class_310.method_1551();
                ClientRegistry.SPHERE_SHADER.get().method_34582("ScreenSize").method_35650(mc.method_22683().method_4489(), mc.method_22683().method_4506());
            }
            catch (Exception mc) {
                // empty catch block
            }
            GlobeBlockTileRenderer.addSphereQuad(poseStack, builder2, 0.65f, light);
            poseStack.method_22909();
            return;
        }
        if (this.noise) {
            double si = Math.sin((double)System.currentTimeMillis() / 8000.0) * 30.0;
            float v = (float)class_3532.method_15350((double)si, (double)-0.5, (double)0.5);
            float c = (float)class_3532.method_15350((double)si, (double)-2.0, (double)2.0);
            class_284 intensity = ClientRegistry.NOISE_SHADER.get().method_34582("Intensity");
            if (intensity != null) {
                intensity.method_1251(class_3532.method_15362((float)((float)Math.PI * c / 4.0f)));
            }
            poseStack.method_22905(v + 0.5f + 0.01f, 1.0f, 1.0f);
            builder = buffer.getBuffer(NoiseRenderType.RENDER_TYPE.apply(data.getTexture(isSepia)));
        } else if (globeModel == GlobeManager.Model.FLAT) {
            poseStack.method_22905(0.01f, 1.0f, 1.0f);
            globeModel = GlobeManager.DEFAULT_DATA.getModel(isSepia);
            class_1921 renderType = RenderUtil.getEntityCutoutMipmapRenderType((class_2960)GlobeManager.DEFAULT_DATA.getTexture(isSepia));
            builder = buffer.getBuffer(renderType);
        } else {
            class_1921 renderType = RenderUtil.getEntityCutoutMipmapRenderType((class_2960)data.getTexture(isSepia));
            builder = buffer.getBuffer(renderType);
        }
        class_630 model = this.models.get((Object)globeModel);
        model.method_22699(poseStack, builder, light, overlay, -1);
        poseStack.method_22909();
    }

    public static Vector3f getPitchAndYaw(Matrix4f m) {
        float roll;
        float yaw;
        float m02 = m.m02();
        float m12 = m.m12();
        float m22 = m.m22();
        float m01 = m.m01();
        float m11 = m.m11();
        float m21 = m.m21();
        float m00 = m.m00();
        float m10 = m.m10();
        float m20 = m.m20();
        float pitch = (float)Math.asin(-m12);
        if (Math.abs(m12) < 0.999f) {
            yaw = (float)Math.atan2(m02, m22);
            roll = (float)Math.atan2(m10, m11);
        } else {
            yaw = (float)Math.atan2(-m20, m00);
            roll = 0.0f;
        }
        return new Vector3f(pitch, yaw, roll);
    }

    private static void addSphereQuad(class_4587 stack, class_4588 consumer, float radius, int light) {
        Matrix4f matrix = stack.method_23760().method_23761();
        Vector3f sphereRot = GlobeBlockTileRenderer.getPitchAndYaw(matrix);
        Vector3f spherePos = matrix.transformPosition(new Vector3f(0.0f, 0.0f, 0.0f));
        matrix.setRotationYXZ(0.0f, 0.0f, 0.0f);
        class_310 mc = class_310.method_1551();
        class_4184 cam = mc.field_1773.method_19418();
        matrix.rotate((Quaternionfc)cam.method_23767());
        Vector3f v1 = matrix.transformPosition(new Vector3f(radius, radius, 0.0f));
        Vector3f centerRel1 = spherePos.sub((Vector3fc)v1, new Vector3f());
        consumer.method_22912(v1.x, v1.y, v1.z).method_22914(centerRel1.x, centerRel1.y, centerRel1.z).method_39415(-1).method_60803(light);
        GlobeBlockTileRenderer.addExtraVec3f(consumer, sphereRot);
        Vector3f v2 = matrix.transformPosition(new Vector3f(-radius, radius, 0.0f));
        Vector3f centerRel2 = spherePos.sub((Vector3fc)v2, new Vector3f());
        consumer.method_22912(v2.x, v2.y, v2.z).method_22914(centerRel2.x, centerRel2.y, centerRel2.z).method_39415(-1).method_60803(light);
        GlobeBlockTileRenderer.addExtraVec3f(consumer, sphereRot);
        Vector3f v3 = matrix.transformPosition(new Vector3f(-radius, -radius, 0.0f));
        Vector3f centerRel3 = spherePos.sub((Vector3fc)v3, new Vector3f());
        consumer.method_22912(v3.x, v3.y, v3.z).method_22914(centerRel3.x, centerRel3.y, centerRel3.z).method_39415(-1).method_60803(light);
        GlobeBlockTileRenderer.addExtraVec3f(consumer, sphereRot);
        Vector3f v4 = matrix.transformPosition(new Vector3f(radius, -radius, 0.0f));
        Vector3f centerRel4 = spherePos.sub((Vector3fc)v4, new Vector3f());
        consumer.method_22912(v4.x, v4.y, v4.z).method_22914(centerRel4.x, centerRel4.y, centerRel4.z).method_39415(-1).method_60803(light);
        GlobeBlockTileRenderer.addExtraVec3f(consumer, sphereRot);
    }

    private static void addExtraVec3f(class_4588 consumer, Vector3f vec) {
        consumer.method_22913(vec.x, vec.y);
        short[] shorts = GlobeBlockTileRenderer.floatToTwoShorts(vec.z);
        consumer.method_60796((int)shorts[0], (int)shorts[1]);
    }

    public static short[] floatToTwoShorts(float value) {
        int bits = Float.floatToIntBits(value);
        short high = (short)(bits >>> 16 & 0xFFFF);
        short low = (short)(bits & 0xFFFF);
        return new short[]{high, low};
    }
}

