/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.UUIDMap;
import io.github.kosmx.emotes.main.EmoteHolder;
import io.github.kosmx.emotes.main.network.ClientEmotePlay;
import java.util.LinkedList;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_7157;

public class ClientCommands {
    public static final class_2561 FORCED = class_2561.method_43471((String)"emotecraft.cant.override.forced");

    public static <T> void register(CommandDispatcher<T> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"emotes-client").then(class_2170.method_9247((String)"play").then(class_2170.method_9244((String)"emote", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new EmoteArgumentHelper()).executes(ctx -> {
            if (!ClientEmotePlay.clientStartLocalEmote(EmoteArgumentHelper.getEmote((CommandContext<class_2168>)ctx, "emote"))) {
                throw new SimpleCommandExceptionType((Message)FORCED).create();
            }
            return 0;
        })))).then(class_2170.method_9247((String)"stop").executes(ctx -> {
            if (ClientEmotePlay.isForcedEmote()) {
                throw new SimpleCommandExceptionType((Message)FORCED).create();
            }
            ClientEmotePlay.clientStopLocalEmote();
            return 0;
        })));
    }

    private static class EmoteArgumentHelper
    implements SuggestionProvider<class_2168> {
        private EmoteArgumentHelper() {
        }

        public CompletableFuture<Suggestions> getSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) {
            UUIDMap<EmoteHolder> emotes = EmoteHolder.list;
            LinkedList<String> suggestions = new LinkedList<String>();
            for (EmoteHolder emote : emotes.values()) {
                if (!emote.name.getString().isEmpty()) {
                    Object name = emote.name.getString();
                    if (((String)name).contains(" ")) {
                        name = "\"" + (String)name + "\"";
                    }
                    suggestions.add((String)name);
                    continue;
                }
                suggestions.add(emote.getUuid().toString());
            }
            return class_2172.method_9253((String[])((String[])suggestions.toArray(String[]::new)), (SuggestionsBuilder)builder);
        }

        public static KeyframeAnimation getEmote(CommandContext<class_2168> context, String argumentName) throws CommandSyntaxException {
            String id = StringArgumentType.getString(context, (String)argumentName);
            UUIDMap<EmoteHolder> emotes = EmoteHolder.list;
            try {
                UUID emoteID = UUID.fromString(id);
                EmoteHolder emote = (EmoteHolder)emotes.get((Object)emoteID);
                if (emote == null) {
                    throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)("No emote with ID: " + String.valueOf(emoteID)))).create();
                }
                return emote.getEmote();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                for (EmoteHolder emote : emotes.values()) {
                    if (!emote.name.getString().equals(id)) continue;
                    return emote.getEmote();
                }
                throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)("Not emote with name: " + id))).create();
            }
        }
    }
}

