/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block.entity;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.blay09.mods.balm.api.block.entity.CustomRenderBoundingBox;
import net.blay09.mods.balm.api.container.BalmContainerProvider;
import net.blay09.mods.balm.api.container.CombinedContainer;
import net.blay09.mods.balm.api.container.DefaultContainer;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.balm.api.provider.BalmProvider;
import net.blay09.mods.balm.common.BalmBlockEntity;
import net.blay09.mods.cookingforblockheads.api.CacheHint;
import net.blay09.mods.cookingforblockheads.api.IngredientToken;
import net.blay09.mods.cookingforblockheads.api.KitchenItemProvider;
import net.blay09.mods.cookingforblockheads.block.entity.IMutableNameable;
import net.blay09.mods.cookingforblockheads.block.entity.ModBlockEntities;
import net.blay09.mods.cookingforblockheads.block.entity.util.DoorAnimator;
import net.blay09.mods.cookingforblockheads.block.entity.util.TransferableBlockEntity;
import net.blay09.mods.cookingforblockheads.block.entity.util.TransferableContainer;
import net.blay09.mods.cookingforblockheads.kitchen.CombinedKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.kitchen.ConditionalKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.kitchen.ContainerKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.menu.FridgeMenu;
import net.blay09.mods.cookingforblockheads.sound.ModSounds;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class FridgeBlockEntity
extends BalmBlockEntity
implements BalmMenuProvider<class_2338>,
IMutableNameable,
BalmContainerProvider,
CustomRenderBoundingBox,
TransferableBlockEntity<TransferableContainer> {
    private final DefaultContainer container = new DefaultContainer(27){

        public void method_5431() {
            FridgeBlockEntity.this.isDirty = true;
            FridgeBlockEntity.this.method_5431();
        }
    };
    private final KitchenItemProvider iceUnitItemProvider = new KitchenItemProvider(this){
        private final Set<class_1799> providedItems = Set.of(new class_1799((class_1935)class_1802.field_8543), new class_1799((class_1935)class_1802.field_8246), new class_1799((class_1935)class_1802.field_8426));

        @Override
        public IngredientToken findIngredient(class_1856 ingredient, Collection<IngredientToken> ingredientTokens, CacheHint cacheHint) {
            for (class_1799 providedItem : this.providedItems) {
                if (!ingredient.method_8093(providedItem)) continue;
                return new IceUnitIngredientToken(providedItem);
            }
            return null;
        }

        @Override
        public IngredientToken findIngredient(class_1799 itemStack, Collection<IngredientToken> ingredientTokens, CacheHint cacheHint) {
            for (class_1799 providedItem : this.providedItems) {
                if (!class_1799.method_7984((class_1799)providedItem, (class_1799)itemStack)) continue;
                return new IceUnitIngredientToken(providedItem);
            }
            return null;
        }

        @Override
        public CacheHint getCacheHint(IngredientToken ingredientToken) {
            return CacheHint.NONE;
        }
    };
    private final ContainerKitchenItemProvider conservingItemProvider = new ContainerKitchenItemProvider(this, (class_1263)this.container){

        @Override
        protected int getUsesLeft(int slot, class_1799 slotStack, Collection<IngredientToken> ingredientTokens) {
            return super.getUsesLeft(slot, slotStack, ingredientTokens) - 1;
        }
    };
    private final ContainerKitchenItemProvider containerItemProvider = new ContainerKitchenItemProvider((class_1263)this.container);
    private final KitchenItemProvider itemProvider = new CombinedKitchenItemProvider(List.of(new ConditionalKitchenItemProvider<KitchenItemProvider>(this::hasIceUpgrade, this.iceUnitItemProvider), new ConditionalKitchenItemProvider<ContainerKitchenItemProvider>(this::hasPreservationUpgrade, this.conservingItemProvider, this.containerItemProvider)));
    private final DoorAnimator doorAnimator = new DoorAnimator((class_2586)this, 1, 2);
    private class_2561 customName;
    private boolean isDirty;
    public boolean hasIceUpgrade;
    public boolean hasPreservationUpgrade;

    public FridgeBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)ModBlockEntities.fridge.get(), pos, state);
        this.doorAnimator.setOpenRadius(2.0f);
        this.doorAnimator.setSoundEventOpen((class_3414)ModSounds.fridgeOpen.get());
        this.doorAnimator.setSoundEventClose((class_3414)ModSounds.fridgeClose.get());
    }

    public boolean hasIceUpgrade() {
        return this.hasIceUpgrade;
    }

    public void setHasIceUpgrade(boolean hasIceUpgrade) {
        this.hasIceUpgrade = hasIceUpgrade;
        this.markDirtyAndUpdate();
    }

    public boolean hasPreservationUpgrade() {
        return this.hasPreservationUpgrade;
    }

    public void setHasPreservationUpgrade(boolean hasPreservationUpgrade) {
        this.hasPreservationUpgrade = hasPreservationUpgrade;
        this.markDirtyAndUpdate();
    }

    public static void clientTick(class_1937 level, class_2338 pos, class_2680 state, FridgeBlockEntity blockEntity) {
        blockEntity.clientTick(level, pos, state);
    }

    public void clientTick(class_1937 level, class_2338 pos, class_2680 state) {
        this.doorAnimator.update();
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, FridgeBlockEntity blockEntity) {
        blockEntity.serverTick(level, pos, state);
    }

    public void serverTick(class_1937 level, class_2338 pos, class_2680 state) {
        if (this.isDirty) {
            this.sync();
            this.isDirty = false;
        }
    }

    public boolean method_11004(int id, int type) {
        return this.doorAnimator.receiveClientEvent(id, type) || super.method_11004(id, type);
    }

    protected void method_57568(class_2586.class_9473 input) {
        class_2561 customNameComponent = (class_2561)input.method_58694(class_9334.field_49631);
        if (customNameComponent != null) {
            this.customName = customNameComponent;
        }
    }

    protected void method_57567(class_9323.class_9324 builder) {
        builder.method_57840(class_9334.field_49631, (Object)this.customName);
    }

    public void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        this.container.deserialize(tag.method_10562("ItemHandler"), provider);
        this.hasIceUpgrade = tag.method_10577("HasIceUpgrade");
        this.hasPreservationUpgrade = tag.method_10577("HasPreservationUpgrade");
        if (tag.method_10573("CustomName", 8)) {
            this.customName = class_2561.class_2562.method_10877((String)tag.method_10558("CustomName"), (class_7225.class_7874)provider);
        }
        if (tag.method_10573("IsForcedOpen", 1)) {
            this.doorAnimator.setForcedOpen(tag.method_10577("IsForcedOpen"));
        }
        if (tag.method_10573("NumPlayersUsing", 1)) {
            this.doorAnimator.setNumPlayersUsing(tag.method_10571("NumPlayersUsing"));
        }
    }

    public void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        tag.method_10566("ItemHandler", (class_2520)this.container.serialize(provider));
        tag.method_10556("HasIceUpgrade", this.hasIceUpgrade);
        tag.method_10556("HasPreservationUpgrade", this.hasPreservationUpgrade);
        if (this.customName != null) {
            tag.method_10582("CustomName", class_2561.class_2562.method_10867((class_2561)this.customName, (class_7225.class_7874)provider));
        }
    }

    public void writeUpdateTag(class_2487 tag) {
        this.method_11007(tag, (class_7225.class_7874)this.field_11863.method_30349());
        tag.method_10556("IsForcedOpen", this.doorAnimator.isForcedOpen());
        tag.method_10567("NumPlayersUsing", (byte)this.doorAnimator.getNumPlayersUsing());
    }

    @Nullable
    public FridgeBlockEntity findNeighbourFridge() {
        class_2680 state = this.method_11010();
        class_2338 posBelow = this.field_11867.method_10074();
        class_2680 stateBelow = this.field_11863.method_8320(posBelow);
        class_2338 posAbove = this.field_11867.method_10084();
        class_2680 stateAbove = this.field_11863.method_8320(posAbove);
        if (stateAbove.method_26204() == state.method_26204()) {
            return (FridgeBlockEntity)this.field_11863.method_8321(posAbove);
        }
        if (stateBelow.method_26204() == state.method_26204()) {
            return (FridgeBlockEntity)this.field_11863.method_8321(posBelow);
        }
        return null;
    }

    public FridgeBlockEntity getBaseFridge() {
        FridgeBlockEntity baseFridge;
        if (!this.method_11002()) {
            return this;
        }
        class_2680 state = this.method_11010();
        class_2680 stateBelow = this.field_11863.method_8320(this.field_11867.method_10074());
        if (stateBelow.method_26204() == state.method_26204() && (baseFridge = (FridgeBlockEntity)this.field_11863.method_8321(this.field_11867.method_10074())) != null) {
            return baseFridge;
        }
        return this;
    }

    public List<BalmProvider<?>> getProviders() {
        return Lists.newArrayList((Object[])new BalmProvider[]{new BalmProvider(KitchenItemProvider.class, (Object)this.itemProvider)});
    }

    public DoorAnimator getDoorAnimator() {
        return this.doorAnimator;
    }

    public class_1263 getCombinedContainer() {
        FridgeBlockEntity baseFridge = this.getBaseFridge();
        FridgeBlockEntity neighbourFridge = baseFridge == this ? this.findNeighbourFridge() : this;
        if (neighbourFridge != null) {
            return new CombinedContainer(new class_1263[]{neighbourFridge.container, baseFridge.container});
        }
        return this.container;
    }

    public class_238 getRenderBoundingBox() {
        return new class_238(this.field_11867.method_10069(-1, 0, -1).method_46558(), this.field_11867.method_10069(2, 2, 2).method_46558());
    }

    public void markDirtyAndUpdate() {
        class_2680 state = this.field_11863.method_8320(this.field_11867);
        this.field_11863.method_8413(this.field_11867, state, state, 3);
        this.method_5431();
    }

    @Nullable
    public class_1703 createMenu(int i, class_1661 playerInventory, class_1657 playerEntity) {
        return new FridgeMenu(i, playerInventory, this);
    }

    public class_2561 method_5477() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    @Override
    public void setCustomName(class_2561 customName) {
        this.customName = customName;
        this.method_5431();
    }

    public boolean method_16914() {
        return this.customName != null;
    }

    @Nullable
    public class_2561 method_5797() {
        return this.customName;
    }

    public class_2561 method_5476() {
        return this.method_5477();
    }

    @Override
    public class_2561 getDefaultName() {
        return class_2561.method_43471((String)"container.cookingforblockheads.fridge");
    }

    public class_1263 getContainer() {
        return this.container;
    }

    public class_9139<class_9129, class_2338> getScreenStreamCodec() {
        return class_2338.field_48404.method_56430();
    }

    public class_2338 getScreenOpeningData(class_3222 serverPlayer) {
        return this.field_11867;
    }

    @Override
    public TransferableContainer snapshotDataForTransfer() {
        return TransferableContainer.copyAndClear((class_1263)this.container);
    }

    @Override
    public void restoreFromTransferSnapshot(TransferableContainer data) {
        data.applyTo((class_1263)this.container);
    }

    public record IceUnitIngredientToken(class_1799 itemStack) implements IngredientToken
    {
        @Override
        public class_1799 peek() {
            return this.itemStack;
        }

        @Override
        public class_1799 consume() {
            return this.itemStack;
        }

        @Override
        public class_1799 restore(class_1799 itemStack) {
            return class_1799.field_8037;
        }
    }
}

