/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.client.render;

import net.blay09.mods.cookingforblockheads.block.FridgeBlock;
import net.blay09.mods.cookingforblockheads.block.entity.FridgeBlockEntity;
import net.blay09.mods.cookingforblockheads.client.ModModels;
import net.blay09.mods.cookingforblockheads.client.render.RenderUtils;
import net.minecraft.class_1087;
import net.minecraft.class_1263;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_5819;
import net.minecraft.class_776;
import net.minecraft.class_7833;
import net.minecraft.class_827;

public class FridgeRenderer
implements class_827<FridgeBlockEntity> {
    private static final class_5819 random = class_5819.method_43047();

    public FridgeRenderer(class_5614.class_5615 context) {
    }

    public void render(FridgeBlockEntity tileEntity, float partialTicks, class_4587 poseStack, class_4597 buffer, int combinedLight, int combinedOverlay) {
        class_1937 level = tileEntity.method_10997();
        if (level == null) {
            return;
        }
        class_2680 state = tileEntity.method_11010();
        FridgeBlock.FridgeModelType fridgeModelType = (FridgeBlock.FridgeModelType)((Object)state.method_11654(FridgeBlock.MODEL_TYPE));
        if (fridgeModelType == FridgeBlock.FridgeModelType.LARGE_UPPER) {
            return;
        }
        float doorAngle = tileEntity.getDoorAnimator().getRenderAngle(partialTicks);
        this.renderDoor(level, tileEntity, poseStack, buffer, state, fridgeModelType, doorAngle);
        if (doorAngle > 0.0f) {
            poseStack.method_22903();
            poseStack.method_22904(0.0, 0.5, 0.0);
            RenderUtils.applyBlockAngle(poseStack, tileEntity.method_11010());
            poseStack.method_22905(0.3f, 0.3f, 0.3f);
            float topY = fridgeModelType == FridgeBlock.FridgeModelType.LARGE_LOWER ? 3.25f : 0.45f;
            class_1263 container = tileEntity.getCombinedContainer();
            for (int i = container.method_5439() - 1; i >= 0; --i) {
                float offsetZ;
                float offsetY;
                float offsetX;
                class_1799 itemStack = container.method_5438(i);
                if (itemStack.method_7960()) continue;
                if (fridgeModelType == FridgeBlock.FridgeModelType.LARGE_LOWER) {
                    rowIndex = i % 18;
                    offsetX = 0.7f - (float)(rowIndex % 9) * 0.175f;
                    offsetY = topY - (float)((int)((float)i / 18.0f)) * 1.25f;
                    offsetZ = 0.5f - (float)((int)((float)rowIndex / 9.0f)) * 0.9f;
                } else {
                    rowIndex = i % 13;
                    offsetX = 0.7f;
                    float spacing = 0.175f;
                    if (rowIndex / 9 > 0) {
                        offsetX -= 0.2f;
                        spacing *= 2.0f;
                    }
                    offsetX -= (float)(rowIndex % 9) * spacing;
                    offsetY = topY - (float)((int)((float)i / 14.0f)) * 1.25f;
                    offsetZ = 0.5f - (float)((int)((float)rowIndex / 9.0f)) * 0.9f;
                }
                poseStack.method_22903();
                poseStack.method_46416(offsetX, offsetY, offsetZ);
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(45.0f));
                RenderUtils.renderItem(itemStack, combinedLight, poseStack, buffer, level);
                poseStack.method_22909();
            }
            poseStack.method_22909();
        }
    }

    private void renderDoor(class_1937 level, FridgeBlockEntity tileEntity, class_4587 poseStack, class_4597 buffer, class_2680 state, FridgeBlock.FridgeModelType fridgeModelType, float doorAngle) {
        class_1087 lowerModel;
        class_1767 class_17672;
        boolean isFlipped = (Boolean)state.method_11654((class_2769)FridgeBlock.FLIPPED);
        boolean isLarge = fridgeModelType == FridgeBlock.FridgeModelType.LARGE_LOWER;
        poseStack.method_22903();
        RenderUtils.applyBlockAngle(poseStack, tileEntity.method_11010());
        poseStack.method_46416(-0.5f, 0.0f, -0.5f);
        float originX = 0.90625f;
        float originZ = 0.09375f;
        if (isFlipped) {
            originX = 1.0f - originX;
            doorAngle *= -1.0f;
        }
        poseStack.method_46416(originX, 0.0f, originZ);
        poseStack.method_22907(class_7833.field_40715.rotationDegrees((float)Math.toDegrees(doorAngle)));
        poseStack.method_46416(-originX, 0.0f, -originZ);
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof FridgeBlock) {
            FridgeBlock fridge = (FridgeBlock)class_22482;
            class_17672 = fridge.getColor();
        } else {
            class_17672 = class_1767.field_7952;
        }
        class_1767 blockColor = class_17672;
        int colorIndex = blockColor.method_7789();
        class_1087 upperModel = null;
        if (isLarge) {
            lowerModel = isFlipped ? (class_1087)ModModels.fridgeDoorsLargeLowerFlipped.get(colorIndex).get() : (class_1087)ModModels.fridgeDoorsLargeLower.get(colorIndex).get();
            upperModel = isFlipped ? (class_1087)ModModels.fridgeDoorsLargeUpperFlipped.get(colorIndex).get() : (class_1087)ModModels.fridgeDoorsLargeUpper.get(colorIndex).get();
        } else {
            lowerModel = isFlipped ? (class_1087)ModModels.fridgeDoorsFlipped.get(colorIndex).get() : (class_1087)ModModels.fridgeDoors.get(colorIndex).get();
        }
        class_776 dispatcher = class_310.method_1551().method_1541();
        dispatcher.method_3350().method_3374((class_1920)level, lowerModel, tileEntity.method_11010(), tileEntity.method_11016(), poseStack, buffer.getBuffer(class_1921.method_23577()), false, random, 0L, 0);
        if (upperModel != null) {
            poseStack.method_46416(0.0f, 1.0f, 0.0f);
            dispatcher.method_3350().method_3374((class_1920)level, upperModel, tileEntity.method_11010(), tileEntity.method_11016().method_10084(), poseStack, buffer.getBuffer(class_1921.method_23577()), false, random, 0L, 0);
        }
        poseStack.method_22909();
    }
}

