/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.crafting;

import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.cookingforblockheads.tag.ModItemTags;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_8786;
import net.minecraft.class_9129;
import org.jetbrains.annotations.Nullable;

public record RecipeWithStatus(class_2960 recipeId, class_1799 resultItem, List<class_1856> missingIngredients, int missingIngredientsMask, class_2371<class_1799> lockedInputs) {
    public class_8786<?> recipe(class_1657 player) {
        return player.method_37908().method_8433().method_8130(this.recipeId).orElse(null);
    }

    public void toNetwork(class_9129 buf) {
        buf.method_10812(this.recipeId);
        class_1799.field_48349.encode((Object)buf, (Object)this.resultItem);
        buf.method_53002(this.missingIngredientsMask);
        buf.method_53002(this.missingIngredients.size());
        for (class_1856 ingredient : this.missingIngredients) {
            class_1856.field_48355.encode((Object)buf, (Object)ingredient);
        }
        if (this.lockedInputs != null) {
            buf.method_53002(this.lockedInputs.size());
            for (class_1799 lockedInput : this.lockedInputs) {
                class_1799.field_49268.encode((Object)buf, (Object)lockedInput);
            }
        } else {
            buf.method_53002(0);
        }
    }

    public static RecipeWithStatus fromNetwork(class_9129 buf) {
        class_2960 recipeId = buf.method_10810();
        class_1799 resultItem = (class_1799)class_1799.field_48349.decode((Object)buf);
        int missingIngredientsMask = buf.readInt();
        int missingIngredientCount = buf.readInt();
        ArrayList<class_1856> missingIngredients = new ArrayList<class_1856>(missingIngredientCount);
        for (int j = 0; j < missingIngredientCount; ++j) {
            missingIngredients.add((class_1856)class_1856.field_48355.decode((Object)buf));
        }
        int lockedInputCount = buf.readInt();
        class_2371 lockedInputs = class_2371.method_10213((int)lockedInputCount, (Object)class_1799.field_8037);
        for (int j = 0; j < lockedInputCount; ++j) {
            lockedInputs.set(j, (Object)((class_1799)class_1799.field_49268.decode((Object)buf)));
        }
        return new RecipeWithStatus(recipeId, resultItem, missingIngredients, missingIngredientsMask, (class_2371<class_1799>)lockedInputs);
    }

    public static RecipeWithStatus best(@Nullable RecipeWithStatus first, @Nullable RecipeWithStatus second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        if (first.missingIngredients.size() < second.missingIngredients.size()) {
            return first;
        }
        if (second.missingIngredients.size() < first.missingIngredients.size()) {
            return second;
        }
        return first;
    }

    public boolean canCraft() {
        return this.missingIngredients.isEmpty();
    }

    public boolean isMissingUtensils() {
        return this.missingIngredients.stream().anyMatch(RecipeWithStatus::isUtensil);
    }

    private static boolean isUtensil(class_1856 ingredient) {
        for (class_1799 itemStack : ingredient.method_8105()) {
            if (!itemStack.method_31573(ModItemTags.UTENSILS)) continue;
            return true;
        }
        return false;
    }
}

