/*
 * Decompiled with CFR 0.152.
 */
package com.unrealdinnerbone.trenzalore.platform;

import com.unrealdinnerbone.trenzalore.api.platform.services.IPlatformHelper;
import com.unrealdinnerbone.trenzalore.api.registry.RegistryEntry;
import com.unrealdinnerbone.trenzalore.api.registry.RegistryObjects;
import com.unrealdinnerbone.trenzalore.lib.RLUtils;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;

public class FabricPlatformHelper
implements IPlatformHelper {
    private static final Map<class_5321<class_1761>, Event<ItemGroupEvents.ModifyEntries>> creativeTabEvents = new HashMap<class_5321<class_1761>, Event<ItemGroupEvents.ModifyEntries>>();

    @Override
    public String getPlatform() {
        return "Fabric";
    }

    @Override
    public Path getConfigPath() {
        return FabricLoader.getInstance().getConfigDir();
    }

    @Override
    public boolean isModLoaded(String modId) {
        return FabricLoader.getInstance().isModLoaded(modId);
    }

    @Override
    @ApiStatus.Internal
    public void addItemToCreativeTab(class_5321<class_1761> tabResourceKey, List<Supplier<? extends class_1792>> items) {
        if (!creativeTabEvents.containsKey(tabResourceKey)) {
            creativeTabEvents.put(tabResourceKey, (Event<ItemGroupEvents.ModifyEntries>)ItemGroupEvents.modifyEntriesEvent(tabResourceKey));
        }
        creativeTabEvents.get(tabResourceKey).register(entries -> items.forEach(itemSupplier -> entries.method_45421((class_1935)itemSupplier.get())));
    }

    @Override
    public <T> void registryRegistryObjects(String modId, RegistryObjects<T> registryObjects) {
        class_5321<class_2378<T>> registryKey = registryObjects.registryKey();
        class_2378 registry = (class_2378)class_7923.field_41167.method_10223(registryKey.method_29177());
        for (RegistryEntry<T> object : registryObjects.objects()) {
            class_2960 id = RLUtils.rl(modId, object.name());
            Object register = class_2378.method_10230((class_2378)registry, (class_2960)id, object.get());
            object.setHolder(class_6880.method_40223((Object)register));
        }
    }
}

